@extends('layouts.user')

@section('title', 'Operation Dashboard')

@section('content')
    <div class="space-y-6">
        <!-- Stat Cards -->
        <!-- Stat Cards -->
        <div class="grid grid-cols-1 md:grid-cols-3 lg:grid-cols-6 gap-4">
            <!-- Card 1 -->
            <div
                class="bg-gradient-to-br from-blue-500 to-blue-600 rounded-3xl p-5 text-white flex flex-col justify-between h-32 shadow-lg shadow-blue-200/50 transition-all hover:scale-[1.02]">
                <span class="text-[10px] font-bold uppercase tracking-widest opacity-80 leading-tight">Todays
                    Schedule</span>
                <div class="flex items-end justify-between">
                    <div class="p-2 bg-white/20 rounded-xl backdrop-blur-sm">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z">
                            </path>
                        </svg>
                    </div>
                    <span
                        class="text-4xl font-extrabold tracking-tight">{{ str_pad($todaysScheduleCount, 2, '0', STR_PAD_LEFT) }}</span>
                </div>
            </div>
            <!-- Card 2 -->
            <div
                class="bg-gradient-to-br from-orange-400 to-red-500 rounded-3xl p-5 text-white flex flex-col justify-between h-32 shadow-lg shadow-red-200/50 transition-all hover:scale-[1.02]">
                <span class="text-[10px] font-bold uppercase tracking-widest opacity-80 leading-tight">Upcoming
                    Schedule</span>
                <div class="flex items-end justify-between">
                    <div class="p-2 bg-white/20 rounded-xl backdrop-blur-sm">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <span
                        class="text-4xl font-extrabold tracking-tight">{{ str_pad($upcomingScheduleCount, 2, '0', STR_PAD_LEFT) }}</span>
                </div>
            </div>
            <!-- Card 3 -->
            <div
                class="bg-gradient-to-br from-red-500 to-rose-600 rounded-3xl p-5 text-white flex flex-col justify-between h-32 shadow-lg shadow-rose-200/50 transition-all hover:scale-[1.02] relative group">
                <span class="text-[10px] font-bold uppercase tracking-widest opacity-80 leading-tight">Expired
                    Licenses</span>
                <div class="flex items-end justify-between">
                    <div class="p-2 bg-white/20 rounded-xl backdrop-blur-sm">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z">
                            </path>
                        </svg>
                    </div>
                    <span
                        class="text-4xl font-extrabold tracking-tight">{{ str_pad($expiredLicenses->total(), 2, '0', STR_PAD_LEFT) }}</span>
                </div>
            </div>
            <!-- Card 4: Employees -->
            <div
                class="bg-gradient-to-br from-indigo-500 to-purple-600 rounded-3xl p-5 text-white flex flex-col justify-between h-32 shadow-lg shadow-indigo-200/50 transition-all hover:scale-[1.02]">
                <span class="text-[10px] font-bold uppercase tracking-widest opacity-80 leading-tight">Active
                    Employees</span>
                <div class="flex items-end justify-between">
                    <div class="p-2 bg-white/20 rounded-xl backdrop-blur-sm">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z">
                            </path>
                        </svg>
                    </div>
                    <span
                        class="text-4xl font-extrabold tracking-tight">{{ str_pad($employeeCount, 2, '0', STR_PAD_LEFT) }}</span>
                </div>
            </div>
            <!-- Card 5: Sites -->
            <div
                class="bg-gradient-to-br from-emerald-400 to-teal-600 rounded-3xl p-5 text-white flex flex-col justify-between h-32 shadow-lg shadow-emerald-200/50 transition-all hover:scale-[1.02]">
                <span class="text-[10px] font-bold uppercase tracking-widest opacity-80 leading-tight">Total Sites</span>
                <div class="flex items-end justify-between">
                    <div class="p-2 bg-white/20 rounded-xl backdrop-blur-sm">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4">
                            </path>
                        </svg>
                    </div>
                    <span
                        class="text-4xl font-extrabold tracking-tight">{{ str_pad($siteCount, 2, '0', STR_PAD_LEFT) }}</span>
                </div>
            </div>
            <!-- Card 6: Routes -->
            <div
                class="bg-gradient-to-br from-violet-500 to-indigo-700 rounded-3xl p-5 text-white flex flex-col justify-between h-32 shadow-lg shadow-violet-200/50 transition-all hover:scale-[1.02]">
                <span class="text-[10px] font-bold uppercase tracking-widest opacity-80 leading-tight">Strategic
                    Routes</span>
                <div class="flex items-end justify-between">
                    <div class="p-2 bg-white/20 rounded-xl backdrop-blur-sm">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M9 20l-5.447-2.724A1 1 0 013 16.382V5.618a1 1 0 011.447-.894L9 7m0 13l6-3m-6 3V7m6 10l4.553 2.276A1 1 0 0021 18.382V7.618a1 1 0 00-.553-.894L15 4m0 13V4m0 0L9 7">
                            </path>
                        </svg>
                    </div>
                    <span
                        class="text-4xl font-extrabold tracking-tight">{{ str_pad($routeCount, 2, '0', STR_PAD_LEFT) }}</span>
                </div>
            </div>
        </div>

        <!-- Patroller Operations Grid -->
        <h3 class="text-lg font-bold text-gray-800 mb-3 mt-6">Patroller Operations</h3>
        <div class="grid grid-cols-1 md:grid-cols-3 lg:grid-cols-5 gap-4 mb-8">
            <!-- Card 1: Today's Schedule -->
            <div
                class="bg-gradient-to-br from-cyan-500 to-blue-600 rounded-2xl p-4 text-white shadow-lg shadow-blue-200/50 flex flex-col justify-between h-28 relative overflow-hidden group hover:scale-[1.02] transition-all">
                <div
                    class="absolute right-0 top-0 w-24 h-24 bg-white/10 rounded-full -mr-12 -mt-12 transition-transform group-hover:scale-110">
                </div>
                <span class="text-[10px] font-bold uppercase tracking-widest opacity-90 relative z-10">Today's
                    Schedule</span>
                <div class="flex items-end justify-between relative z-10">
                    <div class="p-2 bg-white/20 rounded-lg backdrop-blur-sm">
                        <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z">
                            </path>
                        </svg>
                    </div>
                    <span
                        class="text-3xl font-black tracking-tight">{{ str_pad($todaysPatrollerCount ?? 0, 2, '0', STR_PAD_LEFT) }}</span>
                </div>
            </div>

            <!-- Card 2: Upcoming -->
            <div
                class="bg-gradient-to-br from-fuchsia-500 to-purple-600 rounded-2xl p-4 text-white shadow-lg shadow-purple-200/50 flex flex-col justify-between h-28 relative overflow-hidden group hover:scale-[1.02] transition-all">
                <div
                    class="absolute right-0 top-0 w-24 h-24 bg-white/10 rounded-full -mr-12 -mt-12 transition-transform group-hover:scale-110">
                </div>
                <span class="text-[10px] font-bold uppercase tracking-widest opacity-90 relative z-10">Upcoming</span>
                <div class="flex items-end justify-between relative z-10">
                    <div class="p-2 bg-white/20 rounded-lg backdrop-blur-sm">
                        <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <span
                        class="text-3xl font-black tracking-tight">{{ str_pad($upcomingPatrollerCount ?? 0, 2, '0', STR_PAD_LEFT) }}</span>
                </div>
            </div>

            <!-- Card 3: Active Jobs -->
            <div
                class="bg-gradient-to-br from-emerald-400 to-green-600 rounded-2xl p-4 text-white shadow-lg shadow-green-200/50 flex flex-col justify-between h-28 relative overflow-hidden group hover:scale-[1.02] transition-all">
                <div
                    class="absolute right-0 top-0 w-24 h-24 bg-white/10 rounded-full -mr-12 -mt-12 transition-transform group-hover:scale-110">
                </div>
                <span class="text-[10px] font-bold uppercase tracking-widest opacity-90 relative z-10">Active Jobs</span>
                <div class="flex items-end justify-between relative z-10">
                    <div class="p-2 bg-white/20 rounded-lg backdrop-blur-sm">
                        <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                        </svg>
                    </div>
                    <span
                        class="text-3xl font-black tracking-tight">{{ str_pad($activePatrollerCount ?? 0, 2, '0', STR_PAD_LEFT) }}</span>
                </div>
            </div>

            <!-- Card 4: Pending Start -->
            <div
                class="bg-gradient-to-br from-yellow-400 to-orange-500 rounded-2xl p-4 text-white shadow-lg shadow-orange-200/50 flex flex-col justify-between h-28 relative overflow-hidden group hover:scale-[1.02] transition-all">
                <div
                    class="absolute right-0 top-0 w-24 h-24 bg-white/10 rounded-full -mr-12 -mt-12 transition-transform group-hover:scale-110">
                </div>
                <span class="text-[10px] font-bold uppercase tracking-widest opacity-90 relative z-10">Pending Start
                    (Today)</span>
                <div class="flex items-end justify-between relative z-10">
                    <div class="p-2 bg-white/20 rounded-lg backdrop-blur-sm">
                        <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <span
                        class="text-3xl font-black tracking-tight">{{ str_pad($pendingPatrollerCount ?? 0, 2, '0', STR_PAD_LEFT) }}</span>
                </div>
            </div>

            <!-- Card 5: Completed -->
            <div
                class="bg-gradient-to-br from-gray-500 to-gray-700 rounded-2xl p-4 text-white shadow-lg shadow-gray-300/50 flex flex-col justify-between h-28 relative overflow-hidden group hover:scale-[1.02] transition-all">
                <div
                    class="absolute right-0 top-0 w-24 h-24 bg-white/10 rounded-full -mr-12 -mt-12 transition-transform group-hover:scale-110">
                </div>
                <span class="text-[10px] font-bold uppercase tracking-widest opacity-90 relative z-10">Completed
                    (Today)</span>
                <div class="flex items-end justify-between relative z-10">
                    <div class="p-2 bg-white/20 rounded-lg backdrop-blur-sm">
                        <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                        </svg>
                    </div>
                    <span
                        class="text-3xl font-black tracking-tight">{{ str_pad($completedPatrollerCount ?? 0, 2, '0', STR_PAD_LEFT) }}</span>
                </div>
            </div>
        </div>

        <!-- Live Activity Feed -->
        <div class="bg-white rounded-xl shadow-sm border border-slate-200 overflow-hidden mb-8">
            <div class="px-6 py-4 border-b border-slate-100 bg-slate-50/50 flex items-center justify-between">
                <div class="flex items-center gap-2">
                    <div class="relative flex h-2 w-2">
                        <span
                            class="animate-ping absolute inline-flex h-full w-full rounded-full bg-blue-400 opacity-75"></span>
                        <span class="relative inline-flex rounded-full h-2 w-2 bg-blue-600"></span>
                    </div>
                    <h3 class="font-black text-slate-900 text-xs uppercase tracking-widest">Live Activity Feed</h3>
                </div>
                <div class="flex items-center gap-2">
                    <span class="flex h-1.5 w-1.5 rounded-full bg-emerald-500"></span>
                    <span class="text-[9px] font-black text-slate-400 uppercase tracking-widest">Monitoring Live
                        Signals</span>
                </div>
            </div>
            <div class="p-6 max-h-[500px] overflow-y-auto scrollbar-hide" id="live-activity-feed">
                <!-- Loader initially -->
                <div class="flex flex-col items-center justify-center py-12">
                    <div class="w-8 h-8 border-2 border-blue-600/20 border-t-blue-600 rounded-full animate-spin mb-3"></div>
                    <p class="text-[10px] font-black text-slate-400 uppercase tracking-widest">Establishing Secure Feed...
                    </p>
                </div>
            </div>
        </div>


        <!-- Cancellation Requests -->
        @if(isset($cancellationRequests) && $cancellationRequests->count() > 0)
            <div class="bg-white rounded-xl shadow-sm border border-amber-200 overflow-hidden">
                <div class="px-6 py-4 border-b border-amber-100 bg-amber-50 flex items-center justify-between">
                    <div class="flex items-center gap-2">
                        <svg class="w-5 h-5 text-amber-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z">
                            </path>
                        </svg>
                        <h3 class="font-bold text-amber-900 text-sm uppercase tracking-wider">Pending Cancellation Requests</h3>
                    </div>
                </div>
                <div class="divide-y divide-amber-50">
                    @foreach($cancellationRequests as $schedule)
                        @foreach($schedule->employees as $emp)
                            <div class="p-4 flex flex-col md:flex-row items-start md:items-center justify-between gap-4">
                                <div class="flex-1">
                                    <div class="flex items-center gap-2 mb-1">
                                        <span class="font-bold text-gray-900 text-sm">{{ $emp->first_name }}
                                            {{ $emp->last_name }}</span>
                                        <span class="text-xs text-gray-500">requests to cancel</span>
                                        <span class="font-bold text-gray-800 text-sm">Duty #{{ $schedule->duty_number }}</span>
                                    </div>
                                    <div class="text-xs text-gray-500 mb-1">
                                        <span class="font-semibold">{{ $schedule->site->name }}</span> •
                                        {{ $schedule->from_datetime->format('M d, H:i') }}
                                    </div>
                                    @if($emp->pivot->cancellation_reason)
                                        <div class="text-xs text-amber-700 bg-amber-50 p-2 rounded border border-amber-100 italic">
                                            "{{ $emp->pivot->cancellation_reason }}"
                                        </div>
                                    @endif
                                    <div class="text-[10px] text-gray-400 mt-1">Requested
                                        {{ \Carbon\Carbon::parse($emp->pivot->cancellation_requested_at)->diffForHumans() }}
                                    </div>
                                </div>
                                <div class="flex items-center gap-2">
                                    <form
                                        action="{{ route('schedules.cancel.reject', ['schedule' => $schedule->id, 'employee' => $emp->id]) }}"
                                        method="POST">
                                        @csrf
                                        <button type="submit"
                                            class="px-3 py-1.5 bg-gray-100 hover:bg-gray-200 text-gray-600 rounded text-xs font-bold uppercase tracking-wider transition-colors">
                                            Decline
                                        </button>
                                    </form>
                                    <form
                                        action="{{ route('schedules.cancel.approve', ['schedule' => $schedule->id, 'employee' => $emp->id]) }}"
                                        method="POST">
                                        @csrf
                                        <button type="submit"
                                            class="px-3 py-1.5 bg-green-600 hover:bg-green-700 text-white rounded text-xs font-bold uppercase tracking-wider transition-colors shadow-sm shadow-green-200">
                                            Approve & Release
                                        </button>
                                    </form>
                                </div>
                            </div>
                        @endforeach
                    @endforeach
                </div>
            </div>
        @endif

        <!-- Patroller Cancellation Requests -->
        @if(isset($patrollerCancellationRequests) && $patrollerCancellationRequests->count() > 0)
            <div class="bg-white rounded-xl shadow-sm border border-orange-200 overflow-hidden mb-8">
                <div class="px-6 py-4 border-b border-orange-100 bg-orange-50 flex items-center justify-between">
                    <div class="flex items-center gap-2">
                        <svg class="w-5 h-5 text-orange-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z">
                            </path>
                        </svg>
                        <h3 class="font-bold text-orange-900 text-sm uppercase tracking-wider">Pending Patroller Cancellation
                            Requests</h3>
                    </div>
                </div>
                <div class="divide-y divide-orange-50">
                    @foreach($patrollerCancellationRequests as $schedule)
                        @foreach($schedule->employees as $emp)
                            <div class="p-4 flex flex-col md:flex-row items-start md:items-center justify-between gap-4">
                                <div class="flex-1">
                                    <div class="flex items-center gap-2 mb-1">
                                        <span class="font-bold text-gray-900 text-sm">{{ $emp->first_name }}
                                            {{ $emp->last_name }}</span>
                                        <span class="text-xs text-gray-500">requests to cancel</span>
                                        <span class="font-bold text-gray-800 text-sm">Patrol Duty #{{ $schedule->duty_number }}</span>
                                    </div>
                                    <div class="text-xs text-gray-500 mb-1">
                                        <span class="font-semibold text-orange-600">{{ $schedule->route->name ?? 'N/A' }}</span> •
                                        {{ \Carbon\Carbon::parse($schedule->from_time)->format('M d, H:i') }}
                                    </div>
                                    @if($emp->pivot->cancellation_reason)
                                        <div class="text-xs text-orange-700 bg-orange-50 p-2 rounded border border-orange-100 italic">
                                            "{{ $emp->pivot->cancellation_reason }}"
                                        </div>
                                    @endif
                                    <div class="text-[10px] text-gray-400 mt-1">Requested
                                        {{ \Carbon\Carbon::parse($emp->pivot->cancellation_requested_at)->diffForHumans() }}
                                    </div>
                                </div>
                                <div class="flex items-center gap-2">
                                    <form
                                        action="{{ route('patroller-schedules.cancel.reject', ['patroller_schedule' => $schedule->id, 'employee' => $emp->id]) }}"
                                        method="POST">
                                        @csrf
                                        <button type="submit"
                                            class="px-3 py-1.5 bg-gray-100 hover:bg-gray-200 text-gray-600 rounded text-xs font-bold uppercase tracking-wider transition-colors">
                                            Decline
                                        </button>
                                    </form>
                                    <form
                                        action="{{ route('patroller-schedules.cancel.approve', ['patroller_schedule' => $schedule->id, 'employee' => $emp->id]) }}"
                                        method="POST">
                                        @csrf
                                        <button type="submit"
                                            class="px-3 py-1.5 bg-orange-600 hover:bg-orange-700 text-white rounded text-xs font-bold uppercase tracking-wider transition-colors shadow-sm shadow-orange-200">
                                            Approve & Release
                                        </button>
                                    </form>
                                </div>
                            </div>
                        @endforeach
                    @endforeach
                </div>
            </div>
        @endif



        <!-- Active Jobs Table -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden mb-6">
            <div class="px-6 py-4 border-b border-gray-100 bg-blue-50/50 flex items-center justify-between">
                <div class="flex items-center gap-2">
                    <div class="h-2 w-2 rounded-full bg-green-500 animate-pulse"></div>
                    <h3 class="font-bold text-gray-900 text-sm uppercase tracking-wider">Active Jobs</h3>
                </div>
                <span
                    class="text-xs font-bold text-blue-600 bg-blue-100 px-2 py-0.5 rounded-full">{{ $activeJobs->total() }}
                    Live</span>
            </div>
            <div class="overflow-x-auto">
                <table class="w-full text-left text-sm text-gray-600">
                    <thead class="bg-gray-50 text-[10px] uppercase font-black text-gray-400">
                        <tr>
                            <th class="px-6 py-3">Duty #</th>
                            <th class="px-6 py-3">Site</th>
                            <th class="px-6 py-3">Employee(s)</th>
                            <th class="px-6 py-3">Shift Time</th>
                            <th class="px-6 py-3 text-right">Started At</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100">
                        @forelse($activeJobs as $job)
                            <tr class="hover:bg-gray-50/50 transition-colors">
                                <td class="px-6 py-4 font-mono text-xs text-blue-600 font-bold">#{{ $job->duty_number }}</td>
                                <td class="px-6 py-4 font-bold text-gray-900">{{ $job->site->name }}</td>
                                <td class="px-6 py-4">
                                    @foreach($job->employees as $emp)
                                        <div class="flex items-center gap-2">
                                            <div
                                                class="w-5 h-5 rounded-full bg-gray-200 text-[9px] flex items-center justify-center font-bold text-gray-600">
                                                {{ substr($emp->first_name, 0, 1) }}
                                            </div>
                                            <span class="text-gray-700 font-medium">{{ $emp->first_name }}
                                                {{ $emp->last_name }}</span>
                                        </div>
                                    @endforeach
                                </td>
                                <td class="px-6 py-4 text-xs font-medium text-gray-500">
                                    {{ $job->from_datetime->format('H:i') }} - {{ $job->to_datetime->format('H:i') }}
                                </td>
                                <td class="px-6 py-4 text-right">
                                    @foreach($job->employees as $emp)
                                        @if($emp->pivot->actual_start_at)
                                            <div class="text-xs font-bold text-green-600">
                                                {{ \Carbon\Carbon::parse($emp->pivot->actual_start_at)->format('H:i') }}
                                            </div>
                                        @else
                                            <div class="text-[10px] text-gray-400 italic">Not checked in</div>
                                        @endif
                                    @endforeach
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="px-6 py-8 text-center text-gray-400 italic">No active jobs currently
                                    running.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            @if($activeJobs->hasPages())
                <div class="px-6 py-3 border-t border-gray-100 bg-gray-50/30">
                    {{ $activeJobs->appends(['scheduled_jobs_page' => request('scheduled_jobs_page')])->links() }}
                </div>
            @endif
        </div>

        <!-- Scheduled Jobs (Not Started) Table -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden mb-6">
            <div class="px-6 py-4 border-b border-gray-100 bg-amber-50/50 flex items-center justify-between">
                <div class="flex items-center gap-2">
                    <svg class="w-4 h-4 text-amber-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    <h3 class="font-bold text-gray-900 text-sm uppercase tracking-wider">Scheduled Today (Pending Start)
                    </h3>
                </div>
                <span
                    class="text-xs font-bold text-amber-600 bg-amber-100 px-2 py-0.5 rounded-full">{{ $scheduledJobsToday->total() }}
                    Pending</span>
            </div>
            <div class="overflow-x-auto">
                <table class="w-full text-left text-sm text-gray-600">
                    <thead class="bg-gray-50 text-[10px] uppercase font-black text-gray-400">
                        <tr>
                            <th class="px-6 py-3">Duty #</th>
                            <th class="px-6 py-3">Time</th>
                            <th class="px-6 py-3">Site</th>
                            <th class="px-6 py-3">Assigned Guard</th>
                            <th class="px-6 py-3">Contact</th>
                            <th class="px-6 py-3 text-right">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100">
                        @forelse($scheduledJobsToday as $job)
                            <tr class="hover:bg-gray-50/50 transition-colors">
                                <td class="px-6 py-4 font-mono text-xs text-amber-600 font-bold">#{{ $job->duty_number }}</td>
                                <td class="px-6 py-4 font-bold text-gray-800">
                                    {{ $job->from_datetime->format('H:i') }}
                                    <span
                                        class="text-xs font-normal text-gray-400 block">{{ $job->from_datetime->diffForHumans() }}</span>
                                </td>
                                <td class="px-6 py-4 font-bold text-gray-900">{{ $job->site->name }}</td>
                                <td class="px-6 py-4">
                                    @foreach($job->employees as $emp)
                                        <div class="flex items-center gap-2 mb-1">
                                            <div
                                                class="w-6 h-6 rounded-full bg-blue-50 text-blue-600 text-[10px] flex items-center justify-center font-bold border border-blue-100">
                                                {{ substr($emp->first_name, 0, 1) }}
                                            </div>
                                            <div>
                                                <div class="text-gray-900 font-bold text-xs">{{ $emp->first_name }}
                                                    {{ $emp->last_name }}
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                    @if($job->employees->isEmpty())
                                        <span class="text-red-400 text-xs italic">Unassigned</span>
                                    @endif
                                </td>
                                <td class="px-6 py-4">
                                    @foreach($job->employees as $emp)
                                        <div class="text-xs font-mono text-gray-600 flex items-center gap-1 mb-1">
                                            <svg class="w-3 h-3 text-gray-400" fill="none" stroke="currentColor"
                                                viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z">
                                                </path>
                                            </svg>
                                            {{ $emp->phone_number ?? '--' }}
                                        </div>
                                    @endforeach
                                </td>
                                <td class="px-6 py-4 text-right">
                                    <div class="flex flex-col gap-2 items-end">
                                        @foreach($job->employees as $emp)
                                            @if($emp->phone_number)
                                                <a href="tel:{{ $emp->phone_number }}"
                                                    class="px-3 py-1 bg-white border border-gray-200 text-gray-600 text-[10px] font-bold rounded hover:bg-green-50 hover:text-green-600 hover:border-green-200 transition-colors shadow-sm inline-flex items-center gap-1">
                                                    <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                            d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z">
                                                        </path>
                                                    </svg>
                                                    Call {{ $emp->first_name }}
                                                </a>
                                            @endif
                                        @endforeach
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="px-6 py-8 text-center text-gray-400 italic">No pending scheduled jobs for
                                    today.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            @if($scheduledJobsToday->hasPages())
                <div class="px-6 py-3 border-t border-gray-100 bg-gray-50/30">
                    {{ $scheduledJobsToday->appends(['active_jobs_page' => request('active_jobs_page')])->links() }}
                </div>
            @endif
        </div>

        <!-- Completed Jobs Today Table -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden mb-6">
            <div class="px-6 py-4 border-b border-gray-100 bg-green-50/50 flex items-center justify-between">
                <div class="flex items-center gap-2">
                    <svg class="w-4 h-4 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    <h3 class="font-bold text-gray-900 text-sm uppercase tracking-wider">Completed Today</h3>
                </div>
                <span
                    class="text-xs font-bold text-green-600 bg-green-100 px-2 py-0.5 rounded-full">{{ $completedJobsToday->total() }}
                    Done</span>
            </div>
            <div class="overflow-x-auto">
                <table class="w-full text-left text-sm text-gray-600">
                    <thead class="bg-gray-50 text-[10px] uppercase font-black text-gray-400">
                        <tr>
                            <th class="px-6 py-3">Duty #</th>
                            <th class="px-6 py-3">Site</th>
                            <th class="px-6 py-3">Employee(s)</th>
                            <th class="px-6 py-3">Shift Time</th>
                            <th class="px-6 py-3 text-right">Actual Hours</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100">
                        @forelse($completedJobsToday as $job)
                            <tr class="hover:bg-gray-50/50 transition-colors">
                                <td class="px-6 py-4 font-mono text-xs text-green-600 font-bold">#{{ $job->duty_number }}</td>
                                <td class="px-6 py-4 font-bold text-gray-900">{{ $job->site->name }}</td>
                                <td class="px-6 py-4">
                                    @foreach($job->employees as $emp)
                                        <div class="flex items-center gap-2">
                                            <div
                                                class="w-5 h-5 rounded-full bg-green-100 text-[9px] flex items-center justify-center font-bold text-green-700">
                                                {{ substr($emp->first_name, 0, 1) }}
                                            </div>
                                            <span class="text-gray-700 font-medium">{{ $emp->first_name }}
                                                {{ $emp->last_name }}</span>
                                        </div>
                                    @endforeach
                                </td>
                                <td class="px-6 py-4 text-xs font-medium text-gray-500">
                                    {{ $job->from_datetime->format('H:i') }} - {{ $job->to_datetime->format('H:i') }}
                                </td>
                                <td class="px-6 py-4 text-right">
                                    @foreach($job->employees as $emp)
                                        @if($emp->pivot->actual_start_at && $emp->pivot->actual_end_at)
                                            @php
                                                $start = \Carbon\Carbon::parse($emp->pivot->actual_start_at);
                                                $end = \Carbon\Carbon::parse($emp->pivot->actual_end_at);
                                                $totalMinutes = $start->diffInMinutes($end);
                                                $hrs = floor($totalMinutes / 60);
                                                $mins = $totalMinutes % 60;
                                            @endphp
                                            <div class="text-xs font-bold text-gray-800">
                                                {{ sprintf('%02d:%02d', $hrs, $mins) }}
                                            </div>
                                        @else
                                            <div class="text-[10px] text-gray-400 italic">Incomplete data</div>
                                        @endif
                                    @endforeach
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="px-6 py-8 text-center text-gray-400 italic">No completed jobs yet today.
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            @if($completedJobsToday->hasPages())
                <div class="px-6 py-3 border-t border-gray-100 bg-gray-50/30">
                    {{ $completedJobsToday->appends(['completed_jobs_page' => request('completed_jobs_page')])->links() }}
                </div>
            @endif
        </div>

        <!-- ========================================== -->
        <!-- PATROLLER SECTIONS -->
        <!-- ========================================== -->

        <!-- Active Patroller Jobs Table -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden mb-6">
            <div class="px-6 py-4 border-b border-gray-100 bg-cyan-50/50 flex items-center justify-between">
                <div class="flex items-center gap-2">
                    <div class="h-2 w-2 rounded-full bg-cyan-500 animate-pulse"></div>
                    <h3 class="font-bold text-gray-900 text-sm uppercase tracking-wider">Active Patroller Jobs</h3>
                </div>
                <span
                    class="text-xs font-bold text-cyan-600 bg-cyan-100 px-2 py-0.5 rounded-full">{{ $activePatrollerJobs->total() }}
                    Live</span>
            </div>
            <div class="overflow-x-auto">
                <table class="w-full text-left text-sm text-gray-600">
                    <thead class="bg-gray-50 text-[10px] uppercase font-black text-gray-400">
                        <tr>
                            <th class="px-6 py-3">Duty #</th>
                            <th class="px-6 py-3">Route</th>
                            <th class="px-6 py-3">Patroller(s)</th>
                            <th class="px-6 py-3">Shift Time</th>
                            <th class="px-6 py-3 text-right">Started At</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100">
                        @forelse($activePatrollerJobs as $job)
                            <tr class="hover:bg-gray-50/50 transition-colors">
                                <td class="px-6 py-4 font-mono text-xs text-cyan-600 font-bold">#{{ $job->duty_number }}</td>
                                <td class="px-6 py-4 font-bold text-gray-900">{{ $job->route->name ?? 'N/A' }}</td>
                                <td class="px-6 py-4">
                                    @foreach($job->employees as $emp)
                                        <div class="flex items-center gap-2">
                                            <div
                                                class="w-5 h-5 rounded-full bg-gray-200 text-[9px] flex items-center justify-center font-bold text-gray-600">
                                                {{ substr($emp->first_name, 0, 1) }}
                                            </div>
                                            <span class="text-gray-700 font-medium">{{ $emp->first_name }}
                                                {{ $emp->last_name }}</span>
                                        </div>
                                    @endforeach
                                </td>
                                <td class="px-6 py-4 text-xs font-medium text-gray-500">
                                    {{ \Carbon\Carbon::parse($job->from_time)->format('H:i') }} -
                                    {{ \Carbon\Carbon::parse($job->to_time)->format('H:i') }}
                                </td>
                                <td class="px-6 py-4 text-right">
                                    <div class="text-xs font-bold text-cyan-600">
                                        {{ $job->job_started_at ? \Carbon\Carbon::parse($job->job_started_at)->format('H:i') : '--:--' }}
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="px-6 py-8 text-center text-gray-400 italic">No active patroller jobs
                                    currently
                                    running.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            @if($activePatrollerJobs->hasPages())
                <div class="px-6 py-3 border-t border-gray-100 bg-gray-50/30">
                    {{ $activePatrollerJobs->appends(['active_patroller_jobs_page' => request('active_patroller_jobs_page')])->links() }}
                </div>
            @endif
        </div>

        <!-- Scheduled Patroller Jobs (Pending) Table -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden mb-6">
            <div class="px-6 py-4 border-b border-gray-100 bg-orange-50/50 flex items-center justify-between">
                <div class="flex items-center gap-2">
                    <svg class="w-4 h-4 text-orange-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    <h3 class="font-bold text-gray-900 text-sm uppercase tracking-wider">Scheduled Patroller Jobs (Pending)
                    </h3>
                </div>
                <span
                    class="text-xs font-bold text-orange-600 bg-orange-100 px-2 py-0.5 rounded-full">{{ $scheduledPatrollerJobsToday->total() }}
                    Pending</span>
            </div>
            <div class="overflow-x-auto">
                <table class="w-full text-left text-sm text-gray-600">
                    <thead class="bg-gray-50 text-[10px] uppercase font-black text-gray-400">
                        <tr>
                            <th class="px-6 py-3">Duty #</th>
                            <th class="px-6 py-3">Route</th>
                            <th class="px-6 py-3">Patroller(s)</th>
                            <th class="px-6 py-3">Shift Time</th>
                            <th class="px-6 py-3 text-right">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100">
                        @forelse($scheduledPatrollerJobsToday as $job)
                            <tr class="hover:bg-gray-50/50 transition-colors">
                                <td class="px-6 py-4 font-mono text-xs text-orange-600 font-bold">#{{ $job->duty_number }}</td>
                                <td class="px-6 py-4 font-bold text-gray-900">{{ $job->route->name ?? 'N/A' }}</td>
                                <td class="px-6 py-4">
                                    @foreach($job->employees as $emp)
                                        <div class="flex items-center gap-2">
                                            <div
                                                class="w-5 h-5 rounded-full bg-orange-100 text-[9px] flex items-center justify-center font-bold text-orange-700">
                                                {{ substr($emp->first_name, 0, 1) }}
                                            </div>
                                            <span class="text-gray-700 font-medium">{{ $emp->first_name }}
                                                {{ $emp->last_name }}</span>
                                        </div>
                                    @endforeach
                                    @if($job->employees->isEmpty())
                                        <span class="text-red-400 text-xs italic">Unassigned</span>
                                    @endif
                                </td>
                                <td class="px-6 py-4 text-xs font-medium text-gray-500">
                                    <div class="font-bold text-gray-800">
                                        {{ \Carbon\Carbon::parse($job->from_time)->format('H:i') }} -
                                        {{ \Carbon\Carbon::parse($job->to_time)->format('H:i') }}
                                    </div>
                                    <div class="text-xs text-gray-400">
                                        {{ \Carbon\Carbon::parse($job->from_time)->diffForHumans() }}
                                    </div>
                                </td>
                                <td class="px-6 py-4 text-right">
                                    <a href="#"
                                        class="px-3 py-1.5 bg-white border border-gray-200 text-gray-700 text-xs font-bold rounded-lg hover:bg-gray-50 hover:text-blue-600 transition-colors shadow-sm">
                                        View
                                    </a>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="px-6 py-8 text-center text-gray-400 italic">No pending patroller jobs for
                                    today.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            @if($scheduledPatrollerJobsToday->hasPages())
                <div class="px-6 py-3 border-t border-gray-100 bg-gray-50/30">
                    {{ $scheduledPatrollerJobsToday->appends(['scheduled_patroller_jobs_page' => request('scheduled_patroller_jobs_page')])->links() }}
                </div>
            @endif
        </div>

        <!-- Completed Patroller Jobs Table -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden mb-6">
            <div class="px-6 py-4 border-b border-gray-100 bg-emerald-50/50 flex items-center justify-between">
                <div class="flex items-center gap-2">
                    <svg class="w-4 h-4 text-emerald-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    <h3 class="font-bold text-gray-900 text-sm uppercase tracking-wider">Completed Patroller Jobs (Today)
                    </h3>
                </div>
                <span
                    class="text-xs font-bold text-emerald-600 bg-emerald-100 px-2 py-0.5 rounded-full">{{ $completedPatrollerJobsToday->total() }}
                    Done</span>
            </div>
            <div class="overflow-x-auto">
                <table class="w-full text-left text-sm text-gray-600">
                    <thead class="bg-gray-50 text-[10px] uppercase font-black text-gray-400">
                        <tr>
                            <th class="px-6 py-3">Duty #</th>
                            <th class="px-6 py-3">Route</th>
                            <th class="px-6 py-3">Patroller(s)</th>
                            <th class="px-6 py-3">Shift Time</th>
                            <th class="px-6 py-3 text-right">Ended At</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100">
                        @forelse($completedPatrollerJobsToday as $job)
                            <tr class="hover:bg-gray-50/50 transition-colors">
                                <td class="px-6 py-4 font-mono text-xs text-emerald-600 font-bold">#{{ $job->duty_number }}</td>
                                <td class="px-6 py-4 font-bold text-gray-900">{{ $job->route->name ?? 'N/A' }}</td>
                                <td class="px-6 py-4">
                                    @foreach($job->employees as $emp)
                                        <div class="flex items-center gap-2">
                                            <div
                                                class="w-5 h-5 rounded-full bg-emerald-100 text-[9px] flex items-center justify-center font-bold text-emerald-700">
                                                {{ substr($emp->first_name, 0, 1) }}
                                            </div>
                                            <span class="text-gray-700 font-medium">{{ $emp->first_name }}
                                                {{ $emp->last_name }}</span>
                                        </div>
                                    @endforeach
                                </td>
                                <td class="px-6 py-4 text-xs font-medium text-gray-500">
                                    {{ \Carbon\Carbon::parse($job->from_time)->format('H:i') }} -
                                    {{ \Carbon\Carbon::parse($job->to_time)->format('H:i') }}
                                </td>
                                <td class="px-6 py-4 text-right">
                                    <div class="text-xs font-bold text-emerald-600">
                                        {{ $job->job_ended_at ? \Carbon\Carbon::parse($job->job_ended_at)->format('H:i') : '--:--' }}
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="px-6 py-8 text-center text-gray-400 italic">No completed patroller jobs
                                    yet
                                    today.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            @if($completedPatrollerJobsToday->hasPages())
                <div class="px-6 py-3 border-t border-gray-100 bg-gray-50/30">
                    {{ $completedPatrollerJobsToday->appends(['completed_patroller_jobs_page' => request('completed_patroller_jobs_page')])->links() }}
                </div>
            @endif
        </div>

        <!-- Celebrations & Milestones -->
        @if((isset($upcomingBirthdays) && $upcomingBirthdays->count() > 0) || (isset($upcomingAnniversaries) && $upcomingAnniversaries->count() > 0))
            <div
                class="bg-gradient-to-r from-cyan-500 to-blue-600 rounded-xl shadow-lg border border-blue-200 overflow-hidden mb-6 text-white">
                <div class="px-6 py-4 border-b border-white/20 flex items-center gap-2">
                    <svg class="w-6 h-6 text-yellow-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M5 3v4M3 5h4M6 17v4m-2-2h4m5-16l2.286 6.857L21 12l-5.714 2.143L13 21l-2.286-6.857L5 12l5.714-2.143L13 3z" />
                    </svg>
                    <h3 class="font-bold text-lg">Celebrations & Milestones</h3>
                </div>

                <div class="p-6 grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Birthdays -->
                    @if(isset($upcomingBirthdays) && $upcomingBirthdays->count() > 0)
                        <div>
                            <h4 class="font-bold text-cyan-100 uppercase text-xs tracking-wider mb-3 flex items-center gap-2">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M21 15.546c-.523 0-1.046.151-1.5.454a2.704 2.704 0 01-3 0 2.704 2.704 0 00-3 0 2.704 2.704 0 01-3 0 2.704 2.704 0 00-3 0 2.704 2.704 0 01-3 0 2.701 2.701 0 00-1.5-.454M9 6v2m3-2v2m3-2v2M9 3h.01M12 3h.01M15 3h.01M21 21v-7a2 2 0 00-2-2H5a2 2 0 00-2 2v7h18zm-3-9v-2a2 2 0 00-2-2H8a2 2 0 00-2 2v2h12z">
                                    </path>
                                </svg>
                                Upcoming Birthdays
                            </h4>
                            <div class="space-y-3">
                                @foreach($upcomingBirthdays as $emp)
                                    <div
                                        class="bg-white/10 backdrop-blur-sm rounded-lg p-3 flex items-center justify-between border border-white/20">
                                        <div class="flex items-center gap-3">
                                            <div
                                                class="w-10 h-10 rounded-full bg-white text-cyan-600 flex items-center justify-center font-bold text-sm shadow-sm">
                                                {{ substr($emp->first_name, 0, 1) }}{{ substr($emp->last_name, 0, 1) }}
                                            </div>
                                            <div>
                                                <div class="font-bold text-white">{{ $emp->first_name }} {{ $emp->last_name }}</div>
                                                <div class="text-xs text-cyan-100 italic">Turns
                                                    {{ \Carbon\Carbon::parse($emp->dob)->age + 1 }} on
                                                    {{ \Carbon\Carbon::parse($emp->dob)->format('M d') }}
                                                </div>
                                            </div>
                                        </div>
                                        @if(\Carbon\Carbon::parse($emp->dob)->format('m-d') == now()->format('m-d'))
                                            <span
                                                class="bg-yellow-400 text-yellow-900 text-[10px] font-bold px-2 py-1 rounded-full uppercase tracking-wide animate-pulse shadow-sm">Today!</span>
                                        @else
                                            <span
                                                class="bg-white/20 text-white text-[10px] font-bold px-2 py-1 rounded-full">{{ \Carbon\Carbon::parse($emp->dob)->format('M d') }}</span>
                                        @endif
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    @endif

                    <!-- Work Anniversaries -->
                    @if(isset($upcomingAnniversaries) && $upcomingAnniversaries->count() > 0)
                        <div>
                            <h4 class="font-bold text-blue-100 uppercase text-xs tracking-wider mb-3 flex items-center gap-2">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M12 8v13m0-13V6a2 2 0 112 2h-2zm0 0V5.5A2.5 2.5 0 109.5 8H12zm-7 4h14M5 12a2 2 0 110-4h14a2 2 0 110 4M5 12v7a2 2 0 002 2h10a2 2 0 002-2v-7">
                                    </path>
                                </svg>
                                Work Anniversaries
                            </h4>
                            <div class="space-y-3">
                                @foreach($upcomingAnniversaries as $emp)
                                    @php
                                        $years = (int) \Carbon\Carbon::parse($emp->employment_date)->diffInYears(now()->addDays(7));
                                        $years = $years == 0 ? 1 : $years; // Show 1 year if it's their first
                                    @endphp
                                    <div
                                        class="bg-white/10 backdrop-blur-sm rounded-lg p-3 flex items-center justify-between border border-white/20">
                                        <div class="flex items-center gap-3">
                                            <div
                                                class="w-10 h-10 rounded-full bg-white text-blue-600 flex items-center justify-center font-bold text-sm shadow-sm">
                                                {{ substr($emp->first_name, 0, 1) }}{{ substr($emp->last_name, 0, 1) }}
                                            </div>
                                            <div>
                                                <div class="font-bold text-white">{{ $emp->first_name }} {{ $emp->last_name }}</div>
                                                <div class="text-xs text-blue-100 italic">{{ $years }} Year{{ $years > 1 ? 's' : '' }}
                                                    on {{ \Carbon\Carbon::parse($emp->employment_date)->format('M d') }}</div>
                                            </div>
                                        </div>
                                        @if(\Carbon\Carbon::parse($emp->employment_date)->format('m-d') == now()->format('m-d'))
                                            <span
                                                class="bg-yellow-400 text-yellow-900 text-[10px] font-bold px-2 py-1 rounded-full uppercase tracking-wide animate-pulse shadow-sm">Today!</span>
                                        @else
                                            <span
                                                class="bg-white/20 text-white text-[10px] font-bold px-2 py-1 rounded-full">{{ \Carbon\Carbon::parse($emp->employment_date)->format('M d') }}</span>
                                        @endif
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        @endif

        <!-- Guard Applications -->
        @if(isset($guardApplications) && $guardApplications->count() > 0)
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden mb-6"
                x-data="{ openEmailModal: false, selectedUser: '', selectedApplicantId: null }">
                <div class="px-6 py-4 border-b border-gray-100 bg-purple-50/50 flex items-center justify-between">
                    <h3 class="font-bold text-gray-900 text-sm uppercase tracking-wider">Guard Applications</h3>
                    <span
                        class="text-xs font-bold text-purple-600 bg-purple-100 px-2 py-0.5 rounded-full">{{ $guardApplications->count() }}
                        New</span>
                </div>
                <div class="overflow-x-auto">
                    <table class="w-full text-left text-sm text-gray-600">
                        <thead class="bg-gray-50 text-[10px] uppercase font-black text-gray-400">
                            <tr>
                                <th class="px-6 py-3">Name</th>
                                <th class="px-6 py-3">Email / Phone</th>
                                <th class="px-6 py-3">Message</th>
                                <th class="px-6 py-3">Resume</th>
                                <th class="px-6 py-3">Applied Date</th>
                                <th class="px-6 py-3 text-right">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-100">
                            @foreach($guardApplications as $applicant)
                                <tr class="hover:bg-gray-50/50 transition-colors">
                                    <td class="px-6 py-4 font-bold text-gray-900">{{ $applicant->full_name }}</td>
                                    <td class="px-6 py-4">
                                        <div class="flex flex-col">
                                            <span>{{ $applicant->email }}</span>
                                            <span class="text-xs text-gray-400">{{ $applicant->phone }}</span>
                                        </div>
                                    </td>
                                    <td class="px-6 py-4">
                                        <div
                                            class="whitespace-normal break-words min-w-[250px] max-w-[400px] text-xs leading-relaxed text-gray-700 bg-gray-50 p-2 rounded border border-gray-100">
                                            {{ $applicant->message ?? 'No message provided.' }}
                                        </div>
                                    </td>
                                    <td class="px-6 py-4">
                                        @if($applicant->resume_path)
                                            <a href="{{ asset('storage/' . $applicant->resume_path) }}" target="_blank"
                                                class="flex items-center gap-1 text-blue-600 hover:text-blue-800 transition-colors bg-blue-50 px-2 py-1 rounded-md w-fit">
                                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                                                    </path>
                                                </svg>
                                                <span class="text-xs font-bold">Download</span>
                                            </a>
                                        @else
                                            <span class="text-xs text-gray-400 italic">No file</span>
                                        @endif
                                    </td>
                                    <td class="px-6 py-4 text-xs">{{ optional($applicant->created_at)->format('M d, Y') ?? 'N/A' }}
                                    </td>
                                    <td class="px-6 py-4 text-right">
                                        <button
                                            @click="openEmailModal = true; selectedApplicantId = {{ $applicant->id }}; selectedUser = '{{ addslashes($applicant->full_name) }}'"
                                            class="px-3 py-1 bg-purple-100 text-purple-700 rounded text-xs font-bold hover:bg-purple-200 transition-colors">
                                            Send Email
                                        </button>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- Email Modal -->
                <div x-show="openEmailModal" style="display: none;" class="fixed inset-0 z-50 overflow-y-auto"
                    aria-labelledby="modal-title" role="dialog" aria-modal="true">
                    <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
                        <div x-show="openEmailModal" x-transition:enter="ease-out duration-300"
                            x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100"
                            x-transition:leave="ease-in duration-200" x-transition:leave-start="opacity-100"
                            x-transition:leave-end="opacity-0" @click="openEmailModal = false"
                            class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity" aria-hidden="true"></div>
                        <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>
                        <div x-show="openEmailModal" x-transition:enter="ease-out duration-300"
                            x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                            x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
                            x-transition:leave="ease-in duration-200"
                            x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
                            x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                            class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full"
                            x-data="{
                                                                                isSending: false,
                                                                                isSuccess: false,
                                                                                errorMessage: '',
                                                                                templateId: '',
                                                                                async sendEmail() {
                                                                                    this.isSending = true;
                                                                                    this.errorMessage = '';
                                                                                    this.isSuccess = false;
                                                                                    try {
                                                                                        const response = await axios.post('{{ route('dashboard.send-applicant-email') }}', {
                                                                                            applicant_id: this.selectedApplicantId,
                                                                                            email_template_id: this.templateId
                                                                                        });
                                                                                        this.isSuccess = true;
                                                                                        setTimeout(() => {
                                                                                            this.openEmailModal = false;
                                                                                            this.isSuccess = false;
                                                                                            this.templateId = '';
                                                                                        }, 1500);
                                                                                    } catch (error) {
                                                                                        this.errorMessage = error.response?.data?.message || 'Failed to send email. Please try again.';
                                                                                    } finally {
                                                                                        this.isSending = false;
                                                                                    }
                                                                                }
                                                                            }">

                            <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                                <div class="sm:flex sm:items-start">
                                    <div class="mt-3 text-center sm:mt-0 sm:ml-4 sm:text-left w-full">
                                        <h3 class="text-lg leading-6 font-medium text-gray-900" id="modal-title">
                                            Send Email to <span x-text="selectedUser"></span>
                                        </h3>

                                        <!-- Success Message -->
                                        <div x-show="isSuccess"
                                            class="mt-4 p-3 bg-green-50 text-green-700 rounded-lg text-sm font-medium flex items-center gap-2">
                                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M5 13l4 4L19 7"></path>
                                            </svg>
                                            Email sent successfully!
                                        </div>

                                        <!-- Error Message -->
                                        <div x-show="errorMessage"
                                            class="mt-4 p-3 bg-red-50 text-red-700 rounded-lg text-sm font-medium flex items-center gap-2"
                                            x-text="errorMessage"></div>

                                        <div x-show="!isSuccess" class="mt-4">
                                            <label class="block text-sm font-medium text-gray-700 mb-1">Select Template</label>
                                            <select x-model="templateId"
                                                class="mt-1 block w-full pl-3 pr-10 py-2.5 text-base border-gray-300 focus:outline-none focus:ring-purple-500 focus:border-purple-500 sm:text-sm rounded-lg border bg-gray-50">
                                                <option value="">-- Choose a template --</option>
                                                @foreach($emailTemplates as $template)
                                                    <option value="{{ $template->id }}">{{ $template->name }}</option>
                                                @endforeach
                                            </select>
                                            <p class="mt-2 text-xs text-gray-500">The email will be sent immediately using the
                                                selected template.</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="bg-gray-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse" x-show="!isSuccess">
                                <button type="button" @click="sendEmail()" :disabled="isSending || !templateId"
                                    class="w-full inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-purple-600 text-base font-medium text-white hover:bg-purple-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-purple-500 sm:ml-3 sm:w-auto sm:text-sm disabled:opacity-50 disabled:cursor-not-allowed">
                                    <span x-show="!isSending">Send Email</span>
                                    <span x-show="isSending" class="flex items-center gap-2">
                                        <svg class="animate-spin h-4 w-4 text-white" xmlns="http://www.w3.org/2000/svg"
                                            fill="none" viewBox="0 0 24 24">
                                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor"
                                                stroke-width="4"></circle>
                                            <path class="opacity-75" fill="currentColor"
                                                d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z">
                                            </path>
                                        </svg>
                                        Sending...
                                    </span>
                                </button>
                                <button type="button" @click="openEmailModal = false" :disabled="isSending"
                                    class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm disabled:opacity-50">
                                    Cancel
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif


        <!-- Grid for Expired Licenses & Late Checkins -->
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-6">
            <!-- Expired Licenses -->
            <div
                class="{{ isset($expiredLicenses) && $expiredLicenses->count() > 0 ? '' : 'hidden' }} bg-white rounded-xl shadow-sm border border-red-200 overflow-hidden h-fit">
                @if(isset($expiredLicenses) && $expiredLicenses->count() > 0)
                    <div class="px-6 py-4 border-b border-red-100 bg-red-50 flex items-center justify-between">
                        <div class="flex items-center gap-2">
                            <svg class="w-5 h-5 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z">
                                </path>
                            </svg>
                            <h3 class="font-bold text-red-900 text-sm uppercase tracking-wider">Expired Employee Licenses</h3>
                        </div>
                    </div>
                    <div class="divide-y divide-red-50 max-h-[600px] overflow-y-auto">
                        @foreach($expiredLicenses as $license)
                            <div
                                class="p-4 flex flex-col md:flex-row items-center justify-between gap-4 hover:bg-red-50/50 transition-colors">
                                <div class="flex items-center gap-4 flex-1">
                                    <div
                                        class="w-10 h-10 rounded-full bg-red-100 flex items-center justify-center text-red-600 font-bold border border-red-200 shrink-0">
                                        {{ substr($license->employee->first_name ?? '?', 0, 1) }}{{ substr($license->employee->last_name ?? '?', 0, 1) }}
                                    </div>
                                    <div>
                                        <div class="font-bold text-gray-900 text-sm">{{ $license->employee->first_name }}
                                            {{ $license->employee->last_name }}
                                        </div>
                                        <div class="text-xs text-gray-500">{{ $license->type ?? 'Unknown License' }} •
                                            {{ $license->identification_number ?? 'N/A' }}
                                        </div>
                                    </div>
                                </div>
                                <div class="flex items-center gap-6">
                                    <div class="text-right">
                                        <div class="text-[10px] font-bold uppercase text-gray-400 tracking-wider">Expired</div>
                                        <div class="text-xs font-bold text-red-600">
                                            {{ \Carbon\Carbon::parse($license->expiry_date)->format('M d, Y') }}
                                        </div>
                                        <div class="text-[10px] text-red-400">
                                            ({{ \Carbon\Carbon::parse($license->expiry_date)->diffForHumans() }})</div>
                                    </div>
                                    <a href="{{ route('employees.edit', $license->employee_id) }}"
                                        class="px-3 py-1.5 bg-white border border-gray-200 text-gray-600 rounded-lg text-xs font-bold hover:bg-gray-50 hover:text-blue-600 hover:border-blue-200 transition-all shadow-sm">
                                        Resolve
                                    </a>
                                </div>
                            </div>
                        @endforeach
                    </div>
                    <!-- Pagination -->
                    @if($expiredLicenses->hasPages())
                        <div class="px-6 py-3 border-t border-red-50 bg-white">
                            {{ $expiredLicenses->appends(request()->query())->links() }}
                        </div>
                    @endif
                @endif
            </div>

            <!-- Late Check-ins Column -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 h-fit">
                <div class="border-b border-gray-200 bg-[#f8f9fa]">
                    <nav class="flex h-10 px-2 space-x-1">
                        <button class="px-4 text-xs font-semibold text-gray-900 border-b-2 border-red-500 bg-white">
                            Late Check-ins ( > {{ $lateTolerance }} min)
                        </button>
                    </nav>
                </div>

                <div class="divide-y divide-gray-50 max-h-[600px] overflow-y-auto">
                    @forelse($lateCheckins as $schedule)
                        @foreach($schedule->employees as $employee)
                            @if($employee->pivot->actual_start_at && \Carbon\Carbon::parse($employee->pivot->actual_start_at)->gt(\Carbon\Carbon::parse($schedule->from_datetime)->addMinutes($lateTolerance)))
                                @php
                                    $checkin = \Carbon\Carbon::parse($employee->pivot->actual_start_at);
                                    $scheduled = \Carbon\Carbon::parse($schedule->from_datetime);
                                    $diff = $scheduled->diffInMinutes($checkin);
                                @endphp
                                <div class="p-4 flex gap-4 hover:bg-gray-50 transition-colors">
                                    <div
                                        class="w-10 h-10 rounded-full bg-red-100 flex items-center justify-center text-red-600 font-bold text-xs shrink-0 ring-4 ring-red-50">
                                        {{ substr($employee->first_name, 0, 1) }}{{ substr($employee->last_name, 0, 1) }}
                                    </div>
                                    <div class="flex-1">
                                        <div class="flex justify-between items-start">
                                            <div>
                                                <p class="text-sm font-bold text-gray-900">
                                                    {{ $employee->first_name }} {{ $employee->last_name }}
                                                    <span class="font-medium text-gray-500">started shift</span>
                                                    <span class="text-red-600 font-bold">{{ number_format($diff, 2) }} min late</span>
                                                </p>
                                                <p class="text-xs text-gray-500 mt-0.5">
                                                    Site: <span
                                                        class="font-bold text-gray-700">{{ $schedule->site->name ?? 'Unknown Site' }}</span>
                                                </p>
                                            </div>
                                            <div class="text-right">
                                                <div class="text-[10px] font-bold uppercase tracking-wider text-gray-400">Scheduled
                                                </div>
                                                <div class="text-xs font-mono text-gray-600">{{ $scheduled->format('H:i') }}</div>
                                                <div class="text-[10px] font-bold uppercase tracking-wider text-gray-400 mt-1">Actual
                                                </div>
                                                <div class="text-xs font-mono text-red-600 font-bold">{{ $checkin->format('H:i') }}
                                                </div>
                                            </div>
                                        </div>
                                        <div
                                            class="mt-2 flex items-center gap-3 text-[10px] uppercase font-bold tracking-wider opacity-60">
                                            <span class="text-gray-500">{{ $scheduled->format('M d, Y') }}</span>
                                            <span>•</span>
                                            <span class="text-blue-600">{{ $schedule->duty_number }}</span>
                                        </div>
                                    </div>
                                </div>
                            @endif
                        @endforeach
                    @empty
                        <div class="p-8 text-center">
                            <div class="w-16 h-16 bg-green-50 rounded-full flex items-center justify-center mx-auto mb-4">
                                <svg class="w-8 h-8 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                            </div>
                            <h3 class="text-sm font-bold text-gray-900">All Clear!</h3>
                            <p class="text-xs text-gray-500 mt-1">No late check-ins detected within the last 7 days.</p>
                        </div>
                    @endforelse
                </div>
            </div>
        </div>

    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            // Use json_encode for saf                e variable passing
            var refreshEnabled = @json($refreshEnabled ?? 0);
            var refreshInterval = @json($refreshInterval ?? 5);

            console.log('Dashboard Auto-Refresh Config:', { enabled: refreshEnabled, interval: refreshInterval });

            // Check loosely for truthy values (1, '1', true, 'true', 'on')
            var isEnabled = refreshEnabled == 1 || refreshEnabled === 'true' || refreshEnabled === true || refreshEnabled === 'on';

            if (isEnabled) {
                var minutes = parseInt(refreshInterval);
                if (isNaN(minutes) || minutes < 1) {
                    minutes = 5; // Fallback default
                }

                var intervalMs = minutes * 60 * 1000;
                console.log('Dashboard auto-refresh is ACTIVE. Scheduling reload in ' + minutes + ' minutes.');

                setTimeout(function () {
                    console.log('Reloading dashboard...');
                    window.location.reload();
                }, intervalMs);
            } else {
                console.log('Dashboard auto-refresh is DISABLED.');
            }
            // Live Activity Feed Refresh
            function refreshActivityFeed() {
                fetch('{{ route('activity-feed') }}')
                    .then(response => response.text())
                    .then(html => {
                        document.getElementById('live-activity-feed').innerHTML = html;
                    })
                    .catch(error => console.error('Error refreshing activity feed:', error));
            }

            // Initial load
            refreshActivityFeed();

            // Set interval
            setInterval(refreshActivityFeed, 60000); // 1 minute
        });
    </script>
@endsection