<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Check-in History Report</title>
    <style>
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 10px;
            color: #333;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #1e293b;
            padding-bottom: 10px;
        }

        .header h1 {
            margin: 0;
            font-size: 18px;
            color: #1e293b;
        }

        .header p {
            margin: 5px 0 0 0;
            font-size: 9px;
            color: #64748b;
        }

        .filters {
            background-color: #f8fafc;
            padding: 8px;
            margin-bottom: 15px;
            border-radius: 4px;
            font-size: 9px;
        }

        .filters strong {
            color: #1e293b;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        th {
            background-color: #f1f5f9;
            color: #1e293b;
            font-weight: bold;
            padding: 6px 4px;
            text-align: left;
            border: 1px solid #cbd5e1;
            font-size: 9px;
        }

        td {
            padding: 5px 4px;
            border: 1px solid #e2e8f0;
            font-size: 9px;
            vertical-align: top;
        }

        tr:nth-child(even) {
            background-color: #f8fafc;
        }

        .badge {
            display: inline-block;
            padding: 2px 5px;
            border-radius: 3px;
            font-size: 8px;
            font-weight: bold;
        }

        .badge-verified {
            background-color: #d1fae5;
            color: #065f46;
        }

        .badge-unverified {
            background-color: #fef3c7;
            color: #92400e;
        }

        .badge-static {
            background-color: #dbeafe;
            color: #1e40af;
        }

        .badge-patrol {
            background-color: #e9d5ff;
            color: #6b21a8;
        }

        .location-info {
            font-size: 8px;
            color: #64748b;
            margin-top: 2px;
        }

        .gps-coords {
            font-family: monospace;
            font-size: 7px;
            color: #475569;
        }

        .footer {
            margin-top: 20px;
            text-align: center;
            font-size: 8px;
            color: #94a3b8;
            border-top: 1px solid #e2e8f0;
            padding-top: 8px;
        }

        .no-data {
            text-align: center;
            padding: 30px;
            color: #94a3b8;
            font-style: italic;
        }
    </style>
</head>

<body>
    <div class="header">
        <h1>Check-in History Report</h1>
        <p>{{ $company->name }} | Generated: {{ now()->format('F d, Y - H:i') }}</p>
    </div>

    @if(!empty($filters['date']) || !empty($filters['employee_id']) || !empty($filters['status']))
        <div class="filters">
            <strong>Applied Filters:</strong>
            @if(!empty($filters['date']))
                Date: {{ \Carbon\Carbon::parse($filters['date'])->format('M d, Y') }}
            @endif
            @if(!empty($filters['employee_id']))
                | Employee ID: {{ $filters['employee_id'] }}
            @endif
            @if(!empty($filters['status']))
                | Status: {{ ucfirst($filters['status']) }}
            @endif
        </div>
    @endif

    @if($checkins->isEmpty())
        <div class="no-data">
            No check-in records found for the selected filters.
        </div>
    @else
        @php
            $groupedCheckins = $checkins->groupBy('employee_id');
        @endphp

        @foreach($groupedCheckins as $employeeId => $employeeCheckins)
            @php
                $employee = $employeeCheckins->first()->employee;
            @endphp

            <div style="margin-bottom: 25px; page-break-inside: avoid;">
                <div
                    style="background-color: #1e293b; color: white; padding: 8px 10px; border-radius: 4px; margin-bottom: 10px;">
                    <strong style="font-size: 11px;">{{ $employee->first_name }} {{ $employee->last_name }}</strong>
                    <span style="font-size: 9px; margin-left: 10px;">📞 {{ $employee->phone_number }}</span>
                    <span style="float: right; font-size: 9px;">{{ $employeeCheckins->count() }} check-in(s)</span>
                </div>

                <table>
                    <thead>
                        <tr>
                            <th style="width: 15%;">Date/Time</th>
                            <th style="width: 20%;">Site/Route</th>
                            <th style="width: 20%;">Location</th>
                            <th style="width: 10%;">Method</th>
                            <th style="width: 10%;">Status</th>
                            <th style="width: 12%;">Caller</th>
                            <th style="width: 13%;">Notes</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($employeeCheckins as $checkin)
                            <tr>
                                <td>
                                    <strong>{{ $checkin->created_at->format('M d, Y') }}</strong><br>
                                    <span style="font-size: 8px; color: #64748b;">{{ $checkin->created_at->format('H:i') }}</span>
                                </td>
                                <td>
                                    @if($checkin->schedule)
                                        <span class="badge badge-static">Static</span><br>
                                        <strong>{{ $checkin->schedule->site->name }}</strong><br>
                                        <span style="font-size: 8px; color: #64748b;">#{{ $checkin->schedule->duty_number }}</span>
                                    @elseif($checkin->patrollerSchedule)
                                        <span class="badge badge-patrol">Patrol</span><br>
                                        <strong>{{ $checkin->patrollerSchedule->route->name }}</strong><br>
                                        <span style="font-size: 8px; color: #64748b;">#{{ $checkin->patrollerSchedule->id }}</span>
                                    @else
                                        <span style="color: #94a3b8;">Unknown</span>
                                    @endif
                                </td>
                                <td>
                                    @if($checkin->location_reported)
                                        <div class="location-info">📍 {{ $checkin->location_reported }}</div>
                                    @endif
                                    @if($checkin->latitude && $checkin->longitude)
                                        <div class="gps-coords">GPS: {{ number_format($checkin->latitude, 6) }},
                                            {{ number_format($checkin->longitude, 6) }}</div>
                                    @endif
                                    @if($checkin->maps_link)
                                        <div class="location-info" style="color: #2563eb;">🗺️ Map Link</div>
                                    @endif
                                    @if(!$checkin->location_reported && !$checkin->latitude && !$checkin->maps_link)
                                        <span style="color: #94a3b8; font-size: 8px;">No location</span>
                                    @endif
                                </td>
                                <td style="text-align: center;">
                                    {{ ucfirst($checkin->checkin_type) }}
                                </td>
                                <td style="text-align: center;">
                                    @if($checkin->is_verified)
                                        <span class="badge badge-verified">Verified</span>
                                    @else
                                        <span class="badge badge-unverified">Unverified</span>
                                    @endif
                                </td>
                                <td>
                                    {{ $checkin->user?->name ?? 'System' }}
                                </td>
                                <td>
                                    {{ $checkin->notes ?: '--' }}
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>

                {{-- Photos for this employee --}}
                @php
                    $employeePhotos = $employeeCheckins->filter(function ($checkin) {
                        return !empty($checkin->images);
                    });
                @endphp

                @if($employeePhotos->isNotEmpty())
                    <div style="margin-top: 10px; padding: 8px; background-color: #f8fafc; border-radius: 4px;">
                        <div style="font-size: 9px; font-weight: bold; color: #475569; margin-bottom: 5px;">📸 Evidence Photos</div>
                        @foreach($employeePhotos as $checkin)
                            <div style="margin-bottom: 8px;">
                                <div style="font-size: 8px; color: #64748b; margin-bottom: 3px;">
                                    {{ $checkin->created_at->format('M d, H:i') }}
                                    @if($checkin->schedule)
                                        - {{ $checkin->schedule->site->name }}
                                    @elseif($checkin->patrollerSchedule)
                                        - {{ $checkin->patrollerSchedule->route->name }}
                                    @endif
                                </div>
                                <div style="display: flex; flex-wrap: wrap; gap: 5px;">
                                    @foreach($checkin->images as $image)
                                        @php
                                            $imagePath = public_path('storage/' . $image);
                                        @endphp
                                        @if(file_exists($imagePath))
                                            <img src="{{ $imagePath }}" alt="Evidence"
                                                style="max-width: 100px; max-height: 100px; border: 1px solid #cbd5e1; border-radius: 3px;">
                                        @endif
                                    @endforeach
                                </div>
                            </div>
                        @endforeach
                    </div>
                @endif
            </div>
        @endforeach
    @endif

    <div class="footer">
        <p>Total Records: {{ $checkins->count() }} | Customer Care System | {{ config('app.name') }}</p>
    </div>
</body>

</html>