@extends('layouts.public')

@section('content')
    <div class="flex flex-col justify-center py-12 sm:px-6 lg:px-8 min-h-[calc(100vh-5rem)] bg-gray-50">
        <div class="sm:mx-auto sm:w-full sm:max-w-md">
            <div class="flex justify-center mb-6">
                <div
                    class="w-16 h-16 bg-blue-600 rounded-2xl flex items-center justify-center shadow-lg shadow-blue-500/30">
                    <svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                    </svg>
                </div>
            </div>
            <h2 class="text-center text-3xl font-extrabold text-gray-900 tracking-tight">Two-Step Verification</h2>
            <p class="mt-2 text-center text-sm text-gray-600 max-w">
                Enter the 6-digit code from your Authenticator app to secure your session.
            </p>
        </div>

        <div class="mt-8 sm:mx-auto sm:w-full sm:max-w-md">
            <div class="bg-white py-8 px-4 shadow-xl sm:rounded-2xl sm:px-10 border border-gray-100">
                <form action="{{ route('2fa.storeVerify') }}" method="POST">
                    @csrf
                    <div class="space-y-6">
                        <div>
                            <label for="code" class="block text-sm font-bold text-gray-700 mb-2">Authenticator Code</label>
                            <input id="code" name="code" type="text" required maxlength="6" autofocus
                                class="block w-full px-4 py-3 text-center text-2xl font-black tracking-[0.5em] border border-gray-300 rounded-xl shadow-sm focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all placeholder-gray-300"
                                placeholder="000000" autocomplete="one-time-code">
                            @error('code')
                                <p class="mt-2 text-sm text-red-600 font-medium">{{ $message }}</p>
                            @enderror
                        </div>

                        <div>
                            <button type="submit"
                                class="w-full flex justify-center py-3 px-4 border border-transparent rounded-xl shadow-sm text-sm font-black text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition-all">
                                Verify Identity
                            </button>
                        </div>
                    </div>
                </form>
            </div>

            <div class="mt-6 text-center">
                <form action="{{ route('logout') }}" method="POST">
                    @csrf
                    <button type="submit" class="text-sm font-medium text-gray-500 hover:text-gray-700 transition-colors">
                        Log out and try again
                    </button>
                </form>
            </div>
        </div>
    </div>
@endsection