@extends('layouts.user')

@section('title', 'Analytics Dashboard')

@section('content')
    <div class="space-y-6">
        <!-- Header -->
        <div class="mb-6">
            <h1 class="text-3xl font-black text-slate-900 mb-2">📊 Analytics Dashboard</h1>
            <p class="text-slate-600">Comprehensive insights and performance metrics</p>
        </div>

        <!-- Guard Jobs Chart -->
        <div class="bg-white rounded-3xl shadow-xl border border-slate-100 p-8">
            <div class="mb-6">
                <h2 class="text-xl font-black text-slate-900 mb-1">Guard Jobs - Monthly Overview</h2>
                <p class="text-sm text-slate-500">Track completed, upcoming, and missed guard assignments</p>
            </div>
            <div class="h-80">
                <canvas id="guardJobsChart"></canvas>
            </div>
        </div>

        <!-- Patroller Jobs Chart -->
        <div class="bg-white rounded-3xl shadow-xl border border-slate-100 p-8">
            <div class="mb-6">
                <h2 class="text-xl font-black text-slate-900 mb-1">Patroller Jobs - Monthly Overview</h2>
                <p class="text-sm text-slate-500">Monitor patroller job completion and performance</p>
            </div>
            <div class="h-80">
                <canvas id="patrollerJobsChart"></canvas>
            </div>
        </div>

        <!-- Incident Reports Chart -->
        <div class="bg-white rounded-3xl shadow-xl border border-slate-100 p-8">
            <div class="mb-6">
                <h2 class="text-xl font-black text-slate-900 mb-1">Incident Reports - Monthly Trend</h2>
                <p class="text-sm text-slate-500">Linear graph showing incident report frequency</p>
            </div>
            <div class="h-80">
                <canvas id="incidentReportsChart"></canvas>
            </div>
        </div>

        <!-- Issue Tickets Chart -->
        <div class="bg-white rounded-3xl shadow-xl border border-slate-100 p-8">
            <div class="mb-6">
                <h2 class="text-xl font-black text-slate-900 mb-1">Issue Tickets - Monthly Count</h2>
                <p class="text-sm text-slate-500">Track patroller issue tickets over time</p>
            </div>
            <div class="h-80">
                <canvas id="issueTicketsChart"></canvas>
            </div>
        </div>

        <!-- Check-in Analysis Charts -->
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
            <!-- Guard Check-ins -->
            <div class="bg-white rounded-3xl shadow-xl border border-slate-100 p-8">
                <div class="mb-6">
                    <h2 class="text-xl font-black text-slate-900 mb-1">Guard Check-ins Analysis</h2>
                    <p class="text-sm text-slate-500">On-time vs late check-ins</p>
                </div>
                <div class="h-80">
                    <canvas id="guardCheckinsChart"></canvas>
                </div>
            </div>

            <!-- Patroller Check-ins -->
            <div class="bg-white rounded-3xl shadow-xl border border-slate-100 p-8">
                <div class="mb-6">
                    <h2 class="text-xl font-black text-slate-900 mb-1">Patroller Check-ins Analysis</h2>
                    <p class="text-sm text-slate-500">On-time vs late check-ins</p>
                </div>
                <div class="h-80">
                    <canvas id="patrollerCheckinsChart"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>

    <script>
        // Chart.js default configuration
        Chart.defaults.font.family = "'Inter', sans-serif";
        Chart.defaults.color = '#64748b';

        // Data from backend
        const monthLabels = @json($monthLabels);
        const guardJobsCompleted = @json($guardJobsCompleted);
        const guardJobsUpcoming = @json($guardJobsUpcoming);
        const guardJobsMissed = @json($guardJobsMissed);
        const patrollerJobsCompleted = @json($patrollerJobsCompleted);
        const patrollerJobsUpcoming = @json($patrollerJobsUpcoming);
        const patrollerJobsMissed = @json($patrollerJobsMissed);
        const incidentReports = @json($incidentReports);
        const issueTickets = @json($issueTickets);
        const guardOnTimeCheckins = @json($guardOnTimeCheckins);
        const guardLateCheckins = @json($guardLateCheckins);
        const patrollerOnTimeCheckins = @json($patrollerOnTimeCheckins);
        const patrollerLateCheckins = @json($patrollerLateCheckins);

        // Guard Jobs Chart (Bar Chart)
        new Chart(document.getElementById('guardJobsChart'), {
            type: 'bar',
            data: {
                labels: monthLabels,
                datasets: [{
                    label: 'Completed',
                    data: guardJobsCompleted,
                    backgroundColor: 'rgba(16, 185, 129, 0.8)',
                    borderColor: 'rgb(16, 185, 129)',
                    borderWidth: 2
                }, {
                    label: 'Upcoming',
                    data: guardJobsUpcoming,
                    backgroundColor: 'rgba(59, 130, 246, 0.8)',
                    borderColor: 'rgb(59, 130, 246)',
                    borderWidth: 2
                }, {
                    label: 'Missed',
                    data: guardJobsMissed,
                    backgroundColor: 'rgba(239, 68, 68, 0.8)',
                    borderColor: 'rgb(239, 68, 68)',
                    borderWidth: 2
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'top',
                        labels: {
                            font: {
                                size: 12,
                                weight: 'bold'
                            },
                            padding: 15
                        }
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            precision: 0
                        }
                    }
                }
            }
        });

        // Patroller Jobs Chart (Bar Chart)
        new Chart(document.getElementById('patrollerJobsChart'), {
            type: 'bar',
            data: {
                labels: monthLabels,
                datasets: [{
                    label: 'Completed',
                    data: patrollerJobsCompleted,
                    backgroundColor: 'rgba(16, 185, 129, 0.8)',
                    borderColor: 'rgb(16, 185, 129)',
                    borderWidth: 2
                }, {
                    label: 'Upcoming',
                    data: patrollerJobsUpcoming,
                    backgroundColor: 'rgba(59, 130, 246, 0.8)',
                    borderColor: 'rgb(59, 130, 246)',
                    borderWidth: 2
                }, {
                    label: 'Missed',
                    data: patrollerJobsMissed,
                    backgroundColor: 'rgba(239, 68, 68, 0.8)',
                    borderColor: 'rgb(239, 68, 68)',
                    borderWidth: 2
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'top',
                        labels: {
                            font: {
                                size: 12,
                                weight: 'bold'
                            },
                            padding: 15
                        }
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            precision: 0
                        }
                    }
                }
            }
        });

        // Incident Reports Chart (Line Chart)
        new Chart(document.getElementById('incidentReportsChart'), {
            type: 'line',
            data: {
                labels: monthLabels,
                datasets: [{
                    label: 'Incident Reports',
                    data: incidentReports,
                    borderColor: 'rgb(249, 115, 22)',
                    backgroundColor: 'rgba(249, 115, 22, 0.1)',
                    borderWidth: 3,
                    fill: true,
                    tension: 0.4,
                    pointRadius: 5,
                    pointHoverRadius: 7,
                    pointBackgroundColor: 'rgb(249, 115, 22)',
                    pointBorderColor: '#fff',
                    pointBorderWidth: 2
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'top',
                        labels: {
                            font: {
                                size: 12,
                                weight: 'bold'
                            },
                            padding: 15
                        }
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            precision: 0
                        }
                    }
                }
            }
        });

        // Issue Tickets Chart (Line Chart)
        new Chart(document.getElementById('issueTicketsChart'), {
            type: 'line',
            data: {
                labels: monthLabels,
                datasets: [{
                    label: 'Issue Tickets',
                    data: issueTickets,
                    borderColor: 'rgb(168, 85, 247)',
                    backgroundColor: 'rgba(168, 85, 247, 0.1)',
                    borderWidth: 3,
                    fill: true,
                    tension: 0.4,
                    pointRadius: 5,
                    pointHoverRadius: 7,
                    pointBackgroundColor: 'rgb(168, 85, 247)',
                    pointBorderColor: '#fff',
                    pointBorderWidth: 2
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'top',
                        labels: {
                            font: {
                                size: 12,
                                weight: 'bold'
                            },
                            padding: 15
                        }
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            precision: 0
                        }
                    }
                }
            }
        });

        // Guard Check-ins Chart (Doughnut Chart)
        new Chart(document.getElementById('guardCheckinsChart'), {
            type: 'doughnut',
            data: {
                labels: ['On-Time / Early', 'Late'],
                datasets: [{
                    data: [guardOnTimeCheckins, guardLateCheckins],
                    backgroundColor: [
                        'rgba(16, 185, 129, 0.8)',
                        'rgba(239, 68, 68, 0.8)'
                    ],
                    borderColor: [
                        'rgb(16, 185, 129)',
                        'rgb(239, 68, 68)'
                    ],
                    borderWidth: 2
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'bottom',
                        labels: {
                            font: {
                                size: 12,
                                weight: 'bold'
                            },
                            padding: 20
                        }
                    }
                }
            }
        });

        // Patroller Check-ins Chart (Doughnut Chart)
        new Chart(document.getElementById('patrollerCheckinsChart'), {
            type: 'doughnut',
            data: {
                labels: ['On-Time / Early', 'Late'],
                datasets: [{
                    data: [patrollerOnTimeCheckins, patrollerLateCheckins],
                    backgroundColor: [
                        'rgba(16, 185, 129, 0.8)',
                        'rgba(239, 68, 68, 0.8)'
                    ],
                    borderColor: [
                        'rgb(16, 185, 129)',
                        'rgb(239, 68, 68)'
                    ],
                    borderWidth: 2
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'bottom',
                        labels: {
                            font: {
                                size: 12,
                                weight: 'bold'
                            },
                            padding: 20
                        }
                    }
                }
            }
        });
    </script>
@endsection