@extends('layouts.admin')

@section('title', 'View Uniform')
@section('page_title', 'View Uniform Details')

@section('content')
    <div class="max-w-4xl mx-auto">
        <div class="flex items-center gap-4 mb-8">
            <a href="{{ route('admin.uniforms.index') }}"
                class="p-2 bg-white border border-gray-200 rounded-xl hover:border-gray-300 text-slate-500 hover:text-slate-700 transition-all shadow-sm">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18" />
                </svg>
            </a>
            <div class="flex-1">
                <h1 class="text-3xl font-black text-slate-900 tracking-tight">{{ $uniform->name }}</h1>
                <p class="text-slate-500 font-bold mt-1">Detailed information and inventory status.</p>
            </div>
            <div class="flex gap-2">
                <a href="{{ route('admin.uniforms.edit', $uniform) }}"
                    class="px-6 py-3 bg-blue-600 text-white font-bold rounded-xl hover:bg-blue-700 transition-all shadow-lg shadow-blue-500/30 flex items-center gap-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M15.232 5.232l3.536 3.536m-2.036-5.036a2.5 2.5 0 113.536 3.536L6.5 21.036H3v-3.572L16.732 3.732z" />
                    </svg>
                    Edit Uniform
                </a>
            </div>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-8 mb-8">
            <!-- Main Details Card -->
            <div class="md:col-span-2 space-y-8">
                <div class="bg-white rounded-3xl border border-gray-100 shadow-xl p-8">
                    <h2 class="text-xl font-black text-slate-900 mb-6 flex items-center gap-2">
                        <svg class="w-6 h-6 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                        General Information
                    </h2>
                    <div class="space-y-6">
                        <div>
                            <label class="block text-xs font-bold text-slate-400 uppercase tracking-wider mb-1">Uniform
                                Name</label>
                            <div class="text-lg font-bold text-slate-900">{{ $uniform->name }}</div>
                        </div>
                        <div class="grid grid-cols-2 gap-6">
                            <div>
                                <label class="block text-xs font-bold text-slate-400 uppercase tracking-wider mb-1">Uniform
                                    Code</label>
                                @if($uniform->code)
                                    <span
                                        class="bg-slate-100 text-slate-700 px-3 py-1 rounded-lg text-sm font-bold font-mono border border-slate-200 inline-block">{{ $uniform->code }}</span>
                                @else
                                    <span class="text-slate-400 font-medium italic">Not Specified</span>
                                @endif
                            </div>
                            <div>
                                <label
                                    class="block text-xs font-bold text-slate-400 uppercase tracking-wider mb-1">Status</label>
                                @if($uniform->active)
                                    <span
                                        class="bg-green-100 text-green-700 px-3 py-1 rounded-lg text-sm font-bold inline-flex items-center gap-2">
                                        <span class="w-2 h-2 bg-green-500 rounded-full animate-pulse"></span>
                                        Active
                                    </span>
                                @else
                                    <span
                                        class="bg-gray-100 text-gray-600 px-3 py-1 rounded-lg text-sm font-bold">Inactive</span>
                                @endif
                            </div>
                        </div>
                        <div>
                            <label
                                class="block text-xs font-bold text-slate-400 uppercase tracking-wider mb-1">Description</label>
                            <div
                                class="text-slate-600 leading-relaxed font-medium bg-slate-50 p-4 rounded-xl border border-slate-100">
                                {{ $uniform->description ?? 'No description provided.' }}
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Inventory / Variants Card -->
                <div class="bg-white rounded-3xl border border-gray-100 shadow-xl p-8">
                    <h2 class="text-xl font-black text-slate-900 mb-6 flex items-center gap-2">
                        <svg class="w-6 h-6 text-purple-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4" />
                        </svg>
                        Inventory Variants
                    </h2>

                    <div class="overflow-hidden rounded-2xl border border-gray-100">
                        <table class="w-full text-left">
                            <thead>
                                <tr
                                    class="bg-slate-50 text-xs uppercase tracking-widest text-slate-500 font-bold border-b border-gray-100">
                                    <th class="px-6 py-4">Size</th>
                                    <th class="px-6 py-4">Color</th>
                                    <th class="px-6 py-4 text-right">Stock Quantity</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-50">
                                @forelse($uniform->variants as $variant)
                                    <tr class="hover:bg-slate-50/50 transition-colors">
                                        <td class="px-6 py-4 font-bold text-slate-700">
                                            {{ $variant->size ?: '-' }}
                                        </td>
                                        <td class="px-6 py-4 font-bold text-slate-700">
                                            <div class="flex items-center gap-2">
                                                @if($variant->color)
                                                    <!-- Simple color dot approximation if standard name, else just text -->
                                                    <span class="w-3 h-3 rounded-full border border-gray-200 shadow-sm"
                                                        style="background-color: {{ strtolower($variant->color) }}"></span>
                                                    {{ $variant->color }}
                                                @else
                                                    -
                                                @endif
                                            </div>
                                        </td>
                                        <td class="px-6 py-4 text-right">
                                            <span
                                                class="font-bold {{ $variant->stock_quantity == 0 ? 'text-red-500' : 'text-slate-900' }}">
                                                {{ $variant->stock_quantity }}
                                            </span>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="3" class="px-6 py-8 text-center text-slate-500 font-medium italic">
                                            No variants configured for this uniform.
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                            @if($uniform->variants->isNotEmpty())
                                <tfoot class="bg-slate-50 border-t border-gray-100">
                                    <tr>
                                        <td colspan="2"
                                            class="px-6 py-4 text-xs font-bold text-slate-500 uppercase tracking-wider text-right">
                                            Total Stock</td>
                                        <td class="px-6 py-4 text-right font-black text-slate-900 text-lg">
                                            {{ $uniform->variants->sum('stock_quantity') }}
                                        </td>
                                    </tr>
                                </tfoot>
                            @endif
                        </table>
                    </div>
                </div>
            </div>

            <!-- Meta / Sidebar Info (Optional) -->
            <div class="space-y-6">
                <div class="bg-white rounded-3xl border border-gray-100 shadow-xl p-6">
                    <h3 class="text-sm font-bold text-slate-400 uppercase tracking-wider mb-4">Metadata</h3>
                    <div class="space-y-4">
                        <div class="flex justify-between items-center py-2 border-b border-gray-50">
                            <span class="text-sm font-medium text-slate-500">Created At</span>
                            <span
                                class="text-sm font-bold text-slate-700">{{ $uniform->created_at->format('M d, Y') }}</span>
                        </div>
                        <div class="flex justify-between items-center py-2 border-b border-gray-50">
                            <span class="text-sm font-medium text-slate-500">Last Updated</span>
                            <span
                                class="text-sm font-bold text-slate-700">{{ $uniform->updated_at->format('M d, Y') }}</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection