@extends('layouts.admin')

@section('title', 'Uniforms')
@section('page_title', 'Uniform Management')

@section('content')
    <div class="max-w-7xl mx-auto">
        <div class="flex flex-col md:flex-row justify-between items-center mb-8 gap-4">
            <div>
                <h1 class="text-3xl font-black text-slate-900 tracking-tight">Uniforms</h1>
                <p class="text-slate-500 font-bold mt-1">Manage uniform inventory and variations.</p>
            </div>
            <a href="{{ route('admin.uniforms.index', ['view' => 'inventory']) }}"
            class="px-6 py-3 bg-white border border-gray-200 text-slate-600 font-bold rounded-xl hover:bg-gray-50 transition-all shadow-sm flex items-center gap-2">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10" />
            </svg>
            Show Complete Inventory
        </a>
        <a href="{{ route('admin.uniforms.create') }}"
            class="px-6 py-3 bg-blue-600 text-white font-bold rounded-xl shadow-lg shadow-blue-500/30 hover:bg-blue-700 transition-all flex items-center gap-2">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4" />
                </svg>
                Add New Uniform
            </a>
        </div>

        <div class="bg-white rounded-3xl border border-gray-100 shadow-xl overflow-hidden">
            <div class="overflow-x-auto">
                <table class="w-full text-left border-collapse">
                    <thead>
                        <tr
                            class="bg-slate-50 border-b border-gray-100 text-xs uppercase tracking-widest text-slate-500 font-black">
                            <th class="px-8 py-6">Uniform Type</th>
                            <th class="px-8 py-6">Code</th>
                            <th class="px-8 py-6">Variations</th>
                            <th class="px-8 py-6">Status</th>
                            <th class="px-8 py-6 text-right">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-50">
                        @forelse($uniforms as $uniform)
                            <tr class="hover:bg-blue-50/50 transition-colors group">
                                <td class="px-8 py-5">
                                    <div class="font-bold text-slate-900">{{ $uniform->name }}</div>
                                    @if($uniform->description)
                                        <div class="text-xs text-slate-400 mt-1 font-medium truncate max-w-xs">
                                            {{ $uniform->description }}</div>
                                    @endif
                                </td>
                                <td class="px-8 py-5">
                                    @if($uniform->code)
                                        <span
                                            class="bg-slate-100 text-slate-600 px-2 py-1 rounded text-xs font-bold font-mono border border-slate-200">{{ $uniform->code }}</span>
                                    @else
                                        <span class="text-slate-300 text-xs font-bold italic">N/A</span>
                                    @endif
                                </td>
                                <td class="px-8 py-5">
                                    <div class="text-sm font-bold text-slate-700">
                                        {{ $uniform->variants_count }} <span
                                            class="text-slate-400 text-xs font-medium">variants</span>
                                    </div>
                                </td>
                                <td class="px-8 py-5">
                                    <button
                                        onclick="toggleStatus('{{ route('admin.uniforms.toggle-status', $uniform) }}', this)"
                                        role="switch" aria-checked="{{ $uniform->active ? 'true' : 'false' }}"
                                        class="{{ $uniform->active ? 'bg-blue-600' : 'bg-gray-200' }} relative inline-flex h-6 w-11 flex-shrink-0 cursor-pointer rounded-full border-2 border-transparent transition-colors duration-200 ease-in-out focus:outline-none focus:ring-2 focus:ring-blue-600 focus:ring-offset-2">
                                        <span aria-hidden="true"
                                            class="{{ $uniform->active ? 'translate-x-5' : 'translate-x-0' }} pointer-events-none inline-block h-5 w-5 transform rounded-full bg-white shadow ring-0 transition duration-200 ease-in-out"></span>
                                    </button>
                                </td>
                                <td class="px-8 py-5 text-right">
                                    <div
                                        class="flex items-center justify-end gap-2 transition-opacity">
                                        <a href="{{ route('admin.uniforms.show', $uniform) }}"
                                           class="p-2 bg-white border border-gray-200 rounded-lg text-slate-600 hover:border-blue-500 hover:text-blue-600 transition-all shadow-sm"
                                           title="View Details">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                            </svg>
                                        </a>
                                        <a href="{{ route('admin.uniforms.edit', $uniform) }}"
                                            class="p-2 bg-white border border-gray-200 rounded-lg text-slate-600 hover:border-blue-500 hover:text-blue-600 transition-all shadow-sm">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M15.232 5.232l3.536 3.536m-2.036-5.036a2.5 2.5 0 113.536 3.536L6.5 21.036H3v-3.572L16.732 3.732z" />
                                            </svg>
                                        </a>
                                        <button
                                            onclick="openDeleteModal('{{ route('admin.uniforms.destroy', $uniform) }}', '{{ $uniform->name }}')"
                                            class="p-2 bg-white border border-gray-200 rounded-lg text-slate-600 hover:border-red-500 hover:text-red-600 transition-all shadow-sm">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                            </svg>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="px-8 py-16 text-center">
                                    <div
                                        class="w-16 h-16 bg-slate-50 rounded-2xl flex items-center justify-center mx-auto mb-4">
                                        <svg class="w-8 h-8 text-slate-300" fill="none" stroke="currentColor"
                                            viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4" />
                                        </svg>
                                    </div>
                                    <h3 class="text-lg font-bold text-slate-900">No Uniforms Found</h3>
                                    <p class="text-slate-500 mt-1">Get started by creating your first uniform type.</p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection