@extends('layouts.admin')

@section('title', 'Skills & Attributes Master')
@section('page_title', 'Skills & Attributes')

@section('content')
    <div x-data="{ 
        showModal: false, 
        isEdit: false, 
        formData: { id: '', name: '', category: '' },
        openCreate() {
            this.isEdit = false;
            this.formData = { id: '', name: '', category: 'Diplomas, Trainings & Special Skills' };
            this.showModal = true;
        },
        openEdit(skill) {
            this.isEdit = true;
            this.formData = { id: skill.id, name: skill.name, category: skill.category };
            this.showModal = true;
        }
    }">
        <!-- Header Area -->
        <div class="mb-8 flex flex-col md:flex-row md:items-center md:justify-between gap-4">
            <div>
                <h1 class="text-2xl font-black text-slate-900 tracking-tight">Skills & Attributes</h1>
                <p class="text-sm text-slate-500 mt-1 font-medium">Manage master list of employee qualifications and skills.
                </p>
            </div>
            <button @click="openCreate()"
                class="flex items-center gap-2 bg-blue-600 hover:bg-blue-700 text-white px-6 py-3 rounded-xl text-xs font-bold uppercase tracking-wider transition-all shadow-lg shadow-blue-200">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M12 4v16m8-8H4"></path>
                </svg>
                Add New Skill
            </button>
        </div>

        <!-- Stats Bar -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-8">
            <div class="bg-white p-6 rounded-2xl border border-slate-100 shadow-sm">
                <div class="text-[10px] font-bold text-slate-400 uppercase tracking-widest mb-1">Total Skills</div>
                <div class="text-2xl font-black text-slate-900">{{ $skills->count() }}</div>
            </div>
            <div class="bg-white p-6 rounded-2xl border border-slate-100 shadow-sm">
                <div class="text-[10px] font-bold text-slate-400 uppercase tracking-widest mb-1">Active Categories</div>
                <div class="text-2xl font-black text-blue-600">{{ $skills->unique('category')->count() }}</div>
            </div>
            <div class="bg-white p-6 rounded-2xl border border-slate-100 shadow-sm">
                <div class="text-[10px] font-bold text-slate-400 uppercase tracking-widest mb-1">Global Skills</div>
                <div class="text-2xl font-black text-indigo-600">{{ $skills->where('active', true)->count() }}</div>
            </div>
        </div>

        <!-- Main Table Card -->
        <div class="bg-white border border-slate-100 rounded-3xl shadow-xl overflow-hidden">
            <table class="w-full text-left border-collapse">
                <thead>
                    <tr class="bg-slate-900">
                        <th class="px-6 py-4 text-[11px] font-black uppercase text-slate-400 tracking-wider">Description /
                            Title</th>
                        <th class="px-6 py-4 text-[11px] font-black uppercase text-slate-400 tracking-wider">Category</th>
                        <th class="px-6 py-4 text-[11px] font-black uppercase text-slate-400 tracking-wider">Status</th>
                        <th class="px-6 py-4 text-[11px] font-black uppercase text-slate-400 tracking-wider text-right">
                            Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-slate-50">
                    @forelse($skills as $skill)
                        <tr class="hover:bg-slate-50/50 transition-colors group">
                            <td class="px-6 py-5">
                                <div class="flex items-center gap-3">
                                    <div
                                        class="w-10 h-10 rounded-xl bg-blue-50 flex items-center justify-center text-blue-600 font-bold text-xs">
                                        {{ substr($skill->name, 0, 1) }}
                                    </div>
                                    <div>
                                        <div class="text-sm font-bold text-slate-900">{{ $skill->name }}</div>
                                        <div class="text-[10px] text-slate-400 font-medium uppercase mt-0.5 tracking-tight">ID:
                                            #SK-{{ str_pad($skill->id, 4, '0', STR_PAD_LEFT) }}</div>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-5">
                                <span
                                    class="px-3 py-1 bg-slate-100 text-slate-600 text-[10px] font-bold rounded-lg uppercase tracking-wider">
                                    {{ $skill->category }}
                                </span>
                            </td>
                            <td class="px-6 py-5">
                                <button onclick="toggleStatus('{{ route('admin.skills.toggle-status', $skill) }}', this)"
                                    class="relative inline-flex h-6 w-11 flex-shrink-0 cursor-pointer rounded-full border-2 border-transparent transition-colors duration-200 focus:outline-none {{ $skill->active ? 'bg-blue-600' : 'bg-gray-200' }}"
                                    role="switch" aria-checked="{{ $skill->active ? 'true' : 'false' }}">
                                    <span
                                        class="pointer-events-none inline-block h-5 w-5 transform rounded-full bg-white shadow ring-0 transition duration-200 ease-in-out {{ $skill->active ? 'translate-x-5' : 'translate-x-0' }}"></span>
                                </button>
                            </td>
                            <td class="px-6 py-5">
                                <div class="flex items-center justify-end gap-2">
                                    <button @click="openEdit({{ json_encode($skill) }})"
                                        class="p-2 text-slate-400 hover:text-blue-600 hover:bg-blue-50 rounded-lg transition-all"
                                        title="Edit Skill">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z">
                                            </path>
                                        </svg>
                                    </button>
                                    <button
                                        onclick="openDeleteModal('{{ route('admin.skills.destroy', $skill) }}', '{{ $skill->name }}')"
                                        class="p-2 text-slate-400 hover:text-red-600 hover:bg-red-50 rounded-lg transition-all"
                                        title="Delete Skill">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16">
                                            </path>
                                        </svg>
                                    </button>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" class="px-6 py-12 text-center">
                                <div class="flex flex-col items-center">
                                    <div
                                        class="w-16 h-16 bg-slate-50 rounded-3xl flex items-center justify-center text-slate-400 mb-4">
                                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                                d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                                        </svg>
                                    </div>
                                    <h3 class="text-sm font-bold text-slate-900">No skills found</h3>
                                    <p class="text-xs text-slate-500 mt-1 uppercase tracking-wider font-medium">Click the button
                                        above to add your first skill.</p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <!-- Modal -->
        <template x-if="showModal">
            <div class="fixed inset-0 z-[100] flex items-center justify-center p-4">
                <div class="absolute inset-0 bg-slate-900/40 backdrop-blur-sm" @click="showModal = false"></div>

                <div
                    class="bg-white rounded-3xl shadow-2xl w-full max-w-lg overflow-hidden border border-slate-100 relative z-10">
                    <form
                        :action="isEdit ? `{{ url('admin/skills') }}/${formData.id}` : `{{ route('admin.skills.store') }}`"
                        method="POST">
                        @csrf
                        <template x-if="isEdit">
                            @method('PUT')
                        </template>

                        <div class="px-8 py-6 bg-slate-900 text-white flex items-center justify-between">
                            <div>
                                <h3 class="text-sm font-black uppercase tracking-widest text-slate-400"
                                    x-text="isEdit ? 'Edit Skill Master' : 'New Skill Attribute'"></h3>
                                <p class="text-xs text-slate-500 font-bold mt-1"
                                    x-text="isEdit ? 'Update existing skill definition' : 'Create a new qualification type'">
                                </p>
                            </div>
                            <button type="button" @click="showModal = false"
                                class="p-2 hover:bg-white/10 rounded-xl transition-all">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5"
                                        d="M6 18L18 6M6 6l12 12"></path>
                                </svg>
                            </button>
                        </div>

                        <div class="p-8 space-y-6">
                            <div>
                                <label
                                    class="text-[11px] font-black text-slate-500 uppercase tracking-wider mb-2 block">Skill
                                    / Attribute Name</label>
                                <input type="text" name="name" x-model="formData.name" required
                                    placeholder="e.g. First Aid Level 2"
                                    class="w-full px-4 py-3.5 bg-slate-50 border border-slate-200 rounded-xl focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all text-sm font-bold text-slate-900 placeholder:text-slate-300">
                            </div>

                            <div>
                                <label
                                    class="text-[11px] font-black text-slate-500 uppercase tracking-wider mb-2 block">Category</label>
                                <select name="category" x-model="formData.category"
                                    class="w-full px-4 py-3.5 bg-slate-50 border border-slate-200 rounded-xl focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all text-sm font-bold text-slate-900">
                                    <option value="Diplomas, Trainings & Special Skills">Diplomas, Trainings & Special
                                        Skills</option>
                                    <option value="Security Clearances">Security Clearances</option>
                                    <option value="Equipment & Uniforms">Equipment & Uniforms</option>
                                    <option value="Other Skills">Other Skills</option>
                                </select>
                            </div>
                        </div>

                        <div class="px-8 py-6 bg-slate-50 border-t border-slate-100 flex items-center gap-3">
                            <button type="button" @click="showModal = false"
                                class="flex-1 px-6 py-3.5 rounded-xl border border-slate-200 text-slate-600 font-bold text-xs uppercase tracking-widest hover:bg-white transition-all">Cancel</button>
                            <button type="submit"
                                class="flex-1 px-6 py-3.5 bg-blue-600 text-white rounded-xl font-bold text-xs uppercase tracking-widest hover:bg-blue-700 transition-all shadow-lg shadow-blue-100"
                                x-text="isEdit ? 'Update Skill' : 'Create Skill'"></button>
                        </div>
                    </form>
                </div>
            </div>
        </template>
    </div>
@endsection