@extends('layouts.admin')

@section('title', 'CSS Settings')
@section('page_title', 'CSS Settings')

@section('content')
    <div class="mb-6">
        <h1 class="text-2xl font-bold text-gray-800">CSS Settings</h1>
        <p class="text-gray-500 text-sm mt-1">Configure global typography for heading tags (h1-h6).</p>
    </div>

    @if(session('success'))
        <div class="mb-6 p-4 bg-green-50 border border-green-100 text-green-700 rounded-lg flex items-center gap-3">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
            </svg>
            {{ session('success') }}
        </div>
    @endif

    <div class="max-w-4xl">
        <form action="{{ route('admin.settings.css.update') }}" method="POST">
            @csrf

            <div class="bg-white rounded-lg border border-gray-100 shadow-sm overflow-hidden">
                <div class="p-6 space-y-6">
                    <!-- Font Family -->
                    <div>
                        <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">Font Family (Google
                            Fonts)</label>
                        <div class="relative group">
                            <select name="font_family"
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all appearance-none cursor-pointer">
                                @foreach($googleFonts as $font)
                                    <option value="{{ $font }}" {{ ($settings['font_family'] ?? 'Inter') == $font ? 'selected' : '' }}>{{ $font }}</option>
                                @endforeach
                            </select>
                            <div class="absolute right-3 top-1/2 -translate-y-1/2 pointer-events-none text-gray-400">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M19 9l-7 7-7-7"></path>
                                </svg>
                            </div>
                        </div>
                        <p class="mt-1 text-xs text-gray-400">Select from 100 popular Google Fonts to apply to all headings.
                        </p>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Font Size -->
                        <div>
                            <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">Base Font Size (H1
                                Reference)</label>
                            <div class="relative group">
                                <select name="font_size"
                                    class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all appearance-none cursor-pointer">
                                    @for($i = 12; $i <= 72; $i += 2)
                                        <option value="{{ $i }}px" {{ ($settings['font_size'] ?? '32px') == $i . 'px' ? 'selected' : '' }}>{{ $i }}px</option>
                                    @endfor
                                </select>
                                <div class="absolute right-3 top-1/2 -translate-y-1/2 pointer-events-none text-gray-400">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M19 9l-7 7-7-7"></path>
                                    </svg>
                                </div>
                            </div>
                        </div>

                        <!-- Font Weight -->
                        <div>
                            <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">Font Weight</label>
                            <div class="relative group">
                                <select name="font_weight"
                                    class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all appearance-none cursor-pointer">
                                    <option value="300" {{ ($settings['font_weight'] ?? '700') == '300' ? 'selected' : '' }}>
                                        Light (300)</option>
                                    <option value="400" {{ ($settings['font_weight'] ?? '700') == '400' ? 'selected' : '' }}>
                                        Regular (400)</option>
                                    <option value="500" {{ ($settings['font_weight'] ?? '700') == '500' ? 'selected' : '' }}>
                                        Medium (500)</option>
                                    <option value="600" {{ ($settings['font_weight'] ?? '700') == '600' ? 'selected' : '' }}>
                                        Semi-Bold (600)</option>
                                    <option value="700" {{ ($settings['font_weight'] ?? '700') == '700' ? 'selected' : '' }}>
                                        Bold (700)</option>
                                    <option value="800" {{ ($settings['font_weight'] ?? '700') == '800' ? 'selected' : '' }}>
                                        Extra-Bold (800)</option>
                                    <option value="900" {{ ($settings['font_weight'] ?? '700') == '900' ? 'selected' : '' }}>
                                        Black (900)</option>
                                </select>
                                <div class="absolute right-3 top-1/2 -translate-y-1/2 pointer-events-none text-gray-400">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M19 9l-7 7-7-7"></path>
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Preview Area -->
                    <div class="mt-6 p-6 bg-gray-50 rounded-lg border border-dashed border-gray-200">
                        <p class="text-xs font-bold text-gray-400 uppercase tracking-wider mb-4 text-center">Live Preview
                        </p>
                        <div class="space-y-4 text-center">
                            <h1 class="preview-h text-gray-900"
                                style="font-family: '{{ $settings['font_family'] ?? 'Inter' }}'; font-size: {{ $settings['font_size'] ?? '32px' }}; font-weight: {{ $settings['font_weight'] ?? '700' }};">
                                Heading 1 Preview</h1>
                            <h2 class="preview-h text-gray-800"
                                style="font-family: '{{ $settings['font_family'] ?? 'Inter' }}'; font-size: calc({{ $settings['font_size'] ?? '32px' }} * 0.8); font-weight: {{ $settings['font_weight'] ?? '700' }};">
                                Heading 2 Preview</h2>
                            <h3 class="preview-h text-gray-700"
                                style="font-family: '{{ $settings['font_family'] ?? 'Inter' }}'; font-size: calc({{ $settings['font_size'] ?? '32px' }} * 0.7); font-weight: {{ $settings['font_weight'] ?? '700' }};">
                                Heading 3 Preview</h3>
                        </div>
                    </div>
                </div>

                <div class="px-6 py-4 bg-gray-50 border-t border-gray-100 flex items-center justify-end gap-3">
                    <a href="{{ route('admin.dashboard') }}"
                        class="px-4 py-2 rounded-md border border-gray-300 text-gray-700 font-bold hover:bg-white text-sm transition-all shadow-sm">Cancel</a>
                    <button type="submit"
                        class="px-6 py-2 bg-blue-600 text-white rounded-md font-bold hover:bg-blue-700 transition-all shadow-sm text-sm">Save
                        Configuration</button>
                </div>
            </div>
        </form>
    </div>

    @push('scripts')
        <script>
            const selects = document.querySelectorAll('select');
            const previews = document.querySelectorAll('.preview-h');

            selects.forEach(select => {
                select.addEventListener('change', () => {
                    const family = document.querySelector('[name="font_family"]').value;
                    const size = document.querySelector('[name="font_size"]').value;
                    const weight = document.querySelector('[name="font_weight"]').value;

                    // Load font if not loaded
                    if (family) {
                        const link = document.createElement('link');
                        link.rel = 'stylesheet';
                        link.href = `https://fonts.googleapis.com/css2?family=${family.replace(/ /g, '+')}:wght@${weight}&display=swap`;
                        document.head.appendChild(link);
                    }

                    previews[0].style.fontFamily = `'${family}'`;
                    previews[0].style.fontSize = size;
                    previews[0].style.fontWeight = weight;

                    const baseSize = parseInt(size);
                    previews[1].style.fontFamily = `'${family}'`;
                    previews[1].style.fontSize = (baseSize * 0.8) + 'px';
                    previews[1].style.fontWeight = weight;

                    previews[2].style.fontFamily = `'${family}'`;
                    previews[2].style.fontSize = (baseSize * 0.7) + 'px';
                    previews[2].style.fontWeight = weight;
                });
            });
        </script>
    @endpush
@endsection