@extends('layouts.admin')

@section('title', 'Request Types')
@section('page_title', 'Request Types')

@section('content')
    <div class="mb-6 flex flex-col md:flex-row md:items-center justify-between gap-4">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Request Types</h1>
            <p class="text-gray-500 text-sm">Manage types of requests employees can submit.</p>
        </div>
        <div class="flex items-center gap-3">
            <a href="{{ route('admin.request-types.create') }}"
                class="inline-flex items-center gap-2 bg-blue-600 text-white px-4 py-2.5 rounded-xl font-semibold hover:bg-blue-700 transition-all shadow-lg shadow-blue-200">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6">
                    </path>
                </svg>
                Add Request Type
            </a>
        </div>
    </div>

    @if(session('success'))
        <div class="mb-6 p-4 bg-emerald-50 border border-emerald-100 text-emerald-700 rounded-xl flex items-center gap-3">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
            </svg>
            {{ session('success') }}
        </div>
    @endif

    <div class="bg-white rounded-2xl border border-gray-100 shadow-sm overflow-hidden">
        <table class="w-full text-left border-collapse">
            <thead class="bg-[#1e293b]">
                <tr>
                    <th class="px-6 py-4 text-xs font-bold text-white uppercase tracking-wider">Name</th>
                    <th class="px-6 py-4 text-xs font-bold text-white uppercase tracking-wider">Key (Internal)</th>
                    <th class="px-6 py-4 text-xs font-bold text-white uppercase tracking-wider">Status</th>
                    <th class="px-6 py-4 text-xs font-bold text-white uppercase tracking-wider text-right">Actions</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-50">
                @forelse($requestTypes as $type)
                    <tr class="hover:bg-gray-50/50 transition-colors">
                        <td class="px-6 py-4 text-sm font-bold text-gray-900">{{ $type->name }}</td>
                        <td class="px-6 py-4 text-sm text-gray-500 font-mono">{{ $type->key }}</td>
                        <td class="px-6 py-4">
                            @if($type->is_active)
                                <span class="px-2 py-1 bg-green-50 text-green-700 text-xs rounded-lg font-bold">Active</span>
                            @else
                                <span class="px-2 py-1 bg-gray-50 text-gray-700 text-xs rounded-lg font-bold">Inactive</span>
                            @endif
                        </td>
                        <td class="px-6 py-4 text-right">
                            <div class="flex items-center justify-end gap-2">
                                <a href="{{ route('admin.request-types.edit', $type) }}"
                                    class="p-2 text-gray-400 hover:text-blue-600 hover:bg-blue-50 rounded-lg transition-all"
                                    title="Edit">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z">
                                        </path>
                                    </svg>
                                </a>
                                {{-- Simple form delete for MVP --}}
                                <form action="{{ route('admin.request-types.destroy', $type) }}" method="POST"
                                    onsubmit="return confirm('Are you sure you want to delete this request type?');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit"
                                        class="p-2 text-gray-400 hover:text-red-600 hover:bg-red-50 rounded-lg transition-all"
                                        title="Delete">
                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16">
                                            </path>
                                        </svg>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="4" class="px-6 py-12 text-center text-gray-500">
                            No request types found.
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
@endsection