@extends('layouts.admin')

@section('title', 'Add Request Type')
@section('page_title', 'Add Request Type')

@section('content')
    <div class="mb-6">
        <h1 class="text-2xl font-bold text-gray-900">Add Request Type</h1>
        <p class="text-gray-500 text-sm">Create a new category for employee requests.</p>
    </div>

    <div class="bg-white rounded-2xl border border-gray-100 shadow-sm p-6 max-w-2xl">
        <form action="{{ route('admin.request-types.store') }}" method="POST">
            @csrf

            <div class="space-y-6">
                <div>
                    <label for="name" class="block text-sm font-bold text-gray-700 mb-2">Request Type Name</label>
                    <input type="text" name="name" id="name" required
                        class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:ring-4 focus:ring-blue-100 focus:border-blue-500 transition-all outline-none"
                        placeholder="e.g. Vacation Request">
                </div>

                <div>
                    <label for="template" class="block text-sm font-bold text-gray-700 mb-2">
                        Additional Information / Message Template
                        <span class="text-xs font-normal text-gray-400 ml-1">(Optional)</span>
                    </label>
                    <p class="text-xs text-gray-500 mb-2">This text will be shown to the employee as a placeholder/hint for
                        the request message.</p>
                    <textarea name="template" id="template" rows="5"
                        class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:ring-4 focus:ring-blue-100 focus:border-blue-500 transition-all outline-none"
                        placeholder="Enter template text or instructions..."></textarea>
                </div>

                <div class="flex items-center gap-4 pt-4">
                    <button type="submit"
                        class="bg-blue-600 text-white px-6 py-3 rounded-xl font-bold hover:bg-blue-700 transition-all shadow-lg shadow-blue-200">
                        Create Request Type
                    </button>
                    <a href="{{ route('admin.request-types.index') }}"
                        class="text-gray-500 hover:text-gray-700 font-semibold px-4">
                        Cancel
                    </a>
                </div>
            </div>
        </form>
    </div>
@endsection