<!DOCTYPE html>
<html>

<head>
    <title>Route Payout Report</title>
    <style>
        body {
            font-family: sans-serif;
            font-size: 10px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
            margin-bottom: 20px;
        }

        th,
        td {
            border: 1px solid #ccc;
            padding: 5px;
            text-align: left;
        }

        th {
            background: #f2f2f2;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
        }

        .route-section {
            margin-bottom: 30px;
        }
    </style>
</head>

<body>
    <div class="header">
        <h2>Route Payout Report</h2>
        <p>Period: {{ $startDate }} to {{ $endDate }}</p>
    </div>

    @foreach($payoutData as $routeId => $data)
        <div class="route-section">
            <h3 style="margin-bottom: 5px;">{{ $data['route_name'] }}</h3>
            <table>
                <thead>
                    <tr>
                        <th>Employee</th>
                        <th>Duty #</th>
                        <th>In Time</th>
                        <th>Out Time</th>
                        <th>Hours</th>
                        <th>Total Pay</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($data['employees'] as $employee)
                        <tr>
                            <td>{{ $employee['employee_name'] }}</td>
                            <td>#{{ $employee['duty_number'] }}</td>
                            <td>{{ $employee['in_time'] }}</td>
                            <td>{{ $employee['out_time'] }}</td>
                            <td>{{ $employee['hours'] }}</td>
                            <td style="text-align: right;">${{ number_format($employee['total'], 2) }}</td>
                        </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr style="font-weight: bold; background: #fafafa;">
                        <td colspan="4" style="text-align: right;">Route Total:</td>
                        <td>{{ number_format($data['total_hours'], 2) }}</td>
                        <td style="text-align: right;">${{ number_format($data['total_amount'], 2) }}</td>
                    </tr>
                </tfoot>
            </table>
        </div>
    @endforeach

</body>

</html>