<!DOCTYPE html>
<html>

<head>
    <title>Patroller In/Out Report</title>
    <style>
        body {
            font-family: sans-serif;
            font-size: 10px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        th,
        td {
            border: 1px solid #ccc;
            padding: 5px;
            text-align: left;
        }

        th {
            background: #f2f2f2;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
        }

        .footer {
            position: fixed;
            bottom: 0;
            width: 100%;
            text-align: center;
            font-size: 8px;
        }
    </style>
</head>

<body>
    <div class="header">
        <h2>Patroller In/Out Report</h2>
        <p>Generated on: {{ now()->format('Y-m-d H:i') }}</p>
    </div>

    <table>
        <thead>
            <tr>
                <th>Date</th>
                <th>Employee</th>
                <th>In Time</th>
                <th>Out Time</th>
                <th>Route</th>
                <th>Duty #</th>
            </tr>
        </thead>
        <tbody>
            @foreach($reports as $report)
                <tr>
                    <td>{{ \Carbon\Carbon::parse($report->from_time)->format('Y-m-d') }}</td>
                    <td>{{ $report->first_name }} {{ $report->last_name }}</td>
                    <td>{{ $report->actual_start_at ? \Carbon\Carbon::parse($report->actual_start_at)->format('H:i') : '-' }}
                    </td>
                    <td>{{ $report->actual_end_at ? \Carbon\Carbon::parse($report->actual_end_at)->format('H:i') : '-' }}
                    </td>
                    <td>{{ $report->route_name }}</td>
                    <td>#{{ $report->duty_number }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <div class="footer">
        Page <span class="pagenum"></span>
    </div>
</body>

</html>