<!DOCTYPE html>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Late Check-in Report</title>
    <style>
        body {
            font-family: sans-serif;
            font-size: 10px;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
        }

        .header h1 {
            margin: 0;
            font-size: 18px;
        }

        .header p {
            margin: 5px 0;
            color: #666;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        th,
        td {
            border: 1px solid #ddd;
            padding: 5px;
            text-align: left;
        }

        th {
            background-color: #f9fafb;
            font-weight: bold;
            color: #4b5563;
        }

        .text-red {
            color: #dc2626;
        }

        .font-bold {
            font-weight: bold;
        }
    </style>
</head>

<body>
    <div class="header">
        @if($company)
            <div style="margin-bottom: 10px;">
                <h2 style="margin: 0; font-size: 20px; text-transform: uppercase;">{{ $company->name }}</h2>
                <p style="margin: 2px 0; font-size: 11px; color: #4b5563;">
                    {{ $company->address_1 }}{{ $company->address_2 ? ', ' . $company->address_2 : '' }}
                </p>
            </div>
        @endif
        <h1 style="border-top: 1px solid #e5e7eb; padding-top: 10px; margin-top: 10px;">Late Check-in Report</h1>
        <p>{{ \Carbon\Carbon::parse($startDate)->format('M d, Y') }} -
            {{ \Carbon\Carbon::parse($endDate)->format('M d, Y') }}
        </p>
    </div>

    <table>
        <thead>
            <tr>
                <th>Duty ID</th>
                <th>Employee Name</th>
                <th>Site</th>
                <th>Date</th>
                <th>Scheduled Start</th>
                <th>Actual Start</th>
                <th>Delay</th>
            </tr>
        </thead>
        <tbody>
            @foreach($lateCheckins as $row)
                <tr>
                    <td>{{ $row->duty_number }}</td>
                    <td>{{ $row->first_name }} {{ $row->last_name }}</td>
                    <td>{{ $row->site_name }}</td>
                    <td>{{ \Carbon\Carbon::parse($row->schedule_date)->format('Y-m-d') }}</td>
                    <td>{{ \Carbon\Carbon::parse($row->scheduled_start)->format('H:i') }}</td>
                    <td class="text-red font-bold">{{ \Carbon\Carbon::parse($row->actual_start_at)->format('H:i') }}</td>
                    <td class="text-red font-bold">
                        @php
                            $scheduled = \Carbon\Carbon::parse($row->scheduled_start);
                            $actual = \Carbon\Carbon::parse($row->actual_start_at);
                            $diff = $scheduled->diff($actual)->format('%H:%I:%S');
                        @endphp
                        {{ $diff }}
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>

</html>