<!DOCTYPE html>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Incident Counts Report</title>
    <style>
        body {
            font-family: sans-serif;
            font-size: 10px;
        }

        h1 {
            font-size: 16px;
            margin-bottom: 20px;
            text-align: center;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        th,
        td {
            border: 1px solid #ddd;
            padding: 4px;
            text-align: center;
        }

        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }

        td:first-child,
        th:first-child {
            text-align: left;
        }

        .total-col {
            font-weight: bold;
            background-color: #fafafa;
        }

        .has-data {
            color: #dc2626;
            font-weight: bold;
        }
    </style>
</head>

<body>
    <div style="margin-bottom: 20px;">
        @if($company)
            <div style="margin-bottom: 15px; border-bottom: 2px solid #1e293b; padding-bottom: 10px;">
                <h2 style="margin: 0; font-size: 20px; color: #1e293b; text-transform: uppercase;">{{ $company->name }}</h2>
                <p style="margin: 2px 0; font-size: 11px; color: #4b5563;">
                    {{ $company->address_1 }}{{ $company->address_2 ? ', ' . $company->address_2 : '' }}
                </p>
            </div>
        @endif
        <h3 style="margin: 0; color: #334155;">Incident Counts Report - {{ $monthName }} {{ $year }}</h3>
        <p style="margin: 2px 0; font-size: 10px; color: #64748b;">Generated By: {{ auth()->user()->name }}</p>
        <p style="margin: 2px 0; font-size: 10px; color: #64748b;">Date Generated: {{ now()->format('M d, Y H:i') }}</p>
    </div>

    <table>
        <thead>
            <tr>
                <th>Site</th>
                @for($d = 1; $d <= $days; $d++)
                    <th>{{ $d }}</th>
                @endfor
                <th class="total-col">Total</th>
            </tr>
        </thead>
        <tbody>
            @foreach($reportData as $row)
                <tr>
                    <td>{{ $row['site'] }}</td>
                    @for($d = 1; $d <= $days; $d++)
                        <td class="{{ $row['days'][$d] > 0 ? 'has-data' : '' }}">
                            {{ $row['days'][$d] > 0 ? $row['days'][$d] : '' }}
                        </td>
                    @endfor
                    <td class="total-col">{{ $row['total'] }}</td>
                </tr>
            @endforeach
        </tbody>
        <tfoot>
            <tr style="background-color: #f9f9f9; font-weight: bold;">
                <td>Totals</td>
                @for($d = 1; $d <= $days; $d++)
                    @php
                        $colTotal = collect($reportData)->sum(fn($r) => $r['days'][$d]);
                    @endphp
                    <td>{{ $colTotal > 0 ? $colTotal : '' }}</td>
                @endfor
                <td>{{ collect($reportData)->sum('total') }}</td>
            </tr>
        </tfoot>
    </table>
</body>

</html>