<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Guard Payout Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 9px;
            margin: 15px;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #1e293b;
            padding-bottom: 10px;
        }

        .header h1 {
            margin: 0;
            font-size: 18px;
            color: #1e293b;
        }

        .header p {
            margin: 5px 0;
            color: #64748b;
            font-size: 11px;
        }

        .employee-group {
            margin-bottom: 25px;
            page-break-inside: avoid;
        }

        .employee-header {
            background-color: #f3f4f6;
            padding: 8px 10px;
            font-weight: bold;
            font-size: 12px;
            color: #1f2937;
            border-bottom: 2px solid #e5e7eb;
            margin-bottom: 5px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px;
        }

        th {
            background-color: #1e293b;
            color: white;
            padding: 7px 5px;
            text-align: left;
            font-size: 7px;
            font-weight: bold;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        th.text-right {
            text-align: right;
        }

        td {
            padding: 5px;
            border-bottom: 1px solid #e5e7eb;
            font-size: 8px;
            vertical-align: top;
        }

        td.text-right {
            text-align: right;
        }

        td.font-bold {
            font-weight: bold;
        }

        .subtotal-row {
            background-color: #f3f4f6;
            font-weight: bold;
        }

        .subtotal-row td {
            padding: 8px 5px;
            border-top: 2px solid #d1d5db;
        }

        .wage-component {
            background-color: #eff6ff;
            border: 1px solid #bfdbfe;
            padding: 3px 5px;
            margin: 2px 0;
            border-radius: 3px;
            font-size: 7px;
        }

        .wage-component-name {
            color: #1e40af;
            font-weight: bold;
            text-transform: uppercase;
            font-size: 6px;
        }

        .wage-component-calc {
            color: #64748b;
            font-size: 6px;
        }

        .wage-component-amount {
            color: #1e40af;
            font-weight: bold;
        }

        .gas-component {
            background-color: #fef3c7;
            border: 1px solid #fcd34d;
            padding: 3px 5px;
            margin: 2px 0;
            border-radius: 3px;
            font-size: 7px;
        }

        .gas-component-name {
            color: #b45309;
            font-weight: bold;
            text-transform: uppercase;
            font-size: 6px;
        }

        .gas-component-amount {
            color: #b45309;
            font-weight: bold;
        }

        .no-wage {
            color: #9ca3af;
            font-style: italic;
            font-size: 7px;
        }

        .badge {
            display: inline-block;
            padding: 2px 5px;
            font-size: 6px;
            font-weight: bold;
            text-transform: uppercase;
            background-color: #e9d5ff;
            color: #7c3aed;
            border-radius: 3px;
            border: 1px solid #c084fc;
        }
    </style>
</head>

<body>

    <body>
        <div style="margin-bottom: 20px;">
            @if($company)
                <div style="margin-bottom: 15px; border-bottom: 2px solid #1e293b; padding-bottom: 10px;">
                    <h2 style="margin: 0; font-size: 20px; color: #1e293b; text-transform: uppercase;">{{ $company->name }}
                    </h2>
                    <p style="margin: 2px 0; font-size: 11px; color: #4b5563;">
                        {{ $company->address_1 }}{{ $company->address_2 ? ', ' . $company->address_2 : '' }}
                    </p>
                </div>
            @endif
            <h3 style="margin: 0; color: #334155;">Guard Payout Report</h3>
            <p style="margin: 2px 0; font-size: 10px; color: #64748b;">Type: {{ ucfirst($reportType ?? 'Actual') }}
                Hours</p>
            <p style="margin: 2px 0; font-size: 10px; color: #64748b;">Period:
                {{ \Carbon\Carbon::parse($startDate)->format('M d, Y') }} -
                {{ \Carbon\Carbon::parse($endDate)->format('M d, Y') }}
            </p>
            <p style="margin: 2px 0; font-size: 10px; color: #64748b;">Generated By: {{ auth()->user()->name }}</p>
            <p style="margin: 2px 0; font-size: 10px; color: #64748b;">Date Generated: {{ now()->format('M d, Y H:i') }}
            </p>
        </div>

        @foreach($groupedPayouts as $employeeName => $group)
            <div class="employee-group">
                <div class="employee-header">{{ $employeeName }}</div>

                <table>
                    <thead>
                        <tr>
                            <th>Duty #</th>
                            <th>Site</th>
                            <th>Site ID</th>
                            <th>From</th>
                            <th>To</th>
                            <th>Hrs</th>
                            <th style="width: 35%;">Wage Components</th>
                            <th class="text-right">Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($group['items'] as $row)
                            @php
                                $wageTypes = json_decode($row->wage_types, true) ?: [];
                                $gasRate = $row->gas_rate > 0 ? $row->gas_rate : 0;
                            @endphp

                            <tr>
                                <td>
                                    {{ $row->duty_number }}
                                    @if(isset($row->stat_multiplier) && $row->stat_multiplier > 1)
                                        <span class="badge">STAT</span>
                                    @endif
                                </td>
                                <td>{{ $row->site_name }}</td>
                                <td style="font-family: monospace; font-size: 7px;">{{ $row->site_custom_id }}</td>
                                <td>{{ \Carbon\Carbon::parse($row->view_start)->format('m/d H:i') }}</td>
                                <td>{{ \Carbon\Carbon::parse($row->view_end)->format('m/d H:i') }}</td>
                                <td class="font-bold">{{ number_format($row->view_hours, 2) }}</td>
                                <td>
                                    @if(!empty($wageTypes) || $gasRate > 0)
                                        @foreach($wageTypes as $wageType)
                                            @php
                                                $componentHours = $wageType['allocated_hours'] ?? 0;
                                                $componentRate = $wageType['rate'] ?? 0;
                                                $componentPay = $componentHours * $componentRate;
                                            @endphp
                                            <div class="wage-component">
                                                <span class="wage-component-name">{{ $wageType['name'] ?? 'Wage' }}</span><br>
                                                <span class="wage-component-calc">{{ number_format($componentHours, 2) }} hrs ×
                                                    ${{ number_format($componentRate, 2) }} = </span>
                                                <span class="wage-component-amount">${{ number_format($componentPay, 2) }}</span>
                                            </div>
                                        @endforeach

                                        @if($gasRate > 0)
                                            <div class="gas-component">
                                                <span class="gas-component-name">GAS/CASH</span><br>
                                                <span class="gas-component-amount">${{ number_format($gasRate, 2) }}</span>
                                            </div>
                                        @endif
                                    @else
                                        <span class="no-wage">No wage data</span>
                                    @endif
                                </td>
                                <td class="text-right font-bold">${{ number_format($row->total_amount, 2) }}</td>
                            </tr>
                        @endforeach

                        <!-- Subtotal Row -->
                        <tr class="subtotal-row">
                            <td colspan="4" class="text-right">Total</td>
                            <td class="font-bold">{{ number_format($group['total_hours'], 2) }}</td>
                            <td></td>
                            <td class="text-right font-bold">${{ number_format($group['total_amount'], 2) }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        @endforeach
    </body>

</html>