@extends('layouts.user')

@section('title', 'Employee Credentials')

@section('content')
    <div class="space-y-6" x-data="{ 
            search: '{{ request('search') }}',
            loading: false,
            timer: null,
            total: {{ $employees->count() }},
            doSearch() {
                this.loading = true;
                fetch('{{ route('reports.operational.passwords') }}?search=' + encodeURIComponent(this.search), {
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest'
                    }
                })
                .then(res => res.text())
                .then(html => {
                    document.getElementById('employee-table-body').innerHTML = html;
                    this.loading = false;
                    // Update total count locally
                    this.total = document.getElementById('employee-table-body').querySelectorAll('tr:not(.no-results)').length;
                    if(this.search === '') this.total = {{ $employees->count() }}; // Fallback if no search
                });
            }
        }">
        <!-- Filters -->
        <div class="bg-white p-4 rounded-xl shadow-sm border border-gray-200">
            <form method="GET" action="{{ route('reports.operational.passwords') }}" @submit.prevent="doSearch()"
                class="flex items-end gap-4">
                <div class="flex-1 max-w-sm">
                    <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Search
                        Employee</label>
                    <div class="relative">
                        <input type="text" name="search" x-model="search"
                            @input="clearTimeout(timer); timer = setTimeout(() => doSearch(), 500)"
                            placeholder="Search by name or email..."
                            class="w-full text-sm rounded-lg border-gray-300 focus:border-blue-500 focus:ring-blue-500 pl-8 py-2 shadow-sm">
                        <svg class="w-4 h-4 text-gray-400 absolute left-2.5 top-2.5" fill="none" stroke="currentColor"
                            viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                        </svg>
                        <div x-show="loading" class="absolute right-3 top-2.5">
                            <svg class="animate-spin h-4 w-4 text-blue-500" xmlns="http://www.w3.org/2000/svg" fill="none"
                                viewBox="0 0 24 24">
                                <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4">
                                </circle>
                                <path class="opacity-75" fill="currentColor"
                                    d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z">
                                </path>
                            </svg>
                        </div>
                    </div>
                </div>
                <button type="submit"
                    class="h-[38px] px-4 bg-slate-900 text-white text-sm font-medium rounded-lg hover:bg-slate-800 transition-colors shadow-sm">
                    Search
                </button>
            </form>
        </div>

        <!-- Report Type Tabs -->
        <div class="flex space-x-1 bg-white p-1 rounded-xl w-fit shadow-sm border border-gray-100">
            <a href="{{ route('reports.operational.banned') }}"
                class="px-4 py-2 text-xs font-bold uppercase tracking-wide rounded-lg transition-all {{ request()->routeIs('reports.operational.banned') ? 'bg-slate-100 text-slate-900 border border-slate-200' : 'text-slate-500 hover:text-slate-700 hover:bg-gray-50' }}">
                Banned Employees
            </a>
            <a href="{{ route('reports.operational.passwords') }}"
                class="px-4 py-2 text-xs font-bold uppercase tracking-wide rounded-lg transition-all {{ request()->routeIs('reports.operational.passwords') ? 'bg-slate-100 text-slate-900 border border-slate-200' : 'text-slate-500 hover:text-slate-700 hover:bg-gray-50' }}">
                Credentials
            </a>
        </div>

        <!-- Employee Table -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
            <div class="p-4 bg-gray-50 border-b border-gray-100 flex justify-between items-center">
                <h3 class="text-sm font-bold text-gray-800">Employee Credentials</h3>
                <span class="text-xs font-medium text-gray-500 bg-gray-100 px-2 py-1 rounded-md border border-gray-200">
                    Showing Result(s)
                </span>
            </div>
            <div class="overflow-x-auto">
                <table class="w-full text-left border-collapse">
                    <thead class="bg-white border-b border-gray-50">
                        <tr>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Employee Name
                            </th>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Employee ID
                            </th>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Email Address
                            </th>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Available
                                Days</th>
                        </tr>
                    </thead>
                    <tbody id="employee-table-body" class="divide-y divide-gray-50">
                        @include('admin.reports.operational.partials.password_table_rows', ['employees' => $employees])
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection