@extends('layouts.admin')

@section('content')
    <div class="p-6">
        <div class="mb-6 flex items-center justify-between">
            <a href="{{ route('admin.logs.index') }}"
                class="flex items-center gap-2 text-gray-500 hover:text-gray-900 transition-colors">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18">
                    </path>
                </svg>
                <span class="font-bold text-sm">Back to Logs</span>
            </a>
            <form action="{{ route('admin.logs.destroy', $log) }}" method="POST"
                onsubmit="return confirm('Delete this log entry?');">
                @csrf
                @method('DELETE')
                <button type="submit" class="text-red-600 hover:text-red-800 text-xs font-bold uppercase">Delete
                    Entry</button>
            </form>
        </div>

        <div class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden">
            <div class="p-6 border-b border-gray-100 bg-slate-50">
                <div class="flex items-start justify-between">
                    <div>
                        <h1 class="text-xl font-bold text-gray-900 mb-2">{{ $log->message }}</h1>
                        <div class="flex items-center gap-4 text-xs font-bold text-gray-500">
                            <span
                                class="uppercase tracking-wider px-2 py-1 bg-white border border-gray-200 rounded">{{ $log->level }}</span>
                            <span>{{ $log->created_at->format('M d, Y H:i:s A') }}</span>
                        </div>
                    </div>
                </div>
            </div>

            <div class="p-6 space-y-6">
                <!-- Context -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="bg-gray-50 p-4 rounded-lg border border-gray-100">
                        <h3 class="text-xs font-bold text-gray-400 uppercase mb-3">Request Details</h3>
                        <div class="space-y-2 text-sm">
                            <div class="flex justify-between">
                                <span class="text-gray-500">Values:</span>
                                <span class="font-mono text-gray-800">{{ $log->method }} {{ $log->url }}</span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-500">IP Address:</span>
                                <span class="font-mono text-gray-800">{{ $log->ip }}</span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-500">User ID:</span>
                                <span class="font-mono text-gray-800">{{ $log->user_id ?? 'Guest' }}</span>
                            </div>
                        </div>
                    </div>

                    <div class="bg-gray-50 p-4 rounded-lg border border-gray-100">
                        <h3 class="text-xs font-bold text-gray-400 uppercase mb-3">File Location</h3>
                        <div class="space-y-2 text-sm">
                            <p class="font-mono text-gray-800 break-all">{{ $log->file }}</p>
                            <p class="text-gray-500">Line: <span class="font-bold text-gray-800">{{ $log->line }}</span></p>
                        </div>
                    </div>
                </div>

                <!-- Stack Trace -->
                <div>
                    <h3 class="text-xs font-bold text-gray-400 uppercase mb-3">Stack Trace</h3>
                    <div
                        class="bg-slate-900 text-slate-300 p-4 rounded-lg font-mono text-xs overflow-x-auto whitespace-pre max-h-[500px] overflow-y-auto">
                        {{ $log->trace }}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection