@extends('layouts.admin')

@section('content')
    <div class="p-6">
        <div class="flex justify-between items-center mb-6">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">System Logs</h1>
                <p class="text-gray-500">View and manage application error logs.</p>
            </div>
            <form action="{{ route('admin.logs.clear') }}" method="POST"
                onsubmit="return confirm('Are you sure you want to clear ALL logs?');">
                @csrf
                @method('DELETE')
                <button type="submit"
                    class="px-4 py-2 bg-red-100 text-red-600 font-bold rounded-lg hover:bg-red-200 transition-colors">
                    Clear All Logs
                </button>
            </form>
        </div>

        <div class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden">
            <table class="w-full text-left border-collapse">
                <thead class="bg-slate-50 border-b border-gray-100">
                    <tr>
                        <th class="px-6 py-4 text-[11px] font-bold text-gray-400 uppercase">Time</th>
                        <th class="px-6 py-4 text-[11px] font-bold text-gray-400 uppercase">Level</th>
                        <th class="px-6 py-4 text-[11px] font-bold text-gray-400 uppercase">Message</th>
                        <th class="px-6 py-4 text-[11px] font-bold text-gray-400 uppercase">Location</th>
                        <th class="px-6 py-4 text-[11px] font-bold text-gray-400 uppercase text-right">Action</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    @forelse($logs as $log)
                        <tr class="hover:bg-slate-50 transition-colors">
                            <td class="px-6 py-4 text-xs font-bold text-gray-600 whitespace-nowrap">
                                {{ $log->created_at->format('M d, Y H:i:s') }}
                            </td>
                            <td class="px-6 py-4">
                                <span
                                    class="px-2 py-1 rounded text-[10px] font-bold uppercase
                                        {{ $log->level === 'error' ? 'bg-red-100 text-red-600' : 'bg-gray-100 text-gray-600' }}">
                                    {{ $log->level }}
                                </span>
                            </td>
                            <td class="px-6 py-4 max-w-md">
                                <div class="text-sm font-bold text-gray-800 truncate" title="{{ $log->message }}">
                                    {{ Str::limit($log->message, 80) }}
                                </div>
                                <div class="text-xs text-gray-400 font-mono mt-1">{{ $log->url }}</div>
                            </td>
                            <td class="px-6 py-4 text-xs text-gray-500">
                                @if($log->file)
                                    <div class="font-mono truncate w-48" title="{{ $log->file }}:{{ $log->line }}">
                                        {{ basename($log->file) }}:{{ $log->line }}
                                    </div>
                                @endif
                            </td>
                            <td class="px-6 py-4 text-right">
                                <a href="{{ route('admin.logs.show', $log) }}"
                                    class="text-blue-600 hover:text-blue-800 text-xs font-bold mr-2">View</a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="px-6 py-12 text-center text-gray-400 italic">
                                No logs found. System is running smoothly.
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div class="mt-4">
            {{ $logs->links() }}
        </div>
    </div>
@endsection