@extends('layouts.admin')

@section('title', 'Admin - Lead Management')
@section('page_title', 'All Leads')

@section('content')
    <div class="p-6">
        <div class="flex justify-between items-center mb-6">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">All Leads</h1>
                <p class="text-gray-500">Monitor and manage all leads across the system.</p>
            </div>
            <!-- Optional: Add Lead Button -->
            <!-- <a href="{{ route('admin.leads.create') }}" class="px-6 py-2 bg-blue-600 text-white font-bold rounded-lg hover:bg-blue-700">+ New Lead</a> -->
        </div>

        <!-- Filter Bar -->
        <div class="bg-white p-4 rounded-xl border border-gray-100 shadow-sm mb-6">
            <form method="GET" action="{{ route('admin.leads.index') }}" class="flex flex-wrap items-end gap-4">

                <!-- Company Name Filter -->
                <div class="w-full md:w-auto">
                    <label class="block text-xs font-bold text-gray-500 uppercase mb-1">Company Name</label>
                    <input type="text" name="company_name" value="{{ request('company_name') }}"
                        placeholder="Search company..."
                        class="w-full md:w-48 px-3 py-2 border border-gray-200 rounded-lg text-sm bg-gray-50 focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>

                <!-- Status Filter -->
                <div class="w-full md:w-auto">
                    <label class="block text-xs font-bold text-gray-500 uppercase mb-1">Status</label>
                    <select name="status"
                        class="w-full md:w-40 px-3 py-2 border border-gray-200 rounded-lg text-sm bg-gray-50 focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option value="all">All Statuses</option>
                        @foreach(['new', 'contacted', 'matured', 'proposal', 'won', 'lost', 'disqualified'] as $st)
                            <option value="{{ $st }}" {{ request('status') == $st ? 'selected' : '' }}>{{ ucfirst($st) }}</option>
                        @endforeach
                    </select>
                </div>

                <!-- Date Range -->
                <div class="w-full md:w-auto">
                    <label class="block text-xs font-bold text-gray-500 uppercase mb-1">Date Created (From)</label>
                    <input type="date" name="date_from" value="{{ request('date_from') }}"
                        class="w-full px-3 py-2 border border-gray-200 rounded-lg text-sm bg-gray-50 focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>
                <div class="w-full md:w-auto">
                    <label class="block text-xs font-bold text-gray-500 uppercase mb-1">Date Created (To)</label>
                    <input type="date" name="date_to" value="{{ request('date_to') }}"
                        class="w-full px-3 py-2 border border-gray-200 rounded-lg text-sm bg-gray-50 focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>

                <!-- User Filter -->
                <div class="w-full md:w-auto">
                    <label class="block text-xs font-bold text-gray-500 uppercase mb-1">Assigned User</label>
                    <select name="assigned_to"
                        class="w-full md:w-48 px-3 py-2 border border-gray-200 rounded-lg text-sm bg-gray-50 focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option value="">All Users</option>
                        @foreach($users as $user)
                            <option value="{{ $user->id }}" {{ request('assigned_to') == $user->id ? 'selected' : '' }}>
                                {{ $user->name }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <!-- Buttons -->
                <div class="flex gap-2">
                    <button type="submit"
                        class="px-4 py-2 bg-slate-900 text-white font-bold rounded-lg text-sm hover:bg-slate-800 transition-colors">
                        Filter
                    </button>
                    <a href="{{ route('admin.leads.index') }}"
                        class="px-4 py-2 bg-gray-100 text-gray-600 font-bold rounded-lg text-sm hover:bg-gray-200 transition-colors">
                        Reset
                    </a>
                </div>
            </form>
        </div>

        <!-- Leads Table -->
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
            <table class="w-full text-left border-collapse">
                <thead>
                    <tr
                        class="bg-slate-50 border-b border-gray-100 text-xs uppercase text-gray-400 font-bold tracking-wider">
                        <th class="px-6 py-4">Lead Name</th>
                        <th class="px-6 py-4">Company</th>
                        <th class="px-6 py-4">Created Date</th>
                        <th class="px-6 py-4">Status</th>
                        <th class="px-6 py-4">Assigned To</th>
                        <th class="px-6 py-4 text-right">Action</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-50">
                    @forelse($leads as $lead)
                        <tr class="hover:bg-gray-50 transition-colors group">
                            <td class="px-6 py-4">
                                <div class="font-bold text-gray-900">{{ $lead->name }}</div>
                                <div class="text-xs text-gray-500">{{ $lead->job_title }}</div>
                            </td>
                            <td class="px-6 py-4">
                                <div class="font-bold text-gray-800">{{ $lead->company_name ?? '-' }}</div>
                                <div class="text-xs text-gray-500">{{ $lead->site_location }}</div>
                            </td>
                            <td class="px-6 py-4 text-sm text-gray-600">
                                {{ $lead->created_at->format('M d, Y') }}
                            </td>
                            <td class="px-6 py-4">
                                @php
                                    $colors = [
                                        'new' => 'bg-blue-100 text-blue-700',
                                        'contacted' => 'bg-amber-100 text-amber-700',
                                        'matured' => 'bg-purple-100 text-purple-700',
                                        'proposal' => 'bg-indigo-100 text-indigo-700',
                                        'won' => 'bg-emerald-100 text-emerald-700',
                                        'lost' => 'bg-gray-100 text-gray-500',
                                        'disqualified' => 'bg-red-100 text-red-700',
                                    ];
                                @endphp
                                <span
                                    class="px-3 py-1 rounded-full text-[10px] font-black uppercase tracking-wider {{ $colors[$lead->status] ?? 'bg-gray-100 text-gray-600' }}">
                                    {{ ucfirst($lead->status) }}
                                </span>
                            </td>
                            <td class="px-6 py-4">
                                @if($lead->assignee)
                                    <div class="flex items-center gap-2">
                                        <div
                                            class="w-6 h-6 rounded-full bg-slate-200 flex items-center justify-center text-[10px] font-bold text-slate-600">
                                            {{ substr($lead->assignee->name, 0, 1) }}
                                        </div>
                                        <span class="text-xs font-medium text-gray-600">{{ $lead->assignee->name }}</span>
                                    </div>
                                @else
                                    <span class="text-xs text-gray-400">Unassigned</span>
                                @endif
                            </td>
                            <td class="px-6 py-4 text-right">
                                <a href="{{ route('admin.leads.show', $lead) }}"
                                    class="text-blue-500 hover:text-blue-700 font-bold text-xs">View</a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="px-6 py-12 text-center text-gray-500">
                                No leads found matching your criteria.
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div class="mt-4">
            {{ $leads->withQueryString()->links() }}
        </div>
    </div>
@endsection