@extends('layouts.admin')

@section('title', 'Add Job Role')
@section('page_title', 'Add Job Role')

@section('content')
<div class="mb-6 flex items-center justify-between font-inter">
    <div>
        <h1 class="text-2xl font-bold text-gray-900">Add New Job Role</h1>
        <p class="text-gray-500 text-sm">Create a new job role record.</p>
    </div>
    <a href="{{ route('admin.job-roles.index') }}" class="inline-flex items-center gap-2 bg-gray-100 text-gray-700 px-4 py-2.5 rounded-xl font-semibold hover:bg-gray-200 transition-all">
        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path></svg>
        Back to List
    </a>
</div>

<div class="max-w-4xl">
    <form action="{{ route('admin.job-roles.store') }}" method="POST" class="bg-white rounded-2xl border border-gray-100 shadow-sm overflow-hidden transition-all">
        @csrf
        
        <div class="p-8 space-y-6">
            <div class="space-y-2">
                <label for="name" class="text-sm font-bold text-gray-700 uppercase tracking-tight">Job Role <span class="text-red-500">*</span></label>
                <input type="text" name="name" id="name" value="{{ old('name') }}" required
                    class="w-full px-4 py-3 bg-gray-50/50 border border-gray-200 rounded-xl focus:ring-4 focus:ring-blue-100 focus:border-blue-500 focus:bg-white transition-all outline-none @error('name') border-red-500 @enderror">
                @error('name')
                    <p class="text-red-500 text-xs font-medium">{{ $message }}</p>
                @enderror
            </div>
        </div>

        <div class="p-8 bg-gray-50/50 border-t border-gray-100 flex items-center justify-end">
            <button type="submit" class="bg-blue-600 text-white px-8 py-3 rounded-xl font-bold hover:bg-blue-700 transition-all shadow-lg shadow-blue-200">
                Create Job Role
            </button>
        </div>
    </form>
</div>
@endsection
