@extends('layouts.admin')

@section('content')
    <div class="space-y-6"
        x-data="{ 
            activeTab: '{{ session('show_child_form') ? 'children' : 'parents' }}', 
            showAddParentForm: {{ session('show_parent_form') ? 'true' : 'false' }}, 
            showImportParentsForm: false, 
            showAddChildForm: {{ session('show_child_form') ? 'true' : 'false' }}, 
            showImportChildrenForm: false, 
            isLoading: false 
        }">
        <!-- Page Header -->
        <div class="flex flex-col md:flex-row md:items-start md:justify-between gap-4">
            <div class="flex-1 min-w-0">
                <h1 class="text-2xl font-bold text-gray-900 tracking-tight">Incident Categories</h1>
                <p class="text-sm text-gray-500 mt-1">Manage master data for incident classification</p>
            </div>
            <div class="flex gap-2">
                <!-- Action Buttons based on active tab -->
                <button type="button" x-show="activeTab === 'parents'"
                    @click="showAddParentForm = !showAddParentForm; showImportParentsForm = false"
                    class="inline-flex items-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white text-sm font-medium rounded-xl transition-all shadow-sm shadow-blue-200">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                    </svg>
                    <span x-text="showAddParentForm ? 'Close Form' : 'Add Parent Category'"></span>
                </button>
                <button type="button" x-show="activeTab === 'parents'"
                    @click="showImportParentsForm = !showImportParentsForm; showAddParentForm = false"
                    class="inline-flex items-center px-4 py-2 bg-white border border-gray-200 text-gray-700 hover:bg-gray-50 text-sm font-medium rounded-xl transition-all shadow-sm">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12">
                        </path>
                    </svg>
                    <span x-text="showImportParentsForm ? 'Close Import' : 'Import Parents'"></span>
                </button>

                <button type="button" x-show="activeTab === 'children'"
                    @click="showAddChildForm = !showAddChildForm; showImportChildrenForm = false"
                    class="inline-flex items-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white text-sm font-medium rounded-xl transition-all shadow-sm shadow-blue-200">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                    </svg>
                    <span x-text="showAddChildForm ? 'Close Form' : 'Add Incident Category'"></span>
                </button>
                <button type="button" x-show="activeTab === 'children'"
                    @click="showImportChildrenForm = !showImportChildrenForm; showAddChildForm = false"
                    class="inline-flex items-center px-4 py-2 bg-white border border-gray-200 text-gray-700 hover:bg-gray-50 text-sm font-medium rounded-xl transition-all shadow-sm">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12">
                        </path>
                    </svg>
                    <span x-text="showImportChildrenForm ? 'Close Import' : 'Import Categories'"></span>
                </button>
            </div>
        </div>

        <!-- Tabs -->
        <div class="border-b border-gray-200">
            <nav class="-mb-px flex space-x-8" aria-label="Tabs">
                <button @click="activeTab = 'parents'; showAddChildForm = false; showImportChildrenForm = false"
                    :class="activeTab === 'parents' ? 'border-blue-500 text-blue-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'"
                    class="whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm transition-colors">
                    Parent Categories
                </button>
                <button @click="activeTab = 'children'; showAddParentForm = false; showImportParentsForm = false"
                    :class="activeTab === 'children' ? 'border-blue-500 text-blue-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'"
                    class="whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm transition-colors">
                    Incident Categories
                </button>
            </nav>
        </div>

        <!-- Flash Messages -->
        @if(session('success'))
            <div class="bg-green-50 border border-green-100 text-green-700 px-6 py-4 rounded-2xl flex items-center shadow-sm" role="alert">
                <svg class="w-5 h-5 mr-3 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                <span class="text-sm font-bold">{{ session('success') }}</span>
            </div>
        @endif
        @if(session('error'))
            <div class="bg-red-50 border border-red-100 text-red-700 px-6 py-4 rounded-2xl flex items-center shadow-sm" role="alert">
                <svg class="w-5 h-5 mr-3 text-red-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                <span class="text-sm font-bold">{{ session('error') }}</span>
            </div>
        @endif

        <!-- Add Parent Form -->
        <div x-show="showAddParentForm" x-collapse
            class="bg-white rounded-2xl shadow-sm border border-gray-200 p-8 mb-6 overflow-hidden">
            <div class="flex items-center justify-between mb-6">
                <h2 class="text-xl font-bold text-gray-900">Add Parent Category</h2>
                <button @click="showAddParentForm = false" class="text-gray-400 hover:text-gray-600">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg>
                </button>
            </div>
            <form action="{{ route('admin.incident-categories.parents.store') }}" method="POST">
                @csrf
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="space-y-1.5">
                        <label class="text-xs font-bold text-gray-500 uppercase tracking-wider">Code</label>
                        <input type="text" name="code" required placeholder="e.g. MSEC"
                            class="block w-full bg-gray-50 border-gray-200 rounded-xl px-4 py-3 text-sm focus:bg-white focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all outline-none border">
                    </div>
                    <div class="space-y-1.5">
                        <label class="text-xs font-bold text-gray-500 uppercase tracking-wider">Description</label>
                        <input type="text" name="description" placeholder="e.g. Maintenance & Security"
                            class="block w-full bg-gray-50 border-gray-200 rounded-xl px-4 py-3 text-sm focus:bg-white focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all outline-none border">
                    </div>
                </div>
                <div class="mt-8 flex items-center justify-end gap-3 pt-6 border-t border-gray-100">
                    <button type="submit" name="add_another" value="1"
                        class="px-6 py-2.5 bg-white border border-gray-200 text-gray-700 text-sm font-semibold rounded-xl hover:bg-gray-50 hover:border-gray-300 transition-all shadow-sm">
                        Save & Add Another
                    </button>
                    <button type="submit"
                        class="px-6 py-2.5 bg-blue-600 text-white text-sm font-semibold rounded-xl hover:bg-blue-700 transition-all shadow-md shadow-blue-200">
                        Save Category
                    </button>
                </div>
            </form>
        </div>

        <!-- Import Parents Form -->
        <div x-show="showImportParentsForm" x-collapse class="bg-white rounded-2xl shadow-sm border border-gray-200 p-8 mb-6 relative overflow-hidden">
            <!-- Loader Overlay -->
            <div x-show="isLoading" class="absolute inset-0 bg-white/70 flex items-center justify-center z-10">
                <div class="flex flex-col items-center">
                    <div class="w-12 h-12 border-4 border-blue-600 border-t-transparent rounded-full animate-spin mb-4"></div>
                    <span class="text-sm font-bold text-gray-700">Processing Import...</span>
                </div>
            </div>

            <h2 class="text-xl font-bold text-gray-900 mb-6">Import Parent Categories</h2>
            <form action="{{ route('admin.incident-categories.parents.import') }}" method="POST"
                enctype="multipart/form-data" @submit="isLoading = true">
                @csrf
                <div class="space-y-4">
                    <div class="p-8 border-2 border-dashed border-gray-200 rounded-2xl bg-gray-50 hover:bg-gray-100 transition-all text-center group">
                        <input type="file" name="file" id="parent_file" required accept=".csv,.xlsx,.xls" class="hidden">
                        <label for="parent_file" class="cursor-pointer">
                            <svg class="w-10 h-10 text-gray-400 mx-auto mb-3 group-hover:text-blue-500 transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"></path></svg>
                            <span class="block text-sm font-bold text-gray-700 mb-1">Click to upload file</span>
                            <span class="block text-xs text-gray-400">Excel or CSV files only</span>
                        </label>
                    </div>
                    <div class="flex items-start gap-2 text-xs text-blue-600 bg-blue-50 p-3 rounded-lg border border-blue-100">
                        <svg class="w-4 h-4 shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                        <p>Required columns: <strong>code, description, status</strong></p>
                    </div>
                </div>
                <div class="mt-8 flex justify-end">
                    <button type="submit"
                        class="px-8 py-2.5 bg-blue-600 text-white text-sm font-semibold rounded-xl hover:bg-blue-700 transition-all shadow-md shadow-blue-200">
                        Start Import
                    </button>
                </div>
            </form>
        </div>

        <!-- Add Child Form -->
        <div x-show="showAddChildForm" x-collapse
            class="bg-white rounded-2xl shadow-sm border border-gray-200 p-8 mb-6 overflow-hidden">
            <div class="flex items-center justify-between mb-6">
                <h2 class="text-xl font-bold text-gray-900">Add Incident Category</h2>
                <button @click="showAddChildForm = false" class="text-gray-400 hover:text-gray-600">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg>
                </button>
            </div>
            <form action="{{ route('admin.incident-categories.children.store') }}" method="POST">
                @csrf
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="space-y-1.5">
                        <label class="text-xs font-bold text-gray-500 uppercase tracking-wider">Parent Category</label>
                        <select name="incident_parent_category_id" required
                            class="block w-full bg-gray-50 border-gray-200 rounded-xl px-4 py-3 text-sm focus:bg-white focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all outline-none border appearance-none">
                            <option value="">Select Parent...</option>
                            @foreach($parents as $p)
                                <option value="{{ $p->id }}">{{ $p->code }} - {{Str::limit($p->description, 40)}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="space-y-1.5">
                        <label class="text-xs font-bold text-gray-500 uppercase tracking-wider">Code (Optional)</label>
                        <input type="text" name="code" placeholder="e.g. LIGHT_OUT"
                            class="block w-full bg-gray-50 border-gray-200 rounded-xl px-4 py-3 text-sm focus:bg-white focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all outline-none border">
                    </div>
                    <div class="md:col-span-2 space-y-1.5">
                        <label class="text-xs font-bold text-gray-500 uppercase tracking-wider">Description</label>
                        <input type="text" name="description" required placeholder="Describe the incident type..."
                            class="block w-full bg-gray-50 border-gray-200 rounded-xl px-4 py-3 text-sm focus:bg-white focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all outline-none border">
                    </div>
                    <div class="space-y-1.5">
                        <label class="text-xs font-bold text-gray-500 uppercase tracking-wider">Priority Level</label>
                        <div class="flex gap-4">
                            @foreach([1 => 'High', 2 => '2', 3 => '3', 4 => '4', 5 => 'Low'] as $val => $label)
                                <label class="flex-1">
                                    <input type="radio" name="priority_level" value="{{ $val }}" {{ $val == 5 ? 'checked' : '' }} class="hidden peer">
                                    <div class="text-center py-2 px-3 bg-gray-50 border border-gray-200 rounded-xl cursor-pointer peer-checked:bg-blue-600 peer-checked:text-white peer-checked:border-blue-600 transition-all text-xs font-bold">
                                        {{ $label }}
                                    </div>
                                </label>
                            @endforeach
                        </div>
                    </div>
                </div>
                <div class="mt-8 flex items-center justify-end gap-3 pt-6 border-t border-gray-100">
                    <button type="submit" name="add_another" value="1"
                        class="px-6 py-2.5 bg-white border border-gray-200 text-gray-700 text-sm font-semibold rounded-xl hover:bg-gray-50 hover:border-gray-300 transition-all shadow-sm">
                        Save & Add Another
                    </button>
                    <button type="submit"
                        class="px-6 py-2.5 bg-blue-600 text-white text-sm font-semibold rounded-xl hover:bg-blue-700 transition-all shadow-md shadow-blue-200">
                        Save Incident Category
                    </button>
                </div>
            </form>
        </div>

        <!-- Import Children Form -->
        <div x-show="showImportChildrenForm" x-collapse class="bg-white rounded-2xl shadow-sm border border-gray-200 p-8 mb-6 relative overflow-hidden">
            <!-- Loader Overlay -->
            <div x-show="isLoading" class="absolute inset-0 bg-white/70 flex items-center justify-center z-10">
                <div class="flex flex-col items-center">
                    <div class="w-12 h-12 border-4 border-blue-600 border-t-transparent rounded-full animate-spin mb-4"></div>
                    <span class="text-sm font-bold text-gray-700">Processing Import...</span>
                </div>
            </div>

            <h2 class="text-xl font-bold text-gray-900 mb-6">Import Incident Categories</h2>
            <form action="{{ route('admin.incident-categories.children.import') }}" method="POST"
                enctype="multipart/form-data" @submit="isLoading = true">
                @csrf
                <div class="space-y-4">
                    <div class="p-8 border-2 border-dashed border-gray-200 rounded-2xl bg-gray-50 hover:bg-gray-100 transition-all text-center group">
                        <input type="file" name="file" id="child_file" required accept=".csv,.xlsx,.xls" class="hidden">
                        <label for="child_file" class="cursor-pointer">
                            <svg class="w-10 h-10 text-gray-400 mx-auto mb-3 group-hover:text-blue-500 transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"></path></svg>
                            <span class="block text-sm font-bold text-gray-700 mb-1">Click to upload file</span>
                            <span class="block text-xs text-gray-400">Excel or CSV files only</span>
                        </label>
                    </div>
                    <div class="flex items-start gap-2 text-xs text-blue-600 bg-blue-50 p-3 rounded-lg border border-blue-100">
                        <svg class="w-4 h-4 shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                        <p>Required columns: <strong>parent_code, description, priority_level, status, code (optional)</strong></p>
                    </div>
                </div>
                <div class="mt-8 flex justify-end">
                    <button type="submit"
                        class="px-8 py-2.5 bg-blue-600 text-white text-sm font-semibold rounded-xl hover:bg-blue-700 transition-all shadow-md shadow-blue-200">
                        Start Import
                    </button>
                </div>
            </form>
        </div>

        <!-- Parent Categories List -->
        <div x-show="activeTab === 'parents'" x-transition:enter="transition ease-out duration-300"
            x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100">
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
                <table class="min-w-full divide-y divide-gray-100">
                    <thead class="bg-gray-50/50">
                        <tr>
                            <th class="px-6 py-4 text-left text-xs font-bold text-gray-400 uppercase tracking-widest">Code</th>
                            <th class="px-6 py-4 text-left text-xs font-bold text-gray-400 uppercase tracking-widest">Description</th>
                            <th class="px-6 py-4 text-left text-xs font-bold text-gray-400 uppercase tracking-widest">Status</th>
                            <th class="px-6 py-4 text-right text-xs font-bold text-gray-400 uppercase tracking-widest">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @forelse($parents as $parent)
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">{{ $parent->code }}
                                </td>
                                <td class="px-6 py-4 text-sm text-gray-500">{{ $parent->description }}</td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span
                                        class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ $parent->status ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                        {{ $parent->status ? 'Active' : 'Inactive' }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                    <a href="#" class="text-blue-600 hover:text-blue-900 mr-3"
                                        onclick="event.preventDefault(); document.getElementById('edit-parent-form-{{ $parent->id }}').classList.toggle('hidden');">Edit</a>
                                </td>
                            </tr>
                            <tr id="edit-parent-form-{{ $parent->id }}" class="hidden bg-gray-50">
                                <td colspan="4" class="px-6 py-4">
                                    <form action="{{ route('admin.incident-categories.parents.update', $parent->id) }}"
                                        method="POST">
                                        @csrf
                                        @method('PUT')
                                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 items-end">
                                            <div class="space-y-1">
                                                <label class="text-[10px] font-bold text-gray-400 uppercase tracking-widest">Code</label>
                                                <input type="text" name="code" value="{{ $parent->code }}" required
                                                    class="block w-full bg-white border-gray-200 rounded-lg px-3 py-2 text-sm focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all outline-none border">
                                            </div>
                                            <div class="space-y-1">
                                                <label class="text-[10px] font-bold text-gray-400 uppercase tracking-widest">Description</label>
                                                <input type="text" name="description" value="{{ $parent->description }}"
                                                    class="block w-full bg-white border-gray-200 rounded-lg px-3 py-2 text-sm focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all outline-none border">
                                            </div>
                                            <div class="flex gap-2 pb-1">
                                                <button type="submit"
                                                    class="px-4 py-2 bg-blue-600 text-white text-xs font-bold rounded-lg shadow-sm hover:bg-blue-700 transition-all">Update</button>
                                                <button type="button"
                                                    onclick="document.getElementById('edit-parent-form-{{ $parent->id }}').classList.add('hidden')"
                                                    class="px-4 py-2 bg-white border border-gray-200 text-gray-700 text-xs font-bold rounded-lg shadow-sm hover:bg-gray-50 transition-all">Cancel</button>
                                            </div>
                                        </div>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="4" class="px-6 py-4 whitespace-nowrap text-center text-sm text-gray-500">No parent
                                    categories found.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Children Categories List -->
        <div x-show="activeTab === 'children'" style="display: none;" x-transition:enter="transition ease-out duration-300"
            x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100">
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
                <table class="min-w-full divide-y divide-gray-100">
                    <thead class="bg-gray-50/50">
                        <tr>
                            <th class="px-6 py-4 text-left text-xs font-bold text-gray-400 uppercase tracking-widest">Parent Category</th>
                            <th class="px-6 py-4 text-left text-xs font-bold text-gray-400 uppercase tracking-widest">Code</th>
                            <th class="px-6 py-4 text-left text-xs font-bold text-gray-400 uppercase tracking-widest">Description</th>
                            <th class="px-6 py-4 text-left text-xs font-bold text-gray-400 uppercase tracking-widest">Priority</th>
                            <th class="px-6 py-4 text-left text-xs font-bold text-gray-400 uppercase tracking-widest">Status</th>
                            <th class="px-6 py-4 text-right text-xs font-bold text-gray-400 uppercase tracking-widest">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @php
                            $hasChildren = false;
                        @endphp
                        @foreach($parents as $parent)
                            @foreach($parent->incident_categories as $child)
                                @php $hasChildren = true; @endphp
                                <tr>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                        <span class="font-bold text-gray-900">{{ $parent->code }}</span>
                                        <span class="text-xs block">{{ $parent->description }}</span>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $child->code ?? '-' }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                                        {{ $child->description }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                        <span
                                            class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-blue-100 text-blue-800">
                                            {{ $child->priority_level }}
                                        </span>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <span
                                            class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ $child->status ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                            {{ $child->status ? 'Active' : 'Inactive' }}
                                        </span>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                        <a href="#" class="text-blue-600 hover:text-blue-900 mr-3"
                                            onclick="event.preventDefault(); document.getElementById('edit-child-form-{{ $child->id }}').classList.toggle('hidden');">Edit</a>
                                    </td>
                                </tr>
                                <tr id="edit-child-form-{{ $child->id }}" class="hidden bg-gray-50">
                                    <td colspan="6" class="px-6 py-4">
                                        <form action="{{ route('admin.incident-categories.children.update', $child->id) }}"
                                            method="POST">
                                            @csrf
                                            @method('PUT')
                                            <div class="grid grid-cols-1 md:grid-cols-5 gap-4 items-end">
                                                <div class="md:col-span-1 space-y-1">
                                                    <label class="text-[10px] font-bold text-gray-400 uppercase tracking-widest">Parent</label>
                                                    <select name="incident_parent_category_id"
                                                        class="block w-full bg-white border-gray-200 rounded-lg px-3 py-2 text-sm focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all outline-none border appearance-none">
                                                        @foreach($parents as $p)
                                                            <option value="{{ $p->id }}" {{ $child->incident_parent_category_id == $p->id ? 'selected' : '' }}>{{ $p->code }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <div class="md:col-span-1 space-y-1">
                                                    <label class="text-[10px] font-bold text-gray-400 uppercase tracking-widest">Code</label>
                                                    <input type="text" name="code" value="{{ $child->code }}"
                                                        class="block w-full bg-white border-gray-200 rounded-lg px-3 py-2 text-sm focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all outline-none border">
                                                </div>
                                                <div class="md:col-span-1 space-y-1">
                                                    <label class="text-[10px] font-bold text-gray-400 uppercase tracking-widest">Description</label>
                                                    <input type="text" name="description" value="{{ $child->description }}" required
                                                        class="block w-full bg-white border-gray-200 rounded-lg px-3 py-2 text-sm focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all outline-none border">
                                                </div>
                                                <div class="md:col-span-1 space-y-1">
                                                    <label class="text-[10px] font-bold text-gray-400 uppercase tracking-widest">Priority</label>
                                                    <select name="priority_level" required
                                                        class="block w-full bg-white border-gray-200 rounded-lg px-3 py-2 text-sm focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all outline-none border appearance-none">
                                                        @for ($i = 1; $i <= 5; $i++)
                                                            <option value="{{ $i }}" {{ $child->priority_level == $i ? 'selected' : '' }}>
                                                                {{ $i }}
                                                            </option>
                                                        @endfor
                                                    </select>
                                                </div>
                                                <div class="flex gap-2 pb-1">
                                                    <button type="submit"
                                                        class="px-4 py-2 bg-blue-600 text-white text-xs font-bold rounded-lg shadow-sm hover:bg-blue-700 transition-all">Update</button>
                                                    <button type="button"
                                                        onclick="document.getElementById('edit-child-form-{{ $child->id }}').classList.add('hidden')"
                                                        class="px-4 py-2 bg-white border border-gray-200 text-gray-700 text-xs font-bold rounded-lg shadow-sm hover:bg-gray-50 transition-all">Cancel</button>
                                                </div>
                                            </div>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        @endforeach
                        @if(!$hasChildren)
                            <tr>
                                <td colspan="6" class="px-6 py-4 whitespace-nowrap text-center text-sm text-gray-500">No
                                    incident categories found.</td>
                            </tr>
                        @endif
                    </tbody>
                </table>
            </div>
        </div>

    </div>
@endsection