@extends('layouts.admin')

@section('title', 'ID Settings')
@section('page_title', 'ID Settings')

@section('content')
    <div class="mb-6 flex flex-col md:flex-row md:items-center justify-between gap-4">
        <div>
            <h1 class="text-2xl font-bold text-gray-800">ID Settings</h1>
            <p class="text-sm text-gray-500 mt-1">Configure ID prefixes and starting numbers for each company.</p>
        </div>
        <div class="flex flex-wrap items-center gap-3">
            <a href="{{ route('admin.id-settings.create') }}"
                class="inline-flex items-center gap-2 bg-blue-600 text-white px-4 py-2 rounded-md font-bold text-sm hover:bg-blue-700 transition-all shadow-sm">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6">
                    </path>
                </svg>
                Add ID Setting
            </a>
        </div>
    </div>

    @if(session('success'))
        <div class="mb-6 p-4 bg-green-50 border border-green-100 text-green-700 rounded-lg flex items-center gap-3">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
            </svg>
            {{ session('success') }}
        </div>
    @endif

    <div class="bg-white rounded-lg border border-gray-100 shadow-sm overflow-hidden">
        <table class="w-full text-left border-collapse">
            <thead>
                <tr class="bg-gray-50/50 border-b border-gray-100">
                    <th class="px-6 py-4 text-xs font-semibold text-gray-500 uppercase tracking-wider">Company</th>
                    <th class="px-6 py-4 text-xs font-semibold text-gray-500 uppercase tracking-wider">Emp ID</th>
                    <th class="px-6 py-4 text-xs font-semibold text-gray-500 uppercase tracking-wider">Site ID</th>
                    <th class="px-6 py-4 text-xs font-semibold text-gray-500 uppercase tracking-wider">Route ID</th>
                    <th class="px-6 py-4 text-xs font-semibold text-gray-500 uppercase tracking-wider">Duty ID</th>
                    <th class="px-6 py-4 text-xs font-semibold text-gray-500 uppercase tracking-wider">Incident ID</th>
                    <th class="px-6 py-4 text-xs font-semibold text-gray-500 uppercase tracking-wider">Patroller ID</th>
                    <th class="px-6 py-4 text-xs font-semibold text-gray-500 uppercase tracking-wider text-right">Actions
                    </th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-50">
                @forelse($idSettings as $setting)
                    <tr class="hover:bg-gray-50/50 transition-colors">
                        <td class="px-6 py-4">
                            <div class="text-sm font-bold text-gray-800">{{ $setting->company->name }}</div>
                        </td>
                        <td class="px-6 py-4 text-sm text-gray-600">
                            <span
                                class="font-bold text-blue-600">{{ $setting->emp_prefix }}</span>{{ $setting->emp_next_number }}
                        </td>
                        <td class="px-6 py-4 text-sm text-gray-600">
                            <span
                                class="font-bold text-blue-600">{{ $setting->site_prefix }}</span>{{ $setting->site_next_number }}
                        </td>
                        <td class="px-6 py-4 text-sm text-gray-600">
                            <span
                                class="font-bold text-blue-600">{{ $setting->route_prefix }}</span>{{ $setting->route_next_number }}
                        </td>
                        <td class="px-6 py-4 text-sm text-gray-600">
                            <span
                                class="font-bold text-blue-600">{{ $setting->duty_prefix }}</span>{{ $setting->duty_next_number }}
                        </td>
                        <td class="px-6 py-4 text-sm text-gray-600">
                            <span
                                class="font-bold text-blue-600">{{ $setting->incident_prefix }}</span>{{ $setting->incident_next_number }}
                        </td>
                        <td class="px-6 py-4 text-sm text-gray-600">
                            <span
                                class="font-bold text-blue-600">{{ $setting->patroller_prefix ?? 'P' }}</span>{{ $setting->patroller_next_number ?? 1 }}
                        </td>
                        <td class="px-6 py-4 text-right">
                            <div class="flex items-center justify-end gap-2">
                                <a href="{{ route('admin.id-settings.edit', $setting) }}"
                                    class="p-2 text-gray-400 hover:text-blue-600 hover:bg-blue-50 rounded-md transition-all border border-transparent hover:border-blue-100">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z">
                                        </path>
                                    </svg>
                                </a>
                                <button type="button"
                                    onclick="openDeleteModal('{{ route('admin.id-settings.destroy', $setting) }}', 'ID Setting for {{ $setting->company->name }}')"
                                    class="p-2 text-gray-400 hover:text-red-600 hover:bg-red-50 rounded-md transition-all border border-transparent hover:border-red-100"
                                    title="Delete">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16">
                                        </path>
                                    </svg>
                                </button>
                            </div>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="8" class="px-6 py-12 text-center text-gray-500 text-sm">
                            No ID settings found. Click "Add ID Setting" to create one.
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
@endsection