@extends('layouts.admin')

@section('title', 'Employee Details')

@section('content')
    <div class="max-w-7xl mx-auto"
        x-data="{ activeTab: new URLSearchParams(window.location.search).get('tab') || 'overview' }">

        <!-- Header Section (Slate 900) -->
        <div class="bg-slate-900 text-white px-8 pt-10 pb-0 rounded-t-3xl mb-0 shadow-xl relative overflow-hidden">
            <!-- Subtle background decorative element -->
            <div class="absolute -right-20 -top-20 w-64 h-64 bg-blue-500/10 rounded-full blur-3xl"></div>

            <div class="flex flex-col md:flex-row md:items-center gap-6 mb-8 relative z-10">
                <div class="relative group">
                    <div
                        class="w-20 h-20 rounded-2xl bg-gradient-to-br from-blue-400 to-blue-600 flex items-center justify-center text-3xl font-bold border-4 border-slate-800 shadow-2xl overflow-hidden shadow-blue-500/20">
                        @if($employee->profile_picture)
                            <img src="{{ asset('storage/' . $employee->profile_picture) }}" class="w-full h-full object-cover">
                        @else
                            <span
                                class="text-white">{{ strtoupper(substr($employee->first_name, 0, 1)) }}{{ strtoupper(substr($employee->last_name, 0, 1)) }}</span>
                        @endif
                    </div>
                </div>
                <div>
                    <div class="flex items-center gap-3">
                        <h1 class="text-3xl font-extrabold tracking-tight">{{ $employee->first_name }}
                            {{ $employee->last_name }}
                        </h1>
                        <span
                            class="px-3 py-1 bg-blue-500/20 text-blue-300 text-[10px] font-bold uppercase rounded-full border border-blue-500/30">Admin
                            View</span>
                    </div>
                    <div class="flex flex-wrap items-center gap-4 mt-2 text-sm text-slate-400 font-medium">
                        <span class="flex items-center gap-1.5">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z">
                                </path>
                            </svg>
                            {{ $employee->phone_number }}
                        </span>
                        <span class="flex items-center gap-1.5">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                            </svg>
                            ID: {{ $employee->employee_id }}
                        </span>
                        <span class="flex items-center gap-1.5">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M21 13.255A23.931 23.931 0 0112 15c-3.183 0-6.22-.62-9-1.745M16 6V4a2 2 0 00-2-2h-4a2 2 0 00-2 2v2m4 6h.01M5 20h14a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z">
                                </path>
                            </svg>
                            {{ $employee->jobRole->name ?? 'No Role' }}
                        </span>
                    </div>
                </div>

                <div class="md:ml-auto flex items-center gap-2">
                    <a href="{{ route('admin.employees.index') }}"
                        class="px-5 py-2.5 bg-slate-800 text-white text-xs font-bold rounded-xl hover:bg-slate-700 transition-all uppercase tracking-wider flex items-center gap-2">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M10 19l-7-7m0 0l7-7m-7 7h18" />
                        </svg>
                        Back to List
                    </a>
                </div>
            </div>

            <!-- Primary Tabs -->
            <div class="flex items-center gap-6 text-sm font-bold relative z-10 overflow-x-auto no-scrollbar">
                <a href="#" @click.prevent="activeTab = 'overview'"
                    :class="activeTab === 'overview' ? 'border-white text-white' : 'border-transparent text-slate-400 hover:text-white'"
                    class="pb-4 border-b-4 transition-all">Overview</a>

                <a href="#" @click.prevent="activeTab = 'documents'"
                    :class="activeTab === 'documents' ? 'border-white text-white' : 'border-transparent text-slate-400 hover:text-white'"
                    class="pb-4 border-b-4 transition-all">Documents</a>

                <a href="#" @click.prevent="activeTab = 'banned'"
                    :class="activeTab === 'banned' ? 'border-white text-white' : 'border-transparent text-slate-400 hover:text-white'"
                    class="pb-4 border-b-4 transition-all">Banned Sites</a>

                <a href="#" @click.prevent="activeTab = 'uniforms'"
                    :class="activeTab === 'uniforms' ? 'border-white text-white' : 'border-transparent text-slate-400 hover:text-white'"
                    class="pb-4 border-b-4 transition-all">Uniforms</a>

                <a href="#" @click.prevent="activeTab = 'availability'"
                    :class="activeTab === 'availability' ? 'border-white text-white' : 'border-transparent text-slate-400 hover:text-white'"
                    class="pb-4 border-b-4 transition-all">Availability</a>
            </div>
        </div>

        <!-- Actions Bar (White) -->
        <div
            class="bg-white border-b border-gray-100 px-8 py-3 flex items-center gap-4 text-xs font-bold text-slate-500 shadow-sm mb-0">
            <div class="flex items-center gap-6">
                <span class="flex items-center gap-2">
                    <span
                        class="w-2 h-2 rounded-full {{ $employee->active ? 'bg-green-500 shadow-[0_0_8px_rgba(34,197,94,0.5)]' : 'bg-red-500 shadow-[0_0_8px_rgba(239,68,68,0.5)]' }}"></span>
                    {{ $employee->active ? 'Active Status' : 'Inactive Status' }}
                </span>
                <span class="h-4 w-[1px] bg-gray-100"></span>
                <span class="uppercase tracking-widest text-[10px]">Company: {{ $employee->company->name ?? 'N/A' }}</span>
                <span class="h-4 w-[1px] bg-gray-100"></span>
                <span class="uppercase tracking-widest text-[10px]">Employee ID: {{ $employee->employee_id }}</span>
            </div>
        </div>

        <!-- Main Content -->
        <div class="flex-1 p-6">
            <div x-show="activeTab === 'overview'" class="space-y-6" x-cloak>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- General Info (Full Width) -->
                    <div class="md:col-span-2 bg-white rounded-3xl border border-gray-100 shadow-xl p-8">
                        <div class="flex flex-col md:flex-row gap-8 items-start mb-8 border-b border-gray-50 pb-8">
                            <!-- Avatar -->
                            <div
                                class="w-28 h-28 rounded-3xl bg-gradient-to-br from-blue-50 to-blue-100 border-2 border-white shadow-lg flex items-center justify-center text-blue-600 text-4xl font-extrabold shadow-blue-100 flex-shrink-0 overflow-hidden">
                                @if($employee->profile_picture)
                                    <img src="{{ asset('storage/' . $employee->profile_picture) }}"
                                        class="w-full h-full object-cover">
                                @else
                                    {{ strtoupper(substr($employee->first_name, 0, 1)) }}{{ strtoupper(substr($employee->last_name, 0, 1)) }}
                                @endif
                            </div>
                            <!-- Basic Details & Contact -->
                            <div class="flex-1">
                                <h2 class="text-2xl font-black text-slate-900 tracking-tight">
                                    {{ $employee->first_name }} {{ $employee->last_name }}
                                </h2>
                                <p class="text-sm font-bold text-blue-600 uppercase tracking-widest mt-1">
                                    {{ $employee->jobRole->name ?? 'No Role Assigned' }}
                                </p>

                                <div class="grid grid-cols-1 sm:grid-cols-2 gap-4 mt-6">
                                    <div
                                        class="flex items-center gap-3 p-3 bg-slate-50 rounded-2xl border border-slate-100 shadow-sm">
                                        <div
                                            class="w-8 h-8 rounded-xl bg-white flex items-center justify-center text-slate-400 shadow-sm">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z">
                                                </path>
                                            </svg>
                                        </div>
                                        <span class="text-sm font-bold text-slate-600">{{ $employee->email }}</span>
                                    </div>
                                    <div
                                        class="flex items-center gap-3 p-3 bg-slate-50 rounded-2xl border border-slate-100 shadow-sm">
                                        <div
                                            class="w-8 h-8 rounded-xl bg-white flex items-center justify-center text-slate-400 shadow-sm">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z">
                                                </path>
                                            </svg>
                                        </div>
                                        <span class="text-sm font-bold text-slate-600">{{ $employee->phone_number }}</span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <h3 class="text-[10px] font-black text-slate-400 uppercase tracking-[.2em] mb-6">General
                            Information</h3>
                        <div class="grid grid-cols-2 md:grid-cols-4 gap-8 text-slate-900 font-bold">
                            <div><span
                                    class="block text-[10px] font-bold text-slate-400 uppercase tracking-widest mb-1">BirthDate</span>
                                <span class="text-sm">{{ $employee->dob }}</span>
                            </div>
                            <div><span
                                    class="block text-[10px] font-bold text-slate-400 uppercase tracking-widest mb-1">Gender</span>
                                <span class="text-sm">{{ ucfirst($employee->gender) }}</span>
                            </div>
                            <div><span
                                    class="block text-[10px] font-bold text-slate-400 uppercase tracking-widest mb-1">Status</span>
                                <span class="text-sm">{{ ucfirst($employee->marital_status) }}</span>
                            </div>
                            <div><span
                                    class="block text-[10px] font-bold text-slate-400 uppercase tracking-widest mb-1">Department</span>
                                <span class="text-sm">{{ $employee->department->name ?? 'N/A' }}</span>
                            </div>
                            <div><span
                                    class="block text-[10px] font-bold text-slate-400 uppercase tracking-widest mb-1">Total
                                    Hrs Worked</span>
                                @php
                                    $totalMinutes = $employee->schedules()
                                        ->wherePivotNotNull('actual_start_at')
                                        ->wherePivotNotNull('actual_end_at')
                                        ->get()
                                        ->sum(function ($job) {
                                            $start = \Carbon\Carbon::parse($job->pivot->actual_start_at);
                                            $end = \Carbon\Carbon::parse($job->pivot->actual_end_at);
                                            return $start->diffInMinutes($end);
                                        });
                                @endphp
                                <span class="text-sm">{{ round($totalMinutes / 60, 1) }}h</span>
                            </div>
                        </div>
                    </div>

                    <!-- Address Info -->
                    <div class="bg-white rounded-3xl border border-gray-100 shadow-xl p-8">
                        <h3
                            class="text-[10px] font-black text-slate-400 uppercase tracking-[.2em] mb-6 border-b border-slate-50 pb-4">
                            Address Information</h3>
                        <div class="space-y-6">
                            <div class="text-sm">
                                <span
                                    class="block text-slate-400 text-[10px] font-black uppercase tracking-widest mb-2">Permanent
                                    Address</span>
                                <span
                                    class="text-slate-700 font-bold leading-relaxed block bg-slate-50 p-4 rounded-2xl border border-slate-100">
                                    {{ $employee->permanent_address_line_1 }}<br>
                                    @if($employee->permanent_address_line_2){{ $employee->permanent_address_line_2 }}<br>@endif
                                    {{ $employee->permanent_city }}, {{ $employee->permanentState->name ?? '' }}
                                    {{ $employee->permanent_zip_code }}<br>
                                    {{ $employee->permanentCountry->name ?? '' }}
                                </span>
                            </div>
                            <div class="text-sm">
                                <span
                                    class="block text-slate-400 text-[10px] font-black uppercase tracking-widest mb-2">Corresponding
                                    Address</span>
                                <span
                                    class="text-slate-700 font-bold leading-relaxed block bg-slate-50 p-4 rounded-2xl border border-slate-100">
                                    {{ $employee->corresponding_address_line_1 ?: 'N/A' }}<br>
                                    @if($employee->corresponding_address_line_2){{ $employee->corresponding_address_line_2 }}<br>@endif
                                    @if($employee->corresponding_city)
                                        {{ $employee->corresponding_city }}, {{ $employee->correspondingState->name ?? '' }}
                                        {{ $employee->corresponding_zip_code }}<br>
                                        {{ $employee->correspondingCountry->name ?? '' }}
                                    @endif
                                </span>
                            </div>
                        </div>
                    </div>

                    <!-- Licence & Employment Info -->
                    <div class="bg-white rounded-3xl border border-gray-100 shadow-xl p-8">
                        <h3
                            class="text-[10px] font-black text-slate-400 uppercase tracking-[.2em] mb-6 border-b border-slate-50 pb-4">
                            Licence & Employment</h3>
                        <div class="grid grid-cols-1 gap-6 text-sm">
                            <div class="flex justify-between items-center bg-slate-50 p-3 rounded-xl">
                                <span class="text-slate-400 text-[10px] font-black uppercase">License Number</span>
                                <span class="text-slate-900 font-black">{{ $employee->license_number }}</span>
                            </div>
                            <div class="flex justify-between items-center bg-slate-50 p-3 rounded-xl">
                                <span class="text-slate-400 text-[10px] font-black uppercase">License Expiry</span>
                                <span class="text-slate-900 font-black">{{ $employee->license_expiry }}</span>
                            </div>
                            <div class="flex justify-between items-center bg-slate-50 p-3 rounded-xl">
                                <span class="text-slate-400 text-[10px] font-black uppercase">Issuing Province</span>
                                <span
                                    class="text-slate-900 font-black">{{ $employee->licence_issuing_province ?? 'N/A' }}</span>
                            </div>
                            <div class="flex justify-between items-center bg-slate-50 p-3 rounded-xl">
                                <span class="text-slate-400 text-[10px] font-black uppercase">Hiring Date</span>
                                <span class="text-slate-900 font-black">{{ $employee->employment_date }}</span>
                            </div>
                            <div class="flex justify-between items-center bg-slate-50 p-3 rounded-xl">
                                <span class="text-slate-400 text-[10px] font-black uppercase">Manager</span>
                                <span class="text-slate-900 font-black">{{ $employee->reporting_manager ?? 'N/A' }}</span>
                            </div>
                            <div class="flex justify-between items-center bg-slate-50 p-3 rounded-xl">
                                <span class="text-slate-400 text-[10px] font-black uppercase">SIN Number</span>
                                <span class="text-slate-900 font-black">{{ $employee->sin_number ?? 'N/A' }}</span>
                            </div>
                        </div>
                    </div>

                    <!-- Skills & Attributes (Full Width) -->
                    <div class="md:col-span-2 bg-white rounded-3xl border border-gray-100 shadow-xl p-8 mt-6">
                        <h3
                            class="text-[10px] font-black text-slate-400 uppercase tracking-[.2em] mb-6 border-b border-slate-50 pb-4">
                            Skills & Force Capabilities</h3>
                        <div class="flex flex-wrap gap-3">
                            @forelse($employee->skills as $skill)
                                <span
                                    class="px-4 py-2 bg-blue-50 text-blue-700 text-xs font-black rounded-xl border border-blue-100 uppercase tracking-wider">
                                    {{ $skill->name }}
                                </span>
                            @empty
                                <span class="text-slate-400 text-xs font-bold italic">No specialized skills assigned to this
                                    operative.</span>
                            @endforelse
                        </div>
                    </div>
                </div>
            </div>

            <!-- Documents Tab Content -->
            <div x-show="activeTab === 'documents'"
                class="bg-white rounded-3xl border border-gray-100 shadow-xl overflow-hidden p-8" x-cloak>
                <h2 class="text-xl font-black text-slate-900 mb-8 uppercase tracking-tight">Employee Dossier (Documents)
                </h2>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    <!-- Document Items -->
                    @php
                        $docs = [
                            ['label' => 'License File', 'path' => $employee->file_license],
                            ['label' => 'Employment Contract', 'path' => $employee->file_contract],
                            ['label' => 'Direct Deposit', 'path' => $employee->file_direct_deposit],
                            ['label' => 'Profile Picture', 'path' => $employee->profile_picture]
                        ];
                    @endphp

                    @foreach($docs as $doc)
                        @if($doc['path'])
                            <div
                                class="bg-slate-50 border border-slate-100 rounded-2xl p-6 flex flex-col justify-between group hover:border-blue-200 transition-all">
                                <div class="mb-4">
                                    <span
                                        class="text-[10px] font-black uppercase text-slate-400 tracking-[0.2em]">{{ $doc['label'] }}</span>
                                    <div class="text-sm font-bold truncate text-slate-900 mt-2">
                                        {{ basename($doc['path']) }}
                                    </div>
                                </div>
                                <div class="flex gap-3">
                                    <a href="{{ asset('storage/' . $doc['path']) }}" target="_blank"
                                        class="flex-1 text-center text-xs font-black bg-white border border-slate-200 text-slate-600 px-4 py-2.5 rounded-xl hover:bg-slate-900 hover:text-white hover:border-slate-900 transition-all uppercase tracking-wider">View</a>
                                    <a href="{{ asset('storage/' . $doc['path']) }}" download
                                        class="flex-1 text-center text-xs font-black bg-blue-600 text-white px-4 py-2.5 rounded-xl hover:bg-blue-700 shadow-lg shadow-blue-200 transition-all uppercase tracking-wider">Get</a>
                                </div>
                            </div>
                        @endif
                    @endforeach

                    @foreach($employee->identifications as $idFile)
                        <div
                            class="bg-slate-50 border border-slate-100 rounded-2xl p-6 flex flex-col justify-between group hover:border-blue-200 transition-all">
                            <div class="mb-4">
                                <span class="text-[10px] font-black uppercase text-slate-400 tracking-[0.2em]">ID
                                    Document</span>
                                <div class="text-sm font-bold truncate text-slate-900 mt-2">
                                    {{ basename($idFile->file_path) }}
                                </div>
                            </div>
                            <div class="flex gap-3">
                                <a href="{{ asset('storage/' . $idFile->file_path) }}" target="_blank"
                                    class="flex-1 text-center text-xs font-black bg-white border border-slate-200 text-slate-600 px-4 py-2.5 rounded-xl hover:bg-slate-900 hover:text-white hover:border-slate-900 transition-all uppercase tracking-wider">View</a>
                                <a href="{{ asset('storage/' . $idFile->file_path) }}" download
                                    class="flex-1 text-center text-xs font-black bg-blue-600 text-white px-4 py-2.5 rounded-xl hover:bg-blue-700 shadow-lg shadow-blue-200 transition-all uppercase tracking-wider">Get</a>
                            </div>
                        </div>
                    @endforeach
                </div>

                @php
                    $hasAnyDoc = $employee->file_license || $employee->file_contract || $employee->file_direct_deposit || $employee->profile_picture || $employee->identifications->isNotEmpty();
                @endphp

                @if(!$hasAnyDoc)
                    <div class="text-center py-20 bg-slate-50 rounded-3xl border border-dashed border-slate-200">
                        <svg class="w-12 h-12 text-slate-200 mx-auto mb-4" fill="none" stroke="currentColor"
                            viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                        </svg>
                        <p class="text-slate-400 font-bold italic">No classified documents found in this dossier.</p>
                    </div>
                @endif

            </div>

            <!-- Banned Sites Tab Content -->
            <div x-show="activeTab === 'banned'" class="space-y-6" x-cloak>
                <div class="bg-white rounded-3xl border border-gray-100 shadow-xl p-8">
                    <h2 class="text-2xl font-black text-slate-900 tracking-tight mb-6">Active Bans</h2>

                    @if($employee->bannedSites->isEmpty())
                        <div class="p-12 text-center bg-gray-50 border-2 border-dashed border-gray-200 rounded-3xl">
                            <div class="text-gray-400 font-medium">This employee is not banned from any sites.</div>
                        </div>
                    @else
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            @foreach($employee->bannedSites as $site)
                                <div
                                    class="p-6 bg-red-50 rounded-2xl border border-red-100 flex justify-between items-center group relative overflow-hidden">
                                    <div class="absolute -right-4 -top-4 w-16 h-16 bg-red-500/10 rounded-full blur-xl"></div>
                                    <div class="relative z-10 max-w-[100%]">
                                        <h3 class="font-bold text-red-900 text-lg truncate" title="{{ $site->name }}">
                                            {{ $site->name }}
                                        </h3>
                                        <p class="text-[10px] font-bold text-red-400 uppercase tracking-widest">{{ $site->site_id }}
                                        </p>
                                        <div
                                            class="mt-2 text-xs text-red-700 font-medium bg-red-100/50 p-2 rounded-lg inline-block">
                                            Reason: {{ $site->pivot->reason ?? 'No reason provided' }}
                                        </div>
                                        <p class="text-[10px] text-red-400 mt-1 pl-1">Banned:
                                            {{ \Carbon\Carbon::parse($site->pivot->banned_at)->format('M d, Y') }}
                                        </p>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @endif
                </div>
            </div>

            <!-- Uniforms Tab Content -->
            <div x-show="activeTab === 'uniforms'" class="space-y-6" x-cloak>
                <div class="bg-white rounded-3xl border border-gray-100 shadow-xl p-8">
                    <div class="flex justify-between items-center mb-6">
                        <h2 class="text-2xl font-black text-slate-900 tracking-tight">Issued Uniforms</h2>

                        <!-- Assign Uniform logic moved to User side as per request. Admin only views. -->
                        </div>

                        @if($employee->issuedUniforms->isEmpty())
                            <div class="p-12 text-center bg-gray-50 border-2 border-dashed border-gray-200 rounded-3xl">
                                <div class="text-gray-400 font-medium">No uniforms assigned to this employee.</div>
                            </div>
                        @else
                            <div class="overflow-x-auto rounded-xl border border-gray-100">
                                <table class="w-full text-left text-sm">
                                    <thead class="bg-slate-50 text-slate-500 uppercase tracking-widest text-[10px] font-bold">
                                        <tr>
                                            <th class="px-6 py-4">Uniform Item</th>
                                            <th class="px-6 py-4">Variant Details</th>
                                            <th class="px-6 py-4 text-center">Qty</th>
                                            <th class="px-6 py-4">Issued On</th>
                                            <th class="px-6 py-4">Notes</th>
                                        </tr>
                                    </thead>
                                    <tbody class="divide-y divide-gray-50 bg-white">
                                        @foreach($employee->issuedUniforms as $issued)
                                            <tr class="hover:bg-slate-50 transition-colors">
                                                <td class="px-6 py-4 font-bold text-slate-900">
                                                    {{ $issued->variant->uniform->name }}
                                                </td>
                                                <td class="px-6 py-4 font-medium text-slate-600">
                                                    <span class="inline-flex items-center gap-2">
                                                        @if($issued->variant->size)
                                                            <span
                                                                class="bg-gray-100 px-1.5 py-0.5 rounded textxs border border-gray-200">{{ $issued->variant->size }}</span>
                                                        @endif
                                                        @if($issued->variant->color)
                                                            <span class="text-xs">{{ $issued->variant->color }}</span>
                                                        @endif
                                                    </span>
                                                </td>
                                                <td class="px-6 py-4 text-center font-bold text-slate-900">
                                                    {{ $issued->quantity }}
                                                </td>
                                                <td class="px-6 py-4 text-slate-500 font-medium">
                                                    {{ $issued->issued_at->format('M d, Y') }}
                                                </td>
                                                <td class="px-6 py-4 text-slate-400 italic text-xs max-w-xs truncate">
                                                    {{ $issued->notes ?? '-' }}
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @endif
                    </div>
                </div>

                <!-- Availability Tab Content -->
                <div x-show="activeTab === 'availability'" class="space-y-6" x-cloak>
                    <div class="bg-white rounded-3xl border border-gray-100 shadow-xl p-8">
                        <h2 class="text-2xl font-black text-slate-900 tracking-tight mb-6">Availability Settings</h2>
                        <form action="{{ route('employees.availability.update', $employee->id) }}" method="POST">
                            @csrf
                            <div class="grid grid-cols-2 lg:grid-cols-4 gap-4 mb-8">
                                @php
                                    $days = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'];
                                    $unavailable = $employee->unavailable_days ?? [];
                                @endphp
                                @foreach($days as $day)
                                    <label
                                        class="flex items-center space-x-3 p-4 border rounded-2xl cursor-pointer hover:bg-slate-50 transition-all {{ !in_array($day, $unavailable) ? 'border-blue-200 bg-blue-50/30' : 'border-gray-200' }}">
                                        <input type="checkbox" name="available_days[]" value="{{ $day }}"
                                            class="w-5 h-5 text-blue-600 rounded-lg focus:ring-blue-500 border-gray-300 transition-all"
                                            {{ !in_array($day, $unavailable) ? 'checked' : '' }}>
                                        <span class="font-bold text-slate-700">{{ $day }}</span>
                                    </label>
                                @endforeach
                            </div>
                            <div class="flex justify-end">
                                <button type="submit"
                                    class="px-8 py-3 bg-blue-600 text-white font-bold rounded-xl hover:bg-blue-700 transition-all shadow-lg shadow-blue-200 transform hover:-translate-y-0.5">
                                    Save Availability
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

            </div>
        </div>

        <style>
            [x-cloak] {
                display: none !important;
            }

            .no-scrollbar::-webkit-scrollbar {
                display: none;
            }

            .no-scrollbar {
                -ms-overflow-style: none;
                /* IE and Edge */
                scrollbar-width: none;
                /* Firefox */
            }
        </style>
@endsection