<div id="employees-table-container">
    <div class="bg-white rounded-2xl border border-gray-100 shadow-sm overflow-hidden">
        <div>
            <table class="w-full text-left border-collapse">
                <thead class="bg-[#1e293b]">
                    <tr>
                        <th class="px-4 py-3 text-xs font-bold text-white uppercase tracking-wider">Emp ID</th>
                        <th class="px-4 py-3 text-xs font-bold text-white uppercase tracking-wider">
                            <a href="{{ route('admin.employees.index', array_merge(request()->all(), ['sort' => 'first_name', 'direction' => request('direction') === 'asc' ? 'desc' : 'asc'])) }}"
                                class="flex items-center gap-1 group ajax-sort">
                                Name
                                @if(request('sort') === 'first_name')
                                    <svg class="w-4 h-4 {{ request('direction') === 'asc' ? 'rotate-180' : '' }}" fill="none"
                                        stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M19 9l-7 7-7-7"></path>
                                    </svg>
                                @else
                                    <svg class="w-4 h-4 opacity-0 group-hover:opacity-50" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M19 9l-7 7-7-7"></path>
                                    </svg>
                                @endif
                            </a>
                        </th>
                        <th class="px-4 py-3 text-xs font-bold text-white uppercase tracking-wider">
                            <a href="{{ route('admin.employees.index', array_merge(request()->all(), ['sort' => 'email', 'direction' => request('direction') === 'asc' ? 'desc' : 'asc'])) }}"
                                class="flex items-center gap-1 group ajax-sort">
                                Email
                                @if(request('sort') === 'email')
                                    <svg class="w-4 h-4 {{ request('direction') === 'asc' ? 'rotate-180' : '' }}" fill="none"
                                        stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M19 9l-7 7-7-7"></path>
                                    </svg>
                                @else
                                    <svg class="w-4 h-4 opacity-0 group-hover:opacity-50" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M19 9l-7 7-7-7"></path>
                                    </svg>
                                @endif
                            </a>
                        </th>
                        <th class="px-4 py-3 text-xs font-bold text-white uppercase tracking-wider">Phone</th>
                        <th class="px-4 py-3 text-xs font-bold text-white uppercase tracking-wider">Company</th>
                        <th class="px-4 py-3 text-xs font-bold text-white uppercase tracking-wider">Department / Role</th>
                        <th class="px-4 py-3 text-xs font-bold text-white uppercase tracking-wider">Status</th>
                        <th class="px-4 py-3 text-xs font-bold text-white uppercase tracking-wider text-center">Car</th>
                        <th class="px-4 py-3 text-xs font-bold text-white uppercase tracking-wider text-right">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-50">
                    @forelse($employees as $employee)
                        <tr class="hover:bg-gray-50/50 transition-colors">
                            <td class="px-4 py-3">
                                <div
                                    class="text-[10px] font-black text-slate-900 bg-slate-100 px-2 py-1 rounded inline-block uppercase tracking-wider">
                                    {{ $employee->employee_id }}</div>
                            </td>
                            <td class="px-4 py-3">
                                <div class="flex items-center gap-3">
                                    <div
                                        class="w-8 h-8 rounded-full bg-blue-500 flex items-center justify-center text-white text-[10px] font-bold shadow-sm">
                                        @if($employee->profile_picture)
                                            <img src="{{ Storage::url($employee->profile_picture) }}"
                                                class="w-full h-full rounded-full object-cover">
                                        @else
                                            {{ strtoupper(substr($employee->first_name, 0, 1)) }}
                                        @endif
                                    </div>
                                    <div class="text-xs font-bold text-gray-900">{{ $employee->first_name }}
                                        {{ $employee->last_name }}
                                    </div>
                                </div>
                            </td>
                            <td class="px-4 py-3 text-xs text-gray-600">{{ $employee->email }}</td>
                            <td class="px-4 py-3 text-xs text-gray-600 font-bold">
                                {{ $employee->phone_number }}
                            </td>
                            <td class="px-4 py-3">
                                <span
                                    class="inline-flex items-center px-2 py-0.5 rounded-full text-[10px] font-bold bg-blue-50 text-blue-700">
                                    {{ $employee->company->name ?? 'N/A' }}
                                </span>
                            </td>
                            <td class="px-4 py-3">
                                <div class="text-xs text-gray-900">{{ $employee->department->name ?? 'N/A' }}</div>
                                <div class="text-[10px] text-gray-400">{{ $employee->jobRole->name ?? 'N/A' }}</div>
                            </td>
                            <td class="px-4 py-3">
                                <button type="button"
                                    onclick="toggleStatus('{{ route('admin.employees.toggle-status', $employee) }}', this)"
                                    class="relative inline-flex h-5 w-9 flex-shrink-0 cursor-pointer rounded-full border-2 border-transparent transition-colors duration-200 ease-in-out focus:outline-none focus:ring-2 focus:ring-blue-600 focus:ring-offset-2 {{ $employee->active ? 'bg-blue-600' : 'bg-gray-200' }}"
                                    role="switch" aria-checked="{{ $employee->active ? 'true' : 'false' }}">
                                    <span aria-hidden="true"
                                        class="pointer-events-none inline-block h-4 w-4 transform rounded-full bg-white shadow ring-0 transition duration-200 ease-in-out {{ $employee->active ? 'translate-x-4' : 'translate-x-0' }}"></span>
                                </button>
                            </td>
                            <td class="px-4 py-3 text-center">
                                @if($employee->has_car)
                                    <div class="inline-flex items-center justify-center w-6 h-6 rounded-lg bg-green-50 text-green-600 border border-green-100 shadow-sm" title="Car Available">
                                        <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M5 13l4 4L19 7"></path>
                                        </svg>
                                    </div>
                                @else
                                    <div class="inline-flex items-center justify-center w-6 h-6 rounded-lg bg-red-50 text-red-600 border border-red-100 shadow-sm" title="No Car">
                                        <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M6 18L18 6M6 6l12 12"></path>
                                        </svg>
                                    </div>
                                @endif
                            </td>
                            <td class="px-4 py-3 text-right">
                                <div class="flex items-center justify-end gap-2 text-right">
                                    <a href="{{ route('admin.employees.analytics', $employee->id) }}"
                                        class="p-1.5 text-slate-400 hover:text-indigo-600 hover:bg-indigo-50 rounded-lg transition-all"
                                        title="View Analytics">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z">
                                            </path>
                                        </svg>
                                    </a>
                                    <a href="{{ route('admin.employees.show', $employee) }}"
                                        class="p-1.5 text-blue-600 hover:bg-blue-50 rounded-lg transition-all"
                                        title="View Details">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                        </svg>
                                    </a>
                                    <button type="button"
                                        onclick="openDeleteModal('{{ route('admin.employees.destroy', $employee) }}', '{{ $employee->first_name }} {{ $employee->last_name }}')"
                                        class="p-1.5 text-gray-400 hover:text-red-600 hover:bg-red-50 rounded-lg transition-all"
                                        title="Delete">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16">
                                            </path>
                                        </svg>
                                    </button>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="9" class="px-6 py-12 text-center text-gray-500">
                                No employees found based on your criteria.
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        @if($employees->hasPages())
            <div class="px-6 py-4 border-t border-gray-50 bg-gray-50/30 table-pagination">
                {{ $employees->links() }}
            </div>
        @endif
    </div>
</div>
