@extends('layouts.user')

@section('title', 'Campaign Delivery Logs')

@section('content')
    <div class="mb-6 flex flex-col md:flex-row md:items-center justify-between gap-4">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Delivery Logs</h1>
            <p class="text-gray-500 text-sm">Tracking logs for campaign: <span
                    class="text-blue-600 font-bold">{{ $email_campaign->name }}</span></p>
        </div>
        <div class="flex items-center gap-3">
            <a href="{{ route('email-campaigns.index') }}"
                class="px-4 py-2 text-sm font-semibold text-gray-600 bg-white border border-gray-300 rounded-lg hover:bg-gray-50 transition-all shadow-sm">
                Back to Campaigns
            </a>
            <form action="{{ route('email-campaigns.send', $email_campaign) }}" method="POST">
                @csrf
                <button type="submit"
                    class="px-4 py-2 bg-blue-600 text-white font-bold rounded-lg hover:bg-blue-700 transition-all shadow-md shadow-blue-500/20 flex items-center gap-2 text-sm">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15">
                        </path>
                    </svg>
                    Resend All
                </button>
            </form>
        </div>
    </div>

    <!-- Summary Cards -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
        <div class="bg-white p-4 rounded-xl shadow-sm border border-gray-100">
            <div class="text-xs font-bold text-gray-400 uppercase tracking-wider mb-1">Total Attempts</div>
            <div class="text-2xl font-bold text-gray-900">{{ $email_campaign->logs()->count() }}</div>
        </div>
        <div class="bg-white p-4 rounded-xl shadow-sm border border-gray-100">
            <div class="text-xs font-bold text-emerald-500 uppercase tracking-wider mb-1">Sent / Delivered</div>
            <div class="text-2xl font-bold text-emerald-600">
                {{ $email_campaign->logs()->whereIn('status', ['sent', 'delivered'])->count() }}</div>
        </div>
        <div class="bg-white p-4 rounded-xl shadow-sm border border-gray-100">
            <div class="text-xs font-bold text-rose-500 uppercase tracking-wider mb-1">Bounced / Failed</div>
            <div class="text-2xl font-bold text-rose-600">
                {{ $email_campaign->logs()->whereIn('status', ['bounced', 'failed'])->count() }}</div>
        </div>
        <div class="bg-white p-4 rounded-xl shadow-sm border border-gray-100">
            <div class="text-xs font-bold text-blue-500 uppercase tracking-wider mb-1">Last Activity</div>
            <div class="text-lg font-bold text-gray-900">
                {{ $email_campaign->logs()->latest()->first()?->created_at->diffForHumans() ?? 'None' }}</div>
        </div>
    </div>

    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
        <table class="w-full text-left border-collapse">
            <thead class="bg-[#1e293b]">
                <tr>
                    <th class="px-6 py-4 text-xs font-bold text-white uppercase tracking-wider">Recipient Email</th>
                    <th class="px-6 py-4 text-xs font-bold text-white uppercase tracking-wider">Status</th>
                    <th class="px-6 py-4 text-xs font-bold text-white uppercase tracking-wider">Message ID</th>
                    <th class="px-6 py-4 text-xs font-bold text-white uppercase tracking-wider">Time</th>
                    <th class="px-6 py-4 text-xs font-bold text-white uppercase tracking-wider">Error Details</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-50">
                @forelse($logs as $log)
                    <tr class="hover:bg-gray-50/50 transition-colors">
                        <td class="px-6 py-4 font-medium text-gray-900 text-sm">
                            {{ $log->email }}
                        </td>
                        <td class="px-6 py-4">
                            @php
                                $statusClasses = [
                                    'sent' => 'bg-blue-100 text-blue-700',
                                    'delivered' => 'bg-emerald-100 text-emerald-700',
                                    'failed' => 'bg-rose-100 text-rose-700',
                                    'bounced' => 'bg-amber-100 text-amber-700',
                                ];
                                $class = $statusClasses[$log->status] ?? 'bg-gray-100 text-gray-700';
                            @endphp
                            <span class="px-2 py-1 {{ $class }} text-[10px] font-bold rounded-full uppercase tracking-tighter">
                                {{ $log->status }}
                            </span>
                        </td>
                        <td class="px-6 py-4 text-xs text-gray-500 font-mono">
                            {{ $log->message_id ?: 'N/A' }}
                        </td>
                        <td class="px-6 py-4 text-xs text-gray-400">
                            {{ $log->created_at->format('M d, H:i:s') }}
                        </td>
                        <td class="px-6 py-4 text-[10px] text-rose-500 max-w-xs truncate" title="{{ $log->error }}">
                            {{ $log->error ?: '-' }}
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="5" class="px-6 py-12 text-center text-gray-500 italic">
                            No logs found for this campaign.
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <div class="mt-6">
        {{ $logs->links() }}
    </div>
@endsection