@extends('layouts.user')

@section('title', 'Email Campaigns')

@section('content')
    <div class="mb-6 flex flex-col md:flex-row md:items-center justify-between gap-4">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Email Campaigns</h1>
            <p class="text-gray-500 text-sm">Manage and send email campaigns.</p>
        </div>
        <a href="{{ route('email-campaigns.create') }}" class="px-6 py-2.5 bg-blue-600 text-white font-bold rounded-xl hover:bg-blue-700 transition-all shadow-md shadow-blue-500/20 flex items-center gap-2">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
            </svg>
            Create Campaign
        </a>
    </div>

    @if(session('success'))
        <div class="mb-6 p-4 bg-emerald-50 border border-emerald-100 text-emerald-700 rounded-xl flex items-center gap-3">
             <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>
             {{ session('success') }}
        </div>
    @endif
    @if(session('error'))
        <div class="mb-6 p-4 bg-rose-50 border border-rose-100 text-rose-700 rounded-xl flex items-center gap-3">
             <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg>
             {{ session('error') }}
        </div>
    @endif

    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
        <table class="w-full text-left border-collapse">
            <thead class="bg-[#1e293b]">
                <tr>
                    <th class="px-6 py-4 text-xs font-bold text-white uppercase tracking-wider">Campaign Name</th>
                    <th class="px-6 py-4 text-xs font-bold text-white uppercase tracking-wider">Recipient</th>
                    <th class="px-6 py-4 text-xs font-bold text-white uppercase tracking-wider">Template</th>
                    <th class="px-6 py-4 text-xs font-bold text-white uppercase tracking-wider">Status</th>
                    <th class="px-6 py-4 text-xs font-bold text-white uppercase tracking-wider text-right">Actions</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-50">
                @forelse($campaigns as $campaign)
                    <tr class="hover:bg-gray-50/50 transition-colors">
                        <td class="px-6 py-4">
                            <div class="text-sm font-bold text-gray-900">{{ $campaign->name }}</div>
                            <div class="text-[10px] text-gray-400">{{ $campaign->created_at->format('M d, Y h:i A') }}</div>
                        </td>
                        <td class="px-6 py-4">
                            @if($campaign->recipient_type === 'particular')
                                <div class="text-[10px] font-bold text-gray-900">{{ $campaign->specific_email }}</div>
                                <div class="text-[8px] text-gray-400 uppercase">Individual Recipient</div>
                            @else
                                <span class="px-2 py-1 bg-gray-100 text-gray-600 text-[10px] font-bold rounded uppercase tracking-tighter">{{ ucfirst($campaign->recipient_type) }}</span>
                            @endif
                        </td>
                        <td class="px-6 py-4 text-sm text-gray-600">
                             {{ $campaign->template->name ?? 'Deleted Template' }}
                        </td>
                        <td class="px-6 py-4">
                             @if($campaign->status == 'sent' || $campaign->status == 'sending')
                                <span class="px-2 py-1 bg-emerald-100 text-emerald-700 text-[10px] font-bold rounded-full uppercase tracking-tighter">{{ ucfirst($campaign->status) }}</span>
                                <div class="text-[10px] text-gray-400 mt-1">{{ $campaign->sent_at ? $campaign->sent_at->format('M d, H:i') : '' }}</div>
                             @else
                                <span class="px-2 py-1 bg-amber-100 text-amber-700 text-[10px] font-bold rounded-full uppercase tracking-tighter">Draft</span>
                             @endif
                        </td>
                        <td class="px-6 py-4 text-right flex justify-end items-center gap-2">
                            @if($campaign->status == 'draft')
                                <form action="{{ route('email-campaigns.send', $campaign) }}" method="POST" onsubmit="return confirm('Are you sure you want to send this campaign to all recipients? This action cannot be undone.');">
                                    @csrf
                                    <button type="submit" class="px-3 py-1.5 bg-blue-100 text-blue-700 rounded-lg text-xs font-bold hover:bg-blue-200 transition-colors flex items-center gap-1">
                                        <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8"></path></svg>
                                        Send
                                    </button>
                                </form>
                            @else
                                <form action="{{ route('email-campaigns.send', $campaign) }}" method="POST" onsubmit="return confirm('Resend this campaign to all recipients?');">
                                    @csrf
                                    <button type="submit" class="px-3 py-1.5 bg-gray-100 text-gray-700 rounded-lg text-xs font-bold hover:bg-gray-200 transition-colors flex items-center gap-1">
                                        <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path></svg>
                                        Resend
                                    </button>
                                </form>
                            @endif
                            
                            <a href="{{ route('email-campaigns.logs', $campaign) }}" class="p-2 text-gray-600 hover:bg-gray-100 rounded-lg transition-all" title="View Delivery Logs">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 17v-2m3 2v-4m3 2v-6m-8 9h11a2 2 0 002-2V6a2 2 0 00-2-2H5a2 2 0 00-2 2v11a2 2 0 002 2z"></path>
                                </svg>
                            </a>
                            
                             <form action="{{ route('email-campaigns.destroy', $campaign) }}" method="POST" onsubmit="return confirm('Delete this campaign?');">
                                    @csrf @method('DELETE')
                                    <button type="submit" class="p-2 text-red-600 hover:bg-red-50 rounded-lg transition-all" title="Delete">
                                         <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path></svg>
                                    </button>
                             </form>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="5" class="px-6 py-12 text-center text-gray-500 italic">
                            No campaigns found. Click "Create Campaign" to start.
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
    <div class="mt-6">
        {{ $campaigns->links() }}
    </div>
@endsection
