@extends('layouts.admin')

@section('title', 'Edit Department')
@section('page_title', 'Edit Department')

@section('content')
<div class="mb-6 flex items-center justify-between font-inter">
    <div>
        <h1 class="text-2xl font-bold text-gray-900">Edit Department</h1>
        <p class="text-gray-500 text-sm">Update the department record for "{{ $department->name }}".</p>
    </div>
    <a href="{{ route('admin.departments.index') }}" class="inline-flex items-center gap-2 bg-gray-100 text-gray-700 px-4 py-2.5 rounded-xl font-semibold hover:bg-gray-200 transition-all">
        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path></svg>
        Back to List
    </a>
</div>

<div class="max-w-4xl">
    <form action="{{ route('admin.departments.update', $department) }}" method="POST" class="bg-white rounded-2xl border border-gray-100 shadow-sm overflow-hidden transition-all">
        @csrf
        @method('PUT')
        
        <div class="p-8 space-y-6">
            <!-- Department Name -->
            <div class="space-y-2">
                <label for="name" class="text-sm font-bold text-gray-700 uppercase tracking-tight">Department Name <span class="text-red-500">*</span></label>
                <div class="relative group">
                    <input type="text" 
                        name="name" 
                        id="name" 
                        value="{{ old('name', $department->name) }}"
                        placeholder="e.g. Operations, Human Resources" 
                        required
                        class="w-full px-4 py-3 bg-gray-50/50 border border-gray-200 rounded-xl focus:ring-4 focus:ring-blue-100 focus:border-blue-500 focus:bg-white transition-all outline-none @error('name') border-red-500 @enderror">
                </div>
                @error('name')
                    <p class="text-red-500 text-xs font-medium">{{ $message }}</p>
                @enderror
            </div>

            <!-- Display ID -->
            <div class="space-y-2">
                <label for="display_id" class="text-sm font-bold text-gray-700 uppercase tracking-tight">Display ID</label>
                <div class="relative group">
                    <input type="text" 
                        name="display_id" 
                        id="display_id" 
                        value="{{ old('display_id', $department->display_id) }}"
                        placeholder="e.g. DEPT-001" 
                        class="w-full px-4 py-3 bg-gray-50/50 border border-gray-200 rounded-xl focus:ring-4 focus:ring-blue-100 focus:border-blue-500 focus:bg-white transition-all outline-none @error('display_id') border-red-500 @enderror">
                </div>
                @error('display_id')
                    <p class="text-red-500 text-xs font-medium">{{ $message }}</p>
                @enderror
            </div>

                <div class="space-y-2">
                <label for="details" class="text-sm font-bold text-gray-700 uppercase tracking-tight">Details</label>
                <div class="relative group">
                    <textarea 
                        name="details" 
                        id="details" 
                        rows="6" 
                        placeholder="Provide additional department details and descriptions..." 
                        class="w-full px-4 py-3 bg-gray-50/50 border border-gray-200 rounded-xl focus:ring-4 focus:ring-blue-100 focus:border-blue-500 focus:bg-white transition-all outline-none resize-none @error('details') border-red-500 @enderror">{{ old('details', $department->details) }}</textarea>
                </div>
                @error('details')
                    <p class="text-red-500 text-xs font-medium">{{ $message }}</p>
                @enderror
            </div>

            <!-- Active Status -->
            <div class="space-y-2">
                <label class="text-sm font-bold text-gray-700 uppercase tracking-tight">Status</label>
                <div class="flex items-center gap-6 pt-1">
                    <label class="flex items-center gap-2 cursor-pointer group">
                        <input type="radio" name="active" value="1" {{ old('active', $department->active) ? 'checked' : '' }} class="w-4 h-4 text-blue-600 focus:ring-blue-500 border-gray-300">
                        <span class="text-sm font-medium text-gray-700 group-hover:text-blue-600 transition-colors">Active</span>
                    </label>
                    <label class="flex items-center gap-2 cursor-pointer group">
                        <input type="radio" name="active" value="0" {{ !old('active', $department->active) ? 'checked' : '' }} class="w-4 h-4 text-blue-600 focus:ring-blue-500 border-gray-300">
                        <span class="text-sm font-medium text-gray-700 group-hover:text-red-600 transition-colors">Inactive</span>
                    </label>
                </div>
            </div>
        </div>

        <div class="p-8 bg-gray-50/50 border-t border-gray-100 flex items-center justify-end gap-3">
            <button type="submit" class="bg-blue-600 text-white px-8 py-3 rounded-xl font-bold hover:bg-blue-700 transition-all shadow-lg shadow-blue-200">
                Update Department
            </button>
        </div>
    </form>
</div>
@endsection
