@extends('layouts.admin')

@section('title', 'Control Center')
@section('page_title', 'Dossier Overview')

@section('content')
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <div class="space-y-14 pb-12">
        <!-- 1. MASTER SECTION -->
        <section>
            <div class="flex items-center gap-4 mb-8">
                <div class="h-8 w-2 bg-slate-900 rounded-full"></div>
                <h2 class="text-2xl font-black text-slate-900 uppercase tracking-tighter">Master</h2>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                <!-- Companies -->
                @php
                    $masterCards = [
                        ['label' => 'Companies', 'count' => $master_stats['companies'], 'route' => 'admin.companies.index', 'icon' => 'M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4', 'color' => 'blue'],
                        ['label' => 'Users', 'count' => $master_stats['users'], 'route' => 'admin.users.index', 'icon' => 'M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z', 'color' => 'emerald'],
                        ['label' => 'Employees', 'count' => $master_stats['employees'], 'route' => 'admin.employees.index', 'icon' => 'M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z', 'color' => 'indigo'],
                        ['label' => 'Sites', 'count' => $master_stats['sites'], 'route' => 'admin.sites.index', 'icon' => 'M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4', 'color' => 'violet'],
                        ['label' => 'Routes', 'count' => $master_stats['routes'], 'route' => 'admin.routes.index', 'icon' => 'M9 20l-5.447-2.724A1 1 0 013 16.382V5.618a1 1 0 011.447-.894L9 7m0 13l6-3m-6 3V7m6 10l4.553 2.276A1 1 0 0021 18.382V7.618a1 1 0 00-.553-.894L15 4m0 13V4m0 0L9 7', 'color' => 'fuchsia'],
                    ];
                @endphp

                @foreach($masterCards as $card)
                    <a href="{{ route($card['route']) }}"
                        class="group bg-white rounded-3xl border border-slate-100 p-8 shadow-sm hover:shadow-xl hover:-translate-y-1 transition-all duration-300 relative overflow-hidden">
                        <div
                            class="absolute -right-4 -bottom-4 w-24 h-24 bg-{{ $card['color'] }}-50 rounded-full blur-2xl group-hover:bg-{{ $card['color'] }}-100 transition-all">
                        </div>
                        <div class="flex items-center gap-5 relative z-10">
                            <div
                                class="w-16 h-16 bg-{{ $card['color'] }}-50 rounded-2xl flex items-center justify-center text-{{ $card['color'] }}-600 group-hover:scale-110 transition-transform duration-500">
                                <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="{{ $card['icon'] }}"></path>
                                </svg>
                            </div>
                            <div>
                                <p class="text-[11px] font-black uppercase tracking-[0.2em] text-slate-400 leading-tight mb-1">
                                    {{ $card['label'] }}
                                </p>
                                <h3 class="text-3xl font-black text-slate-900 tracking-tighter">
                                    {{ number_format($card['count']) }}
                                </h3>
                            </div>
                        </div>
                    </a>
                @endforeach
            </div>
        </section>

        <!-- 2. MASTERS SECTION -->
        <section>
            <div class="flex items-center justify-between mb-8">
                <div class="flex items-center gap-4">
                    <div class="h-8 w-2 bg-slate-900 rounded-full"></div>
                    <h2 class="text-2xl font-black text-slate-900 uppercase tracking-tighter">Masters</h2>
                </div>
            </div>
            <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 xl:grid-cols-6 gap-4">
                @php
                    $mastersCards = [
                        ['label' => 'Time Zones', 'count' => $masters_stats['time_zones'], 'route' => 'admin.time-zones.index', 'icon' => 'M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z'],
                        ['label' => 'Zones', 'count' => $masters_stats['zones'], 'route' => 'admin.zones.index', 'icon' => 'M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z'],
                        ['label' => 'Countries', 'count' => $masters_stats['countries'], 'route' => 'admin.countries.index', 'icon' => 'M3.055 11H5a2 2 0 012 2v1a2 2 0 002 2h1a2 2 0 002-2v-1a2 2 0 012-2h2.945'],
                        ['label' => 'States', 'count' => $masters_stats['states'], 'route' => 'admin.states.index', 'icon' => 'M9 20l-5.447-2.724A1 1 0 013 16.382V5.618a1 1 0 011.447-.894L9 7m0 13l6-3'],
                        ['label' => 'Departments', 'count' => $masters_stats['departments'], 'route' => 'admin.departments.index', 'icon' => 'M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16'],
                        ['label' => 'Duty Positions', 'count' => $masters_stats['positions'], 'route' => 'admin.positions.index', 'icon' => 'M21 13.255A23.931 23.931 0 0112 15'],
                        ['label' => 'Job Roles', 'count' => $masters_stats['job_roles'], 'route' => 'admin.job-roles.index', 'icon' => 'M21 13.255A23.931 23.931 0 0112 15'],
                        ['label' => 'Wage Types', 'count' => $masters_stats['wage_types'], 'route' => 'admin.wage-types.index', 'icon' => 'M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2'],
                        ['label' => 'Uniforms', 'count' => $masters_stats['uniforms'], 'btn_route' => 'admin.uniforms.index', 'icon' => 'M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586'],
                        ['label' => 'Stat Holidays', 'count' => $masters_stats['stat_holidays'], 'route' => 'admin.stat-holidays.index', 'icon' => 'M8 7V3m8 4V3m-9 8h10M5 21h14'],
                        ['label' => 'Skills & Attributes', 'count' => $masters_stats['skills'], 'route' => 'admin.skills.index', 'icon' => 'M9 12l2 2 4-4M7.835 4.697'],
                        ['label' => 'Incident Categories', 'count' => $masters_stats['incident_categories'], 'btn_route' => 'admin.incident-categories.index', 'icon' => 'M12 9v2m0 4h.01'],
                        ['label' => 'Access Control', 'count' => $masters_stats['roles_permissions'], 'route' => 'admin.roles.index', 'icon' => 'M9 12l2 2 4-4m5.618-4.016'],
                    ];
                @endphp

                @foreach($mastersCards as $card)
                    <a href="{{ isset($card['route']) ? route($card['route']) : (isset($card['btn_route']) ? route($card['btn_route']) : '#') }}"
                        class="flex flex-col p-6 bg-white rounded-2xl border border-slate-100 hover:border-slate-300 hover:bg-slate-50 transition-all group">
                        <div class="flex items-center justify-between mb-3">
                            <div
                                class="w-10 h-10 bg-slate-100 rounded-xl flex items-center justify-center text-slate-500 group-hover:bg-slate-900 group-hover:text-white transition-all">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="{{ $card['icon'] }}"></path>
                                </svg>
                            </div>
                            <span
                                class="text-xs font-black text-slate-900 bg-slate-100 px-2 py-1 rounded-lg">{{ $card['count'] }}</span>
                        </div>
                        <span
                            class="text-[10px] font-black uppercase tracking-widest text-slate-500 group-hover:text-slate-900">{{ $card['label'] }}</span>
                    </a>
                @endforeach
            </div>
        </section>

        <!-- GRAPHS SECTION -->
        <section class="grid grid-cols-1 lg:grid-cols-2 gap-8">
            <!-- Site & Route Activity -->
            <div class="bg-white rounded-[2.5rem] border border-slate-100 p-8 shadow-sm h-full flex flex-col">
                <div class="mb-8">
                    <h3 class="text-lg font-black text-slate-900 tracking-tight">Deployment Pulse</h3>
                    <p class="text-xs text-slate-400 font-bold uppercase tracking-wider mt-1">Live Sites vs Active Routes
                    </p>
                </div>
                <div class="flex-1 flex items-center justify-center min-h-[300px]">
                    <canvas id="activeStatsChart"></canvas>
                </div>
            </div>

            <!-- Monthly Incidents -->
            <div class="bg-white rounded-[2.5rem] border border-slate-100 p-8 shadow-sm h-full flex flex-col">
                <div class="mb-8">
                    <h3 class="text-lg font-black text-slate-900 tracking-tight">Incident Trends</h3>
                    <p class="text-xs text-slate-400 font-bold uppercase tracking-wider mt-1">Monthly Analytics (Last 6
                        Months)</p>
                </div>
                <div class="flex-1 min-h-[300px]">
                    <canvas id="incidentsChart"></canvas>
                </div>
            </div>

            <!-- Monthly Tickets by Site -->
            <div class="lg:col-span-2 bg-slate-900 rounded-[2.5rem] p-10 shadow-2xl relative overflow-hidden">
                <div class="absolute top-0 right-0 p-10 opacity-10">
                    <svg class="w-64 h-64 text-white" fill="currentColor" viewBox="0 0 24 24">
                        <path
                            d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-5 14h-2v-4H8v-2h2V7h2v4h2v2h-2v4z" />
                    </svg>
                </div>
                <div class="mb-10 relative z-10">
                    <h3 class="text-2xl font-black text-white tracking-tight">Tactical Performance</h3>
                    <p class="text-sm text-slate-400 font-bold uppercase tracking-widest mt-2">Ticket Distribution by Site
                        (MDT)</p>
                </div>
                <div class="relative z-10 h-[400px]">
                    <canvas id="siteTicketsChart"></canvas>
                </div>
            </div>
        </section>

        <!-- 3, 4, 5. REPORTS, EMAILS, SYSTEM -->
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            <!-- Reports -->
            <div class="bg-white rounded-[2.5rem] border border-slate-100 p-10 shadow-sm">
                <div class="flex items-center gap-4 mb-8">
                    <div class="h-6 w-1.5 bg-blue-600 rounded-full"></div>
                    <h2 class="text-xl font-black text-slate-900 uppercase tracking-tighter">Reports</h2>
                </div>
                <div class="space-y-4">
                    <a href="{{ route('admin.reports.operational.index') }}"
                        class="flex items-center justify-between p-5 bg-slate-50 rounded-2xl hover:bg-blue-600 hover:text-white transition-all group">
                        <span class="text-xs font-black uppercase tracking-widest">Operational</span>
                        <span
                            class="text-xs font-bold bg-white/20 px-2 py-1 rounded-lg">{{ $reports_stats['operational'] }}</span>
                    </a>
                    <a href="{{ route('admin.reports.patroller.index') }}"
                        class="flex items-center justify-between p-5 bg-slate-50 rounded-2xl hover:bg-blue-600 hover:text-white transition-all group">
                        <span class="text-xs font-black uppercase tracking-widest">Patroller</span>
                        <span
                            class="text-xs font-bold bg-white/20 px-2 py-1 rounded-lg">{{ $reports_stats['patroller'] }}</span>
                    </a>
                    <a href="{{ route('admin.notifications.index') }}"
                        class="flex items-center justify-between p-5 bg-slate-50 rounded-2xl hover:bg-blue-600 hover:text-white transition-all group">
                        <span class="text-xs font-black uppercase tracking-widest">Communication</span>
                        <span
                            class="text-xs font-bold bg-white/20 px-2 py-1 rounded-lg">{{ $reports_stats['communication'] }}</span>
                    </a>
                </div>
            </div>

            <!-- Emails -->
            <div class="bg-white rounded-[2.5rem] border border-slate-100 p-10 shadow-sm">
                <div class="flex items-center gap-4 mb-8">
                    <div class="h-6 w-1.5 bg-emerald-600 rounded-full"></div>
                    <h2 class="text-xl font-black text-slate-900 uppercase tracking-tighter">Emails</h2>
                </div>
                <div class="space-y-4">
                    <a href="{{ route('admin.email-signatures.index') }}"
                        class="flex items-center justify-between p-5 bg-slate-50 rounded-2xl hover:bg-emerald-600 hover:text-white transition-all group">
                        <span class="text-xs font-black uppercase tracking-widest">Signatures</span>
                        <span
                            class="text-xs font-bold bg-white/20 px-2 py-1 rounded-lg">{{ $emails_stats['signatures'] }}</span>
                    </a>
                    <a href="{{ route('admin.email-templates.index') }}"
                        class="flex items-center justify-between p-5 bg-slate-50 rounded-2xl hover:bg-emerald-600 hover:text-white transition-all group">
                        <span class="text-xs font-black uppercase tracking-widest">Templates</span>
                        <span
                            class="text-xs font-bold bg-white/20 px-2 py-1 rounded-lg">{{ $emails_stats['templates'] }}</span>
                    </a>
                </div>
            </div>

            <!-- System -->
            <div class="bg-white rounded-[2.5rem] border border-slate-100 p-10 shadow-sm">
                <div class="flex items-center gap-4 mb-8">
                    <div class="h-6 w-1.5 bg-rose-600 rounded-full"></div>
                    <h2 class="text-xl font-black text-slate-900 uppercase tracking-tighter">System</h2>
                </div>
                <div class="grid grid-cols-2 gap-3">
                    @php
                        $systemItems = [
                            ['label' => 'Logs', 'route' => 'admin.logs.index'],
                            ['label' => 'Appearance', 'route' => 'admin.settings.appearance'],
                            ['label' => 'Typography', 'route' => 'admin.settings.css'],
                            ['label' => 'Integrations', 'route' => 'admin.settings.integrations'],
                            ['label' => 'Rules', 'route' => 'admin.settings.operational'],
                            ['label' => 'ID Settings', 'route' => 'admin.id-settings.index'],
                            ['label' => 'Security', 'route' => 'admin.settings.security'],
                            ['label' => 'Activity', 'route' => 'admin.activity-logs.index'],
                            ['label' => 'Password', 'route' => 'admin.settings.password'],
                            ['label' => 'Maintenance', 'route' => 'admin.settings.system'],
                        ];
                    @endphp
                    @foreach($systemItems as $item)
                        <a href="{{ route($item['route']) }}"
                            class="p-4 bg-slate-50 rounded-xl hover:bg-rose-600 hover:text-white transition-all text-center">
                            <span class="text-[9px] font-black uppercase tracking-widest">{{ $item['label'] }}</span>
                        </a>
                    @endforeach
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            // 1. Deployment Pulse Chart
            new Chart(document.getElementById('activeStatsChart'), {
                type: 'doughnut',
                data: {
                    labels: ['Live Sites', 'Active Routes'],
                    datasets: [{
                        data: [{{ $liveSitesCount }}, {{ $activeRoutesCount }}],
                        backgroundColor: ['#3b82f6', '#4f46e5'],
                        borderWidth: 0,
                        hoverOffset: 10
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    cutout: '75%',
                    plugins: {
                        legend: {
                            position: 'bottom',
                            labels: {
                                padding: 20,
                                usePointStyle: true,
                                font: { size: 10, weight: 'bold' }
                            }
                        }
                    }
                }
            });

            // 2. Incident Trends Chart
            new Chart(document.getElementById('incidentsChart'), {
                type: 'line',
                data: {
                    labels: {!! json_encode($incidentData->pluck('month')) !!},
                    datasets: [{
                        label: 'Incidents',
                        data: {!! json_encode($incidentData->pluck('count')) !!},
                        borderColor: '#f43f5e',
                        backgroundColor: 'rgba(244, 63, 94, 0.1)',
                        fill: true,
                        tension: 0.4,
                        borderWidth: 4,
                        pointRadius: 6,
                        pointBackgroundColor: '#fff',
                        pointBorderColor: '#f43f5e',
                        pointBorderWidth: 3
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: { display: false }
                    },
                    scales: {
                        y: { beginAtZero: true, grid: { display: false } },
                        x: { grid: { display: false } }
                    }
                }
            });

            // 3. Site Tickets Chart
            new Chart(document.getElementById('siteTicketsChart'), {
                type: 'bar',
                data: {
                    labels: {!! json_encode($ticketDataBySite->pluck('site_name')) !!},
                    datasets: [{
                        label: 'Tickets',
                        data: {!! json_encode($ticketDataBySite->pluck('count')) !!},
                        backgroundColor: '#fff',
                        borderRadius: 12,
                        barThickness: 40
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: { display: false }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            grid: { color: 'rgba(255,255,255,0.05)' },
                            ticks: { color: '#64748b', font: { weight: 'bold' } }
                        },
                        x: {
                            grid: { display: false },
                            ticks: { color: '#fff', font: { weight: 'bold', size: 10 } }
                        }
                    }
                }
            });
        });
    </script>

    <style>
        .rounded-3xl {
            border-radius: 1.5rem;
        }

        .rounded-\[2\.5rem\] {
            border-radius: 2.5rem;
        }
    </style>
@endsection