@extends(request()->routeIs('admin.*') ? 'layouts.admin' : 'layouts.user')

@section('title', 'Employee Attendance Chart')

@section('content')
    @php
        $routePrefix = request()->routeIs('admin.*') ? 'admin.attendance.chart' : 'attendance.chart';
    @endphp

    <div class="space-y-6">
        <!-- Page Header -->
        <div class="flex items-center justify-between">
            <h1 class="text-2xl font-bold text-gray-800">Employee Attendance Chart</h1>
        </div>

        <!-- Filters -->
        <div class="bg-white p-6 rounded-lg shadow-sm border border-gray-200">
            <form method="GET" action="{{ route($routePrefix) }}" class="flex items-end gap-4">
                <!-- Employee Filter -->
                <div class="w-64">
                    <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Employee</label>
                    <select name="employee_id"
                        class="w-full text-sm rounded-lg border-gray-300 focus:border-purple-500 focus:ring-purple-500 px-3 py-2 shadow-sm">
                        <option value="">All Employees</option>
                        @foreach($employees as $emp)
                            <option value="{{ $emp->id }}" {{ request('employee_id') == $emp->id ? 'selected' : '' }}>
                                {{ $emp->first_name }} {{ $emp->last_name }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <!-- Month Filter -->
                <div class="w-40">
                    <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Month</label>
                    <select name="month"
                        class="w-full text-sm rounded-lg border-gray-300 focus:border-purple-500 focus:ring-purple-500 px-3 py-2 shadow-sm">
                        @foreach(range(1, 12) as $m)
                            <option value="{{ $m }}" {{ request('month', now()->month) == $m ? 'selected' : '' }}>
                                {{ \Carbon\Carbon::create()->month($m)->format('F') }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <!-- Year Filter -->
                <div class="w-32">
                    <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Year</label>
                    <select name="year"
                        class="w-full text-sm rounded-lg border-gray-300 focus:border-purple-500 focus:ring-purple-500 px-3 py-2 shadow-sm">
                        @foreach(range(now()->year - 2, now()->year + 1) as $y)
                            <option value="{{ $y }}" {{ request('year', now()->year) == $y ? 'selected' : '' }}>
                                {{ $y }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <button type="submit"
                    class="h-[38px] px-6 bg-purple-600 text-white text-sm font-medium rounded-lg hover:bg-purple-700 transition-colors shadow-sm">
                    Apply
                </button>
            </form>
        </div>

        <!-- Attendance Chart -->
        <div class="bg-white rounded-lg shadow-sm border border-gray-200">
            <div class="">
                <table class="w-full text-left border-collapse table-fixed">
                    <thead class="bg-gray-50/50 border-b border-gray-100">
                        <tr>
                            <th
                                class="px-2 py-3 text-[10px] font-bold text-gray-400 uppercase tracking-wider w-32 bg-gray-50 border-r border-gray-100">
                                Employee
                            </th>
                            @foreach($daysInMonth as $day)
                                <th class="py-3 text-[10px] font-bold text-gray-400 uppercase tracking-wider text-center border-r border-gray-100 last:border-r-0">
                                    {{ $day }}
                                </th>
                            @endforeach
                            <th class="px-1 py-3 text-[10px] font-bold text-gray-400 uppercase tracking-wider text-center bg-blue-50 w-12 border-l border-gray-200">
                                P
                            </th>
                            <th class="px-1 py-3 text-[10px] font-bold text-gray-400 uppercase tracking-wider text-center bg-red-50 w-12 border-l border-white">
                                A
                            </th>
                            <th class="px-1 py-3 text-[10px] font-bold text-gray-400 uppercase tracking-wider text-center bg-gray-50 w-12 border-l border-white">
                                T
                            </th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100">
                        @forelse($attendanceData as $employeeId => $data)
                            <tr class="hover:bg-gray-50/80 transition-colors">
                                <td class="px-2 py-2 text-xs font-bold text-gray-900 bg-white border-r border-gray-100">
                                    <div class="truncate" title="{{ $data['name'] }}">{{ $data['name'] }}</div>
                                </td>
                                @foreach($daysInMonth as $day)
                                    <td class="py-2 text-center p-0 border-r border-gray-100 last:border-r-0">
                                        <div class="flex justify-center items-center h-full">
                                            @if(isset($data['days'][$day]))
                                                @if($data['days'][$day] === 'present')
                                                    <span class="block w-2.5 h-2.5 rounded-sm bg-green-500" title="Present"></span>
                                                @elseif($data['days'][$day] === 'absent')
                                                    <span class="block w-2.5 h-2.5 rounded-sm bg-red-500" title="Absent"></span>
                                                @else
                                                    <span class="block w-1.5 h-1.5 rounded-full bg-gray-200" title="No Job"></span>
                                                @endif
                                            @else
                                                <span class="block w-1.5 h-1.5 rounded-full bg-gray-200" title="No Job"></span>
                                            @endif
                                        </div>
                                    </td>
                                @endforeach
                                <td class="px-1 py-2 text-xs font-bold text-center bg-green-50 text-green-700 border-l border-gray-200">
                                    {{ $data['present_count'] }}
                                </td>
                                <td class="px-1 py-2 text-xs font-bold text-center bg-red-50 text-red-700 border-l border-white">
                                    {{ $data['absent_count'] }}
                                </td>
                                <td class="px-1 py-2 text-xs font-bold text-center bg-gray-50 text-gray-700 border-l border-white">
                                    {{ $data['total_jobs'] }}
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="{{ count($daysInMonth) + 4 }}" class="px-6 py-12 text-center text-gray-400">
                                    <p class="text-xs font-bold uppercase tracking-wider">No attendance data found for this period</p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Legend -->
        <div class="bg-white p-4 rounded-lg shadow-sm border border-gray-200">
            <div class="flex items-center gap-6">
                <div class="flex items-center gap-2">
                    <span class="inline-block w-3 h-3 rounded-sm bg-green-500"></span>
                    <span class="text-xs text-gray-700 font-medium">Present</span>
                </div>
                <div class="flex items-center gap-2">
                    <span class="inline-block w-3 h-3 rounded-sm bg-red-500"></span>
                    <span class="text-xs text-gray-700 font-medium">Absent</span>
                </div>
                <div class="flex items-center gap-2">
                    <span class="inline-block w-2 h-2 rounded-full bg-gray-200"></span>
                    <span class="text-xs text-gray-700 font-medium">No Job</span>
                </div>
            </div>
        </div>
    </div>

    <!-- Select2 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

    <!-- Select2 JS -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
        $(document).ready(function () { $('select[name="employee_id"]').select2({ placeholder: 'All Employees', allowClear: true, width: '100%' }); });
    </script>
@endsection