@extends('layouts.user')

@section('title', 'Add-on Schedules')

@section('content')
    <div class="p-6">
        <div class="mb-6">
            <h1 class="text-2xl font-bold text-gray-800">Add-on Schedules</h1>
            <p class="text-gray-500">Manage missed items and review manual completions.</p>
        </div>



        <div class="bg-white p-4 rounded-xl border border-gray-100 shadow-sm mb-6">
            <form method="GET" action="{{ route('addon-schedules.index') }}" class="flex flex-wrap md:flex-nowrap gap-4 items-end">
                <div class="flex-1 min-w-[200px]">
                    <label class="block text-[10px] font-bold text-gray-400 uppercase mb-1">Search Keywords</label>
                    <input type="text" name="search" value="{{ request('search') }}"
                        placeholder="Search by Duty #, Site, or Employee..."
                        class="w-full px-4 py-2 border border-gray-200 rounded-lg focus:ring-2 focus:ring-blue-500 outline-none text-sm font-bold text-gray-700 h-[42px]">
                </div>
                <div class="w-full md:w-auto">
                    <label class="block text-[10px] font-bold text-gray-400 uppercase mb-1">Start Date</label>
                    <input type="date" name="start_date" value="{{ request('start_date') }}"
                        class="w-full px-4 py-2 border border-gray-200 rounded-lg focus:ring-2 focus:ring-blue-500 outline-none text-sm font-bold text-gray-700 h-[42px]">
                </div>
                <div class="w-full md:w-auto">
                    <label class="block text-[10px] font-bold text-gray-400 uppercase mb-1">End Date</label>
                    <input type="date" name="end_date" value="{{ request('end_date') }}"
                        class="w-full px-4 py-2 border border-gray-200 rounded-lg focus:ring-2 focus:ring-blue-500 outline-none text-sm font-bold text-gray-700 h-[42px]">
                </div>
                <button type="submit"
                    class="px-8 py-2 bg-blue-600 text-white font-bold rounded-lg hover:bg-blue-700 transition-colors h-[42px]">
                    Filter
                </button>
                @if(request()->anyFilled(['search', 'start_date', 'end_date']))
                    <a href="{{ route('addon-schedules.index') }}"
                        class="px-4 py-2 bg-gray-100 text-gray-600 font-bold rounded-lg hover:bg-gray-200 transition-colors h-[42px] flex items-center justify-center">
                        Clear
                    </a>
                @endif
            </form>
        </div>

        <div class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden">
            <table class="w-full text-left border-collapse">
                <thead class="bg-gray-50 border-b border-gray-100">
                    <tr>
                        <th class="px-6 py-4 text-[11px] font-bold text-gray-400 uppercase tracking-wider">Duty #</th>
                        <th class="px-6 py-4 text-[11px] font-bold text-gray-400 uppercase tracking-wider">Date</th>
                        <th class="px-6 py-4 text-[11px] font-bold text-gray-400 uppercase tracking-wider">Site</th>
                        <th class="px-6 py-4 text-[11px] font-bold text-gray-400 uppercase tracking-wider">Assigned To</th>
                        <th class="px-6 py-4 text-[11px] font-bold text-gray-400 uppercase tracking-wider">Shift Timing</th>
                        <th class="px-6 py-4 text-[11px] font-bold text-gray-400 uppercase tracking-wider text-right">Action
                        </th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    @forelse($schedules as $schedule)
                        <tr class="hover:bg-gray-50 transition-colors" x-data="{ showModal: false }">
                            <td class="px-6 py-4">
                                <div class="flex flex-col gap-1">
                                    <span class="text-sm font-bold text-gray-900">{{ $schedule->duty_number }}</span>
                                    @if($schedule instanceof \App\Models\PatrollerSchedule)
                                        <span class="inline-flex items-center px-2 py-0.5 rounded text-[10px] font-bold bg-purple-100 text-purple-700 border border-purple-200 w-fit">Patrol Job</span>
                                    @else
                                        <span class="inline-flex items-center px-2 py-0.5 rounded text-[10px] font-bold bg-indigo-100 text-indigo-700 border border-indigo-200 w-fit">Guard Job</span>
                                    @endif
                                </div>
                            </td>
                            <td class="px-6 py-4">
                                <div class="text-sm font-medium text-gray-600">{{ $schedule->from_datetime->format('M d, Y') }}
                                </div>
                            </td>
                            <td class="px-6 py-4">
                                <span class="text-sm font-bold text-gray-800">{{ $schedule->virtual_site->name }}</span>
                                <div class="text-xs text-gray-400">{{ $schedule->virtual_site->site_id }}</div>
                            </td>
                            <td class="px-6 py-4">
                                @forelse($schedule->employees as $emp)
                                    <div class="flex flex-col mb-1 last:mb-0">
                                        <span
                                            class="text-sm font-bold text-slate-700 {{ !is_null($emp->pivot->actual_start_at) ? 'line-through text-slate-400' : '' }}">
                                            {{ $emp->first_name }} {{ $emp->last_name }}
                                        </span>
                                        <span class="text-[10px] text-slate-400">{{ $emp->employee_id }}</span>
                                    </div>
                                @empty
                                    <span class="text-sm text-gray-400 italic">Unassigned</span>
                                @endforelse
                            </td>
                            <td class="px-6 py-4">
                                <div class="text-xs font-medium text-gray-500">
                                    {{ $schedule->from_datetime->format('h:i A') }} -
                                    {{ $schedule->to_datetime->format('h:i A') }}
                                </div>
                            </td>
                            <td class="px-6 py-4 text-right">
                                <button @click="showModal = true"
                                    class="px-4 py-2 bg-blue-50 text-blue-600 text-xs font-bold rounded-lg hover:bg-blue-100 transition-colors border border-blue-200">
                                    Complete
                                </button>

                                <!-- Modal -->
                                <div x-show="showModal"
                                    class="fixed inset-0 z-50 flex items-center justify-center p-4 text-left" x-cloak>
                                    <div class="absolute inset-0 bg-slate-900/50 backdrop-blur-sm" @click="showModal = false">
                                    </div>
                                    <div
                                        class="relative bg-white rounded-2xl shadow-xl w-full max-w-lg overflow-y-auto max-h-[90vh]">
                                        <form action="{{ route('addon-schedules.store', $schedule) }}" method="POST"
                                            enctype="multipart/form-data">
                                            @csrf
                                            <input type="hidden" name="type" value="{{ $schedule instanceof \App\Models\PatrollerSchedule ? 'patrol' : 'guard' }}">
                                            <div class="p-6 border-b border-gray-100 bg-gray-50">
                                                <h3 class="text-lg font-bold text-gray-900">Manual Completion:
                                                    #{{ $schedule->duty_number }}</h3>
                                            </div>

                                            <div class="p-6 space-y-6">
                                                <!-- Loop through ALL employees -->
                                                @foreach($schedule->employees as $index => $emp)
                                                    @if(is_null($emp->pivot->actual_start_at))
                                                        <div class="p-4 border-2 border-gray-200 rounded-xl bg-gray-50 space-y-4">
                                                            <!-- Employee Header -->
                                                            <div class="flex items-center gap-3 pb-3 border-b border-gray-200">
                                                                @if($emp->profile_picture)
                                                                    <img src="{{ asset('storage/' . $emp->profile_picture) }}" class="w-10 h-10 rounded-full object-cover ring-2 ring-blue-500">
                                                                @else
                                                                    <div class="w-10 h-10 rounded-full bg-blue-100 text-blue-600 flex items-center justify-center font-bold text-sm">
                                                                        {{ substr($emp->first_name, 0, 1) }}{{ substr($emp->last_name, 0, 1) }}
                                                                    </div>
                                                                @endif
                                                                <div>
                                                                    <div class="text-sm font-bold text-gray-900">{{ $emp->first_name }} {{ $emp->last_name }}</div>
                                                                    <div class="text-[10px] text-gray-500 font-bold uppercase">{{ $emp->employee_id }}</div>
                                                                </div>
                                                            </div>

                                                            <input type="hidden" name="employees[{{ $index }}][employee_id]" value="{{ $emp->id }}">

                                                            <!-- Check-in & Check-out Times -->
                                                            <div class="grid grid-cols-2 gap-4">
                                                                <div>
                                                                    <label class="block text-xs font-bold text-gray-500 uppercase mb-2">Check-in Time</label>
                                                                    <input type="datetime-local" name="employees[{{ $index }}][checkin_datetime]" required
                                                                        value="{{ $schedule->from_datetime->format('Y-m-d\TH:i') }}"
                                                                        class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm bg-white focus:ring-2 focus:ring-blue-500 outline-none">
                                                                </div>
                                                                <div>
                                                                    <label class="block text-xs font-bold text-gray-500 uppercase mb-2">Check-out Time</label>
                                                                    <input type="datetime-local" name="employees[{{ $index }}][checkout_datetime]" required
                                                                        value="{{ $schedule->to_datetime->format('Y-m-d\TH:i') }}"
                                                                        class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm bg-white focus:ring-2 focus:ring-blue-500 outline-none">
                                                                </div>
                                                            </div>

                                                            <!-- Check-in & Check-out Images (Only for Guard Jobs) -->
                                                            @if(!($schedule instanceof \App\Models\PatrollerSchedule))
                                                                <div class="grid grid-cols-2 gap-4">
                                                                    <div>
                                                                        <label class="block text-xs font-bold text-gray-500 uppercase mb-2">Check-in Image</label>
                                                                        <input type="file" name="employees[{{ $index }}][checkin_image]" accept="image/*"
                                                                            class="w-full text-xs text-gray-500 file:mr-2 file:py-1.5 file:px-3 file:rounded-lg file:border-0 file:text-xs file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100">
                                                                    </div>
                                                                    <div>
                                                                        <label class="block text-xs font-bold text-gray-500 uppercase mb-2">Check-out Image</label>
                                                                        <input type="file" name="employees[{{ $index }}][checkout_image]" accept="image/*"
                                                                            class="w-full text-xs text-gray-500 file:mr-2 file:py-1.5 file:px-3 file:rounded-lg file:border-0 file:text-xs file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100">
                                                                    </div>
                                                                </div>
                                                            @endif
                                                        </div>
                                                    @endif
                                                @endforeach

                                                @if($schedule->employees->every(fn($e) => !is_null($e->pivot->actual_start_at)))
                                                    <div class="p-4 bg-green-50 border border-green-200 rounded-xl text-center">
                                                        <p class="text-sm font-bold text-green-700">All employees have already completed this schedule.</p>
                                                    </div>
                                                @endif

                                                <div class="grid grid-cols-2 gap-4 mt-6 pt-6 border-t border-gray-100">
                                                    <button type="button" @click="showModal = false"
                                                        class="w-full px-4 py-2.5 bg-white border border-gray-200 text-gray-700 font-bold rounded-xl hover:bg-gray-50 transition-colors">
                                                        Cancel
                                                    </button>
                                                    <button type="submit"
                                                        class="w-full px-4 py-2.5 bg-blue-600 text-white font-bold rounded-xl hover:bg-blue-700 transition-colors shadow-lg shadow-blue-500/30">
                                                        Complete Job
                                                    </button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="px-6 py-12 text-center text-gray-400 italic">
                                No missed schedules found.
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div class="mt-4">
            {{ $schedules->appends(request()->query())->links() }}
        </div>
    </div>
@endsection