<!DOCTYPE html>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Activity Logs</title>
    <style>
        body {
            font-family: sans-serif;
            font-size: 10px;
            color: #333;
        }

        .header {
            margin-bottom: 20px;
            border-bottom: 1px solid #ddd;
            padding-bottom: 10px;
        }

        .header h1 {
            margin: 0;
            font-size: 18px;
            color: #111;
        }

        .meta {
            font-size: 12px;
            color: #666;
            margin-top: 5px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
        }

        th,
        td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
            vertical-align: top;
        }

        th {
            background-color: #f9f9f9;
            font-weight: bold;
            color: #444;
            text-transform: uppercase;
            font-size: 9px;
        }

        .action {
            font-weight: bold;
            color: #2563eb;
            text-transform: uppercase;
            font-size: 9px;
        }

        .date {
            white-space: nowrap;
            color: #666;
        }

        .ip {
            font-family: monospace;
            color: #666;
        }
    </style>
</head>

<body>
    <div class="header">
        <h1>Activity Logs Report</h1>
        <div class="meta">
            User: {{ Auth::user()->name }}<br>
            Period: {{ ucfirst($range) }}<br>
            Date: {{ now()->format('M d, Y h:i A') }}
        </div>
    </div>

    <table>
        <thead>
            <tr>
                <th width="120">Date & Time</th>
                <th width="80">Action</th>
                <th>Description</th>
                <th width="100">IP Address</th>
            </tr>
        </thead>
        <tbody>
            @foreach($logs as $log)
                <tr>
                    <td class="date">{{ $log->created_at->format('Y-m-d H:i') }}</td>
                    <td><span class="action">{{ $log->action }}</span></td>
                    <td>
                        {{ $log->description ?: '-' }}
                        @if($log->subject_type && $log->subject_id)
                            <br><small style="color: #999;">{{ class_basename($log->subject_type) }}
                                #{{ $log->subject_id }}</small>
                        @endif
                    </td>
                    <td class="ip">{{ $log->ip_address ?: '-' }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>

</html>