<?php

namespace App\Http\Controllers;

use App\Models\UniformVariant;
use Illuminate\Http\Request;

class UniformController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $companyId = session('selected_company_id') ?? auth()->user()->company_id ?? \App\Models\Company::first()->id;

        $inventory = UniformVariant::with('uniform')
            ->whereHas('uniform', function ($q) use ($companyId) {
                $q->where('company_id', $companyId);
                $q->where('active', true);
            })
            ->where('active', true)
            ->orderBy('uniform_id')
            ->get();

        return view('uniforms.index', compact('inventory'));
    }
}
