<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\GuardApplication;

class PublicSiteController extends Controller
{
    public function index()
    {
        return view('welcome');
    }

    public function about()
    {
        return view('about');
    }

    public function contact()
    {
        return view('contact');
    }

    public function becomeGuard()
    {
        return view('become-guard');
    }

    public function storeGuardApplication(Request $request)
    {
        $validated = $request->validate([
            'full_name' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'phone' => 'required|string|max:20',
            'experience_years' => 'required|integer|min:0',
            'message' => 'nullable|string',
            'resume' => 'nullable|file|mimes:pdf,doc,docx|max:2048',
        ]);

        $path = null;
        if ($request->hasFile('resume')) {
            $path = $request->file('resume')->store('resumes', 'public');
        }

        GuardApplication::create([
            'full_name' => $validated['full_name'],
            'email' => $validated['email'],
            'phone' => $validated['phone'],
            'experience_years' => $validated['experience_years'],
            'message' => $validated['message'] ?? null,
            'resume_path' => $path,
        ]);

        return redirect()->route('become-guard')->with('success', 'Your application has been submitted successfully!');
    }
}
