<?php

namespace App\Http\Controllers\Employee;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class ChatBotController extends Controller
{
    private $knowledgeBase = [
        [
            'keywords' => ['start job', 'how to start', 'begin work'],
            'response' => "To start your job: \n1. Go to your Dashboard or Schedule.\n2. Locate your assigned shift.\n3. Click the 'Start Shift' button.\n4. Ensure you are at the site location (GPS enabled)."
        ],
        [
            'keywords' => ['checkin image', 'check in photo', 'selfie'],
            'response' => "For Check-in: You must upload a clear photo/selfie in your uniform. This verifies your identity and compliance with uniform policy."
        ],
        [
            'keywords' => ['checkout image', 'check out photo', 'end photo'],
            'response' => "For Check-out: Take a photo of the site status or your post to document that everything is in order before you leave."
        ],
        [
            'keywords' => ['report incident', 'incident'],
            'response' => "To report an incident: Click on the 'Report Incident' button on your dashboard. Select the type of incident, add a description, and attach start/end photos if required."
        ],
        [
            'keywords' => ['end job', 'finish work', 'stop'],
            'response' => "To end your job: Click the 'End Shift' button. You will be asked to upload a checkout image and confirm your location."
        ],
        [
            'keywords' => ['salary', 'pay', 'calculation', 'wage'],
            'response' => "Your salary is calculated as: (Hourly Wage Rate × Hours Worked) + any additional allowances (e.g., Gas). You can view your estimated payout in the Reports section."
        ],
        [
            'keywords' => ['job not started', 'cant start', 'cannot start'],
            'response' => "If the job is not starting:\n1. Check your internet connection.\n2. Ensure GPS is on and you are inside the site geofence.\n3. Refresh the page.\n4. If the issue persists, contact your supervisor immediately."
        ],
        [
            'keywords' => ['when start', 'shift time', 'schedule'],
            'response' => "Check your 'My Schedule' page to see the exact start date and time of your assigned shifts."
        ],
        [
            'keywords' => ['upload image', 'add photo'],
            'response' => "To upload images: When prompted (during check-in/out or incident reporting), tap the camera icon or 'Upload' button. You can select from gallery or take a new photo."
        ],
        [
            'keywords' => ['hello', 'hi', 'hey'],
            'response' => "Hello! I am your AI assistant. Ask me about starting jobs, images, incidents, or salary."
        ]
    ];

    public function chat(Request $request)
    {
        $message = strtolower($request->input('message', ''));

        $response = $this->findResponse($message);

        return response()->json([
            'response' => $response
        ]);
    }

    private function findResponse($message)
    {
        foreach ($this->knowledgeBase as $item) {
            foreach ($item['keywords'] as $keyword) {
                if (str_contains($message, $keyword)) {
                    return $item['response'];
                }
            }
        }

        return "I'm not sure about that. Try asking about 'starting job', 'salary', 'incidents', or 'images'.";
    }
}
