<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\IdSetting;
use App\Models\Company;
use Illuminate\Http\Request;

class IdSettingController extends Controller
{
    public function index()
    {
        $idSettings = IdSetting::with('company')->get();
        return view('admin.id-settings.index', compact('idSettings'));
    }

    public function create()
    {
        $companies = Company::where('active', true)->orderBy('name')->get();
        return view('admin.id-settings.create', compact('companies'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'company_id' => 'required|exists:companies,id|unique:id_settings,company_id',
            'emp_prefix' => 'nullable|string',
            'emp_next_number' => 'required|integer',
            'site_prefix' => 'nullable|string',
            'site_next_number' => 'required|integer',
            'route_prefix' => 'nullable|string',
            'route_next_number' => 'required|integer',
            'duty_prefix' => 'nullable|string',
            'duty_next_number' => 'required|integer',
            'incident_prefix' => 'nullable|string',
            'incident_next_number' => 'required|integer',
            'patroller_prefix' => 'nullable|string',
            'patroller_next_number' => 'required|integer',
        ]);

        IdSetting::create($request->all());

        return redirect()->route('admin.id-settings.index')->with('success', 'ID Settings created successfully.');
    }

    public function edit(IdSetting $idSetting)
    {
        $companies = Company::where('active', true)->orderBy('name')->get();
        return view('admin.id-settings.edit', compact('idSetting', 'companies'));
    }

    public function update(Request $request, IdSetting $idSetting)
    {
        $request->validate([
            'company_id' => 'required|exists:companies,id|unique:id_settings,company_id,' . $idSetting->id,
            'emp_prefix' => 'nullable|string',
            'emp_next_number' => 'required|integer',
            'site_prefix' => 'nullable|string',
            'site_next_number' => 'required|integer',
            'route_prefix' => 'nullable|string',
            'route_next_number' => 'required|integer',
            'duty_prefix' => 'nullable|string',
            'duty_next_number' => 'required|integer',
            'incident_prefix' => 'nullable|string',
            'incident_next_number' => 'required|integer',
            'patroller_prefix' => 'nullable|string',
            'patroller_next_number' => 'required|integer',
        ]);

        $idSetting->update($request->all());

        return redirect()->route('admin.id-settings.index')->with('success', 'ID Settings updated successfully.');
    }

    public function destroy(IdSetting $idSetting)
    {
        $idSetting->delete();
        return redirect()->route('admin.id-settings.index')->with('success', 'ID Settings deleted successfully.');
    }
}
