<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class UserHelpController extends Controller
{
    public function index()
    {
        return view('user.help');
    }

    public function reportIssue(\Illuminate\Http\Request $request)
    {
        $request->validate([
            'subject' => 'required|string|max:255',
            'message' => 'required|string',
        ]);

        \App\Models\SupportTicket::create([
            'user_id' => auth()->id(),
            'subject' => $request->subject,
            'message' => $request->message,
        ]);

        return redirect()->back()->with('success', 'Your issue has been reported to the technical team. Ticket created.');
    }
}
