<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\WageType;
use Illuminate\Http\Request;

class WageTypeController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $wageTypes = WageType::latest()->paginate(100);
        return view('admin.wage-types.index', compact('wageTypes'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.wage-types.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255|unique:wage_types,name',
            'active' => 'boolean',
        ]);

        WageType::create($validated);

        return redirect()->route('admin.wage-types.index')->with('success', 'Wage Type created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(WageType $wageType)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(WageType $wageType)
    {
        return view('admin.wage-types.edit', compact('wageType'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, WageType $wageType)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255|unique:wage_types,name,' . $wageType->id,
            'active' => 'boolean',
        ]);

        $wageType->update($validated);

        return redirect()->route('admin.wage-types.index')->with('success', 'Wage Type updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(WageType $wageType)
    {
        $wageType->delete();

        return redirect()->route('admin.wage-types.index')->with('success', 'Wage Type deleted successfully.');
    }

    public function toggleStatus(WageType $wageType)
    {
        $wageType->update(['active' => !$wageType->active]);
        return response()->json(['success' => true, 'active' => (bool)$wageType->active]);
    }
}
