<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\TimeZone;
use Illuminate\Http\Request;

class TimeZoneController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $timeZones = TimeZone::latest()->paginate(100);
        return view('admin.time-zones.index', compact('timeZones'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.time-zones.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255|unique:time_zones,name',
            'active' => 'boolean',
        ]);

        TimeZone::create($validated);

        return redirect()->route('admin.time-zones.index')
            ->with('success', 'Time Zone created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(TimeZone $timeZone)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(TimeZone $timeZone)
    {
        return view('admin.time-zones.edit', compact('timeZone'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, TimeZone $timeZone)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255|unique:time_zones,name,' . $timeZone->id,
            'active' => 'boolean',
        ]);

        $timeZone->update($validated);

        return redirect()->route('admin.time-zones.index')
            ->with('success', 'Time Zone updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(TimeZone $timeZone)
    {
        $timeZone->delete();

        return redirect()->route('admin.time-zones.index')
            ->with('success', 'Time Zone deleted successfully.');
    }

    public function toggleStatus(TimeZone $timeZone)
    {
        $timeZone->update(['active' => !$timeZone->active]);
        return response()->json(['success' => true, 'active' => (bool)$timeZone->active]);
    }
}
