<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\StatHoliday;
use App\Models\Company;
use Illuminate\Http\Request;

class StatHolidayController extends Controller
{
    public function index(Request $request)
    {
        $query = StatHoliday::with('company');

        if ($request->has('company_id') && $request->company_id != '') {
            $query->where('company_id', $request->company_id);
        }

        $statHolidays = $query->latest()->paginate(100)->withQueryString();
        $companies = Company::where('active', true)->get();

        return view('admin.stat-holidays.index', compact('statHolidays', 'companies'));
    }

    public function create()
    {
        $companies = Company::where('active', true)->get();
        return view('admin.stat-holidays.create', compact('companies'));
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'company_id' => 'required|exists:companies,id',
            'name' => 'required|string|max:255',
            'holiday_date' => 'required|date',
            'multiplier' => 'required|numeric|min:0',
            'active' => 'boolean',
        ]);

        StatHoliday::create($validated);

        return redirect()->route('admin.stat-holidays.index')->with('success', 'Stat Holiday created successfully.');
    }

    public function edit(StatHoliday $statHoliday)
    {
        $companies = Company::where('active', true)->get();
        return view('admin.stat-holidays.edit', compact('statHoliday', 'companies'));
    }

    public function update(Request $request, StatHoliday $statHoliday)
    {
        $validated = $request->validate([
            'company_id' => 'required|exists:companies,id',
            'name' => 'required|string|max:255',
            'holiday_date' => 'required|date',
            'multiplier' => 'required|numeric|min:0',
            'active' => 'boolean',
        ]);

        $statHoliday->update($validated);

        return redirect()->route('admin.stat-holidays.index')->with('success', 'Stat Holiday updated successfully.');
    }

    public function destroy(StatHoliday $statHoliday)
    {
        $statHoliday->delete();
        return redirect()->route('admin.stat-holidays.index')->with('success', 'Stat Holiday deleted successfully.');
    }

    public function toggleStatus(StatHoliday $statHoliday)
    {
        $statHoliday->update(['active' => !$statHoliday->active]);
        return response()->json(['success' => true, 'active' => (bool) $statHoliday->active]);
    }
}
