<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Employee;
use App\Models\Site;
use App\Models\Schedule;
use App\Models\EmailCampaign;
use App\Models\Route as PatrolRoute;
use App\Models\EmployeeRequest;

class GlobalSearchController extends Controller
{
    public function index(Request $request)
    {
        $query = $request->input('query') ?? $request->input('q');
        $companyId = session('selected_company_id');

        if (empty($query)) {
            return redirect()->back();
        }

        $employees = Employee::where('company_id', $companyId)
            ->where(function ($q) use ($query) {
                $q->where('first_name', 'like', "%{$query}%")
                    ->orWhere('last_name', 'like', "%{$query}%")
                    ->orWhere('email', 'like', "%{$query}%")
                    ->orWhere('phone_number', 'like', "%{$query}%");
            })->limit(5)->get();

        $sites = Site::where('company_id', $companyId)
            ->where(function ($q) use ($query) {
                $q->where('name', 'like', "%{$query}%")
                    ->orWhere('address_line_1', 'like', "%{$query}%")
                    ->orWhere('address_line_2', 'like', "%{$query}%");
            })->limit(5)->get();

        // Schedules: Search by ID or Site Name
        $schedules = Schedule::where('company_id', $companyId)
            ->where(function ($q) use ($query) {
                $q->where('id', 'like', "%{$query}%");
                // Optional: Join with sites to search text
            })->with(['site', 'employee'])->limit(5)->get();

        $emails = EmailCampaign::where('company_id', $companyId)
            ->where('name', 'like', "%{$query}%")
            ->limit(5)->get();

        // Check if Route model has title or name
        // Assuming 'name'
        $routes = PatrolRoute::where('company_id', $companyId)
            ->where('name', 'like', "%{$query}%")
            ->limit(5)->get();

        $messages = EmployeeRequest::where('company_id', $companyId)
            ->where(function ($q) use ($query) {
                $q->where('subject', 'like', "%{$query}%")
                    ->orWhere('message', 'like', "%{$query}%")
                    ->orWhere('type', 'like', "%{$query}%");
            })->with('employee')->limit(5)->get();

        return view('search.results', compact('employees', 'sites', 'schedules', 'emails', 'routes', 'messages', 'query'));
    }
}
