<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\SystemLog;
use Illuminate\Http\Request;

class SystemLogController extends Controller
{
    public function index()
    {
        $logs = SystemLog::orderBy('created_at', 'desc')->paginate(100);
        return view('admin.logs.index', compact('logs'));
    }

    public function show(SystemLog $log)
    {
        return view('admin.logs.show', compact('log'));
    }

    public function destroy(SystemLog $log)
    {
        $log->delete();
        return back()->with('success', 'Log entry deleted.');
    }

    public function clear()
    {
        SystemLog::truncate();
        return back()->with('success', 'All system logs cleared.');
    }
}
