<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Skill;
use Illuminate\Http\Request;

class SkillController extends Controller
{
    public function index()
    {
        $skills = Skill::all();
        return view('admin.skills.index', compact('skills'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'category' => 'nullable|string|max:255',
        ]);

        Skill::create([
            'name' => $request->name,
            'category' => $request->category ?? 'Diplomas, Trainings & Special Skills',
            'active' => true,
        ]);

        return back()->with('success', 'Skill created successfully');
    }

    public function update(Request $request, Skill $skill)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'category' => 'nullable|string|max:255',
        ]);

        $skill->update([
            'name' => $request->name,
            'category' => $request->category,
        ]);

        return back()->with('success', 'Skill updated successfully');
    }

    public function destroy(Skill $skill)
    {
        $skill->delete();
        return back()->with('success', 'Skill deleted successfully');
    }

    public function toggleStatus(Skill $skill)
    {
        $skill->update(['active' => !$skill->active]);
        return response()->json(['success' => true]);
    }
}
