<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\Department;
use App\Models\JobRole;
use App\Models\User;
use App\Models\Company;

class DashboardController extends Controller
{
    public function index()
    {
        // 1. MASTER Stats
        $master_stats = [
            'companies' => \App\Models\Company::count(),
            'users' => \App\Models\User::count(),
            'employees' => \App\Models\Employee::count(),
            'sites' => \App\Models\Site::count(),
            'routes' => \App\Models\Route::count(),
            'leads' => \App\Models\Lead::count(),
        ];

        // 2. MASTERS Stats
        $masters_stats = [
            'time_zones' => \App\Models\TimeZone::count(),
            'zones' => \App\Models\Zone::count(),
            'countries' => \App\Models\Country::count(),
            'states' => \App\Models\State::count(),
            'departments' => \App\Models\Department::count(),
            'positions' => \App\Models\Position::count(),
            'job_roles' => \App\Models\JobRole::count(),
            'wage_types' => \App\Models\WageType::count(),
            'uniforms' => \App\Models\Uniform::count(),
            'stat_holidays' => \App\Models\StatHoliday::count(),
            'skills' => \App\Models\Skill::count(),
            'incident_categories' => \App\Models\IncidentCategory::count(),
            'roles_permissions' => \Spatie\Permission\Models\Role::count() + \Spatie\Permission\Models\Permission::count(),
        ];

        // 3. REPORTS Stats
        $reports_stats = [
            'operational' => \App\Models\Schedule::where('status', 'completed')->count(),
            'patroller' => \App\Models\PatrollerSchedule::where('job_status', 'completed')->count(),
            'communication' => \App\Models\Notification::count(),
        ];

        // 4. EMAILS Stats
        $emails_stats = [
            'signatures' => \App\Models\EmailSignature::count(),
            'templates' => \App\Models\EmailTemplate::count(),
        ];

        // 5. SYSTEM Stats
        $system_stats = [
            'logs' => \App\Models\SystemLog::count(),
            'activity' => \App\Models\ActivityLog::count(),
        ];

        // --- GRAPH DATA ---

        // 1. Live Sites vs Active Routes
        // Sites with active schedules right now
        $liveSitesCount = \App\Models\Schedule::where('status', 'active')
            ->distinct('site_id')
            ->count();

        // Routes with active patroller schedules
        $activeRoutesCount = \App\Models\PatrollerSchedule::where('job_status', 'in_progress')
            ->distinct('route_id')
            ->count();

        // 2. Incident counts on monthly basis (last 6 months)
        $incidentData = \App\Models\Incident::selectRaw('COUNT(*) as count, MONTHNAME(created_at) as month, MONTH(created_at) as month_num')
            ->where('created_at', '>=', now()->subMonths(6))
            ->groupBy('month', 'month_num')
            ->orderBy('month_num')
            ->get();

        // 3. Ticket count according to sites on monthly basis (current month)
        $ticketDataBySite = \App\Models\PatrollerIssueTicket::with('site')
            ->selectRaw('COUNT(*) as count, site_id')
            ->where('created_at', '>=', now()->startOfMonth())
            ->groupBy('site_id')
            ->get()
            ->map(function ($item) {
                return [
                    'site_name' => $item->site->name ?? 'Unknown',
                    'count' => $item->count
                ];
            });

        return view('admin.dashboard', compact(
            'master_stats',
            'masters_stats',
            'reports_stats',
            'emails_stats',
            'system_stats',
            'liveSitesCount',
            'activeRoutesCount',
            'incidentData',
            'ticketDataBySite'
        ));
    }
}
