<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ActivityLog;
use Illuminate\Http\Request;

class ActivityLogController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $logs = ActivityLog::with('user')
            ->latest()
            ->paginate(100);

        return view('admin.activity_logs.index', compact('logs'));
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(ActivityLog $log)
    {
        $log->delete();
        return back()->with('success', 'Activity log deleted successfully.');
    }

    public function clear()
    {
        ActivityLog::truncate();
        return back()->with('success', 'All activity logs cleared successfully.');
    }
}
