<?php $__env->startSection("container"); ?>


    <div class="max-w-screen-xl mx-auto mt-20 mb-20">
        <div class="max-w-screen-xl mx-auto mt-6">
            <div class="flex items-center mt-20">
                <div class="mr-36">
                    <h1 class="text-primary-color font-black text-6xl font-source-sans-pro">The Ultimate Platform</h1>
                    <div class="mt-4 text-gray-400 leading-tight font-black text-5xl">
                        For Bloggers &amp; Publishers
                    </div>
                    <div class="flex items-center mt-8 mr-8 font-thin text-xl">
                        To Monetise their Website
                    </div>
                    <div class="mt-4 font-thin text-xl">
                        Join Hands With Links Management for an additional stream of revenue by publishing High Quality Sponsored content on your blog/Website.
                    </div>
                    <div class="flex items-center mt-4 mr-8 font-thin text-xl">
                        Sign Up Today for more details.
                    </div>
                </div>
                <div class="w-2/3">
                    <img src="/images/127.png" class="w-full">
                </div>
            </div>


            <div class="text-center mt-24 font-black text-3xl">
                <span class="text-primary-color">Join 5000+</span> Strong Bloggers <span class="text-primary-color">Club To Enjoy
    </span>
            </div>
            <div class="bg-primary-color w-20 mx-auto mt-2 h-1"></div>

            <div class="grid grid-cols-3 gap-12 mt-8 mb-8">
                <div class="bg-white shadow flex flex-col items-center p-6">
                    <svg xmlns="http://www.w3.org/2000/svg" class="w-20 h-20 text-primary-color" viewBox="0 0 576 512"><path d="M568.2 336.3c-13.12-17.81-38.14-21.66-55.93-8.469l-119.7 88.17h-120.6c-8.748 0-15.1-7.25-15.1-15.99c0-8.75 7.25-16 15.1-16h78.25c15.1 0 30.75-10.88 33.37-26.62c3.25-20-12.12-37.38-31.62-37.38H191.1c-26.1 0-53.12 9.25-74.12 26.25l-46.5 37.74L15.1 383.1C7.251 383.1 0 391.3 0 400v95.98C0 504.8 7.251 512 15.1 512h346.1c22.03 0 43.92-7.188 61.7-20.27l135.1-99.52C577.5 379.1 581.3 354.1 568.2 336.3zM279.3 175C271.7 173.9 261.7 170.3 252.9 167.1L248 165.4C235.5 160.1 221.8 167.5 217.4 179.1s2.121 26.2 14.59 30.64l4.655 1.656c8.486 3.061 17.88 6.095 27.39 8.312V232c0 13.25 10.73 24 23.98 24s24-10.75 24-24V221.6c25.27-5.723 42.88-21.85 46.1-45.72c8.688-50.05-38.89-63.66-64.42-70.95L288.4 103.1C262.1 95.64 263.6 92.42 264.3 88.31c1.156-6.766 15.3-10.06 32.21-7.391c4.938 .7813 11.37 2.547 19.65 5.422c12.53 4.281 26.21-2.312 30.52-14.84s-2.309-26.19-14.84-30.53c-7.602-2.627-13.92-4.358-19.82-5.721V24c0-13.25-10.75-24-24-24s-23.98 10.75-23.98 24v10.52C238.8 40.23 221.1 56.25 216.1 80.13C208.4 129.6 256.7 143.8 274.9 149.2l6.498 1.875c31.66 9.062 31.15 11.89 30.34 16.64C310.6 174.5 296.5 177.8 279.3 175z" fill="currentColor"></path></svg>
                    <h1 class="text-primary-color font-bold mt-3 mb-3">Continuous Revenue</h1>

                    <div class="text-gray-500 text-sm">
                        We can ensure regular flow of orders to websites with quality traffic &amp; good metrics. Ideally a bloggers can easily make upwards of $500 every month!
                    </div>

                </div>
                <div class="bg-white shadow flex flex-col items-center p-6">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512" class="w-20 h-20 text-primary-color"><path d="M272 0C289.7 0 304 14.33 304 32C304 49.67 289.7 64 272 64H256V98.45C293.5 104.2 327.7 120 355.7 143L377.4 121.4C389.9 108.9 410.1 108.9 422.6 121.4C435.1 133.9 435.1 154.1 422.6 166.6L398.5 190.8C419.7 223.3 432 262.2 432 304C432 418.9 338.9 512 224 512C109.1 512 16 418.9 16 304C16 200 92.32 113.8 192 98.45V64H176C158.3 64 144 49.67 144 32C144 14.33 158.3 0 176 0L272 0zM248 192C248 178.7 237.3 168 224 168C210.7 168 200 178.7 200 192V320C200 333.3 210.7 344 224 344C237.3 344 248 333.3 248 320V192z" fill="currentColor"></path></svg>
                    <h1 class="text-primary-color font-bold mt-3 mb-3">Secure &amp; Timely Payouts</h1>

                    <div class="text-gray-500 text-sm">
                        Unlike other platforms that have set dates for making payments, on BM publishers can request payments whenever they want. You request a payment; you get it within 24 hours.
                    </div>

                </div>
                <div class="bg-white shadow flex flex-col items-center p-6">
                    <svg xmlns="http://www.w3.org/2000/svg" class="w-20 h-20 text-primary-color" viewBox="0 0 512 512"><!--! Font Awesome Pro 6.1.1 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2022 Fonticons, Inc. --><path d="M0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM371.8 211.8C382.7 200.9 382.7 183.1 371.8 172.2C360.9 161.3 343.1 161.3 332.2 172.2L224 280.4L179.8 236.2C168.9 225.3 151.1 225.3 140.2 236.2C129.3 247.1 129.3 264.9 140.2 275.8L204.2 339.8C215.1 350.7 232.9 350.7 243.8 339.8L371.8 211.8z" fill="currentColor"></path></svg>
                    <h1 class="text-primary-color font-bold mt-3 mb-3">High-Quality Content</h1>

                    <div class="text-gray-500 text-sm">
                        We ensure high quality SEO optimised content that further add authority to your website in front of search engines. We make no compromise with content quality.
                    </div>

                </div>
                <div class="bg-white shadow flex flex-col items-center p-6">
                    <svg xmlns="http://www.w3.org/2000/svg" class="w-20 h-20 text-primary-color" viewBox="0 0 640 512"><!--! Font Awesome Pro 6.1.1 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2022 Fonticons, Inc. --><path d="M554.9 154.5c-17.62-35.25-68.12-35.38-85.87 0c-87 174.3-84.1 165.9-84.1 181.5c0 44.13 57.25 80 128 80s127.1-35.88 127.1-80C639.1 319.9 641.4 327.3 554.9 154.5zM439.1 320l71.96-144l72.17 144H439.1zM256 336c0-16.12 1.375-8.75-85.12-181.5c-17.62-35.25-68.12-35.38-85.87 0c-87 174.3-84.1 165.9-84.1 181.5c0 44.13 57.25 80 127.1 80S256 380.1 256 336zM127.9 176L200.1 320H55.96L127.9 176zM495.1 448h-143.1V153.3C375.5 143 393.1 121.8 398.4 96h113.6c17.67 0 31.1-14.33 31.1-32s-14.33-32-31.1-32h-128.4c-14.62-19.38-37.5-32-63.62-32S270.1 12.62 256.4 32H128C110.3 32 96 46.33 96 64S110.3 96 127.1 96h113.6c5.25 25.75 22.87 47 46.37 57.25V448H144c-26.51 0-48.01 21.49-48.01 48c0 8.836 7.165 16 16 16h416c8.836 0 16-7.164 16-16C544 469.5 522.5 448 495.1 448z" fill="currentColor"></path></svg>
                    <h1 class="text-primary-color font-bold mt-3 mb-3">Instant Support </h1>

                    <div class="text-gray-500 text-sm">
                        A Publisher can accept an order or reject the same depending on what they feel is right. The platform or the admin will not do anything to take the decision away from the publisher at any time.
                    </div>

                </div>
                <div class="bg-white shadow flex flex-col items-center p-6">
                    <svg xmlns="http://www.w3.org/2000/svg" class="w-20 h-20 text-primary-color" viewBox="0 0 640 512"><!--! Font Awesome Pro 6.1.1 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2022 Fonticons, Inc. --><path d="M334.6 217.4l-30 27.49C264 282.1 217.8 256.8 202.9 240.6C176 211.2 178.1 165.7 207.3 138.9L289.1 64H282.5C224.7 64 169.1 86.95 128.2 127.8L32 128.1c-17.6 0-32 14.39-32 31.98v159.8c0 17.59 14.4 32.04 31.1 32.04l114.3-.0604l90.5 81.82c27.5 22.37 67.75 18.11 90-9.255l18.12 15.25c15.88 12.1 39.38 10.5 52.38-5.369l31.38-38.6l5.374 4.498c13.75 11 33.88 9.002 45-4.748l9.576-11.83c11.08-13.7 8.979-33.75-4.701-44.86L334.6 217.4zM608 128.1l-96-.1257c-40.98-40.96-96.56-63.88-154.5-63.88L348.9 64c-8 0-15.62 3.197-21.62 8.568L229 162.3C228.9 162.5 228.8 162.7 228.8 162.7C212 178.5 212.4 203.3 226.6 218.7c9.625 10.5 35 21.62 56.13 2.75c0-.125 .25-.125 .375-.25l80-73.1c6.5-5.871 16.62-5.496 22.62 1s5.5 16.62-1 22.62l-26.12 23.87l145.6 118.1c12.12 9.992 19.5 23.49 22.12 37.98L608 351.7c17.6 0 32-14.38 32-31.98V160.1C640 142.4 625.7 128.1 608 128.1z" fill="currentColor"></path></svg>
                    <h1 class="text-primary-color font-bold mt-3 mb-3">Decentralised Control</h1>

                    <div class="text-gray-500 text-sm">
                        At links management, its the publisher that takes the shot, unlike other platforms. You’re free to accept or reject an order you’re not comfortable with the content quality/nature.
                    </div>

                </div>
                <div class="bg-white shadow flex flex-col items-center p-6">
                    <svg xmlns="http://www.w3.org/2000/svg" class="w-20 h-20 text-primary-color" viewBox="0 0 640 512"><!--! Font Awesome Pro 6.1.1 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2022 Fonticons, Inc. --><path d="M416 176C416 78.8 322.9 0 208 0S0 78.8 0 176c0 39.57 15.62 75.96 41.67 105.4c-16.39 32.76-39.23 57.32-39.59 57.68c-2.1 2.205-2.67 5.475-1.441 8.354C1.9 350.3 4.602 352 7.66 352c38.35 0 70.76-11.12 95.74-24.04C134.2 343.1 169.8 352 208 352C322.9 352 416 273.2 416 176zM599.6 443.7C624.8 413.9 640 376.6 640 336C640 238.8 554 160 448 160c-.3145 0-.6191 .041-.9336 .043C447.5 165.3 448 170.6 448 176c0 98.62-79.68 181.2-186.1 202.5C282.7 455.1 357.1 512 448 512c33.69 0 65.32-8.008 92.85-21.98C565.2 502 596.1 512 632.3 512c3.059 0 5.76-1.725 7.02-4.605c1.229-2.879 .6582-6.148-1.441-8.354C637.6 498.7 615.9 475.3 599.6 443.7z" fill="currentColor"></path></svg>
                    <h1 class="text-primary-color font-bold mt-3 mb-3">Long Term Association</h1>

                    <div class="text-gray-500 text-sm">
                        At LM, we’re focused on building the largest ecosystem of publishers and bloggers for the long run. And we’re committed to nurturing the association with trust, reliability &amp; openness.
                    </div>

                </div>
            </div>






        </div>
    </div>
    <div class="bg-blue-100 py-20">
        <div class="max-w-screen-xl mx-auto">
            <div class="flex items-center">
                <div class="flex-1 mr-20">
                    <h2 class="text-3xl font-black text-primary-color">About Link Management</h2>
                    <div class="text-gray-700 mt-6 mb-6 leading-7">
                        Link Management is a Publisher Aggregator Platform which connects publishers and bloggers with Advertisers (Brands, Agencies and Resellers). The Platform is intended to help Publishers and Bloggers monetize their blogs/websites and open up a stable revenue stream for themselves.
                        <br><br>
                        Our vast experience of working in the Content Marketing and Link Building industry has allowed us to connect with numerous publishers and advertisers. We wanted to create a positive and trustworthy platform, which helps both publishers and advertisers mutually benefit from each other.

                    </div>
                    <div class="flex items-center space-x-2">
                        <a href="/about" class="bg-white text-primary-color font-bold px-4 py-1">About Us</a>
                        <a href="/contact" class="bg-white text-primary-color font-bold px-4 py-1">Contact Us</a>
                    </div>
                </div>
                <div class="w-2/5 flex items-end justify-end">
                    <img src="/images/124.png" class="w-5/6">
                </div>
            </div>
        </div>
    </div>


    <div class="max-w-screen-xl mx-auto">
        <div class="text-center mt-24 font-black text-3xl">
            How does the Platform <span class="text-primary-color">works for Publishers?</span>
        </div>
        <div class="bg-primary-color w-20 mx-auto mt-2 h-1"></div>

        <div class="grid grid-cols-4 gap-x-8 mt-20">
            <div class="bg-white shadow flex flex-col items-center p-8 relative">
                <div class="text-center absolute -top-5 bg-primary-color w-40 h-10 flex items-center justify-center text-white">
                    Step 1
                </div>
                <svg xmlns="http://www.w3.org/2000/svg" class="w-20 h-20 text-primary-color mt-10" viewBox="0 0 640 512"><!--! Font Awesome Pro 6.1.1 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2022 Fonticons, Inc. --><path d="M334.6 217.4l-30 27.49C264 282.1 217.8 256.8 202.9 240.6C176 211.2 178.1 165.7 207.3 138.9L289.1 64H282.5C224.7 64 169.1 86.95 128.2 127.8L32 128.1c-17.6 0-32 14.39-32 31.98v159.8c0 17.59 14.4 32.04 31.1 32.04l114.3-.0604l90.5 81.82c27.5 22.37 67.75 18.11 90-9.255l18.12 15.25c15.88 12.1 39.38 10.5 52.38-5.369l31.38-38.6l5.374 4.498c13.75 11 33.88 9.002 45-4.748l9.576-11.83c11.08-13.7 8.979-33.75-4.701-44.86L334.6 217.4zM608 128.1l-96-.1257c-40.98-40.96-96.56-63.88-154.5-63.88L348.9 64c-8 0-15.62 3.197-21.62 8.568L229 162.3C228.9 162.5 228.8 162.7 228.8 162.7C212 178.5 212.4 203.3 226.6 218.7c9.625 10.5 35 21.62 56.13 2.75c0-.125 .25-.125 .375-.25l80-73.1c6.5-5.871 16.62-5.496 22.62 1s5.5 16.62-1 22.62l-26.12 23.87l145.6 118.1c12.12 9.992 19.5 23.49 22.12 37.98L608 351.7c17.6 0 32-14.38 32-31.98V160.1C640 142.4 625.7 128.1 608 128.1z" fill="currentColor"></path></svg>
                <h2 class="text-center mt-4 mb-6 text-primary-color font-bold text-lg">
                    Sign Up And List Your Website On LM
                </h2>
                <div class="text-gray-600 text-center">
                    Once you signup &amp; submit required website details, our team run through its metrics &amp; pricing details to list it on our dashboard.
                </div>
            </div>

            <div class="bg-white shadow flex flex-col items-center p-8 relative">
                <div class="text-center absolute -top-5 bg-primary-color w-40 h-10 flex items-center justify-center text-white">
                    Step 2
                </div>
                <svg xmlns="http://www.w3.org/2000/svg" class="w-20 h-20 text-primary-color mt-10" viewBox="0 0 640 512"><!--! Font Awesome Pro 6.1.1 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2022 Fonticons, Inc. --><path d="M223.1 256c70.7 0 128-57.31 128-128s-57.3-128-128-128C153.3 0 96 57.31 96 128S153.3 256 223.1 256zM274.7 304H173.3C77.61 304 0 381.7 0 477.4C0 496.5 15.52 512 34.66 512h286.4c-1.246-5.531-1.43-11.31-.2832-17.04l14.28-71.41c1.943-9.723 6.676-18.56 13.68-25.56l45.72-45.72C363.3 322.4 321.2 304 274.7 304zM371.4 420.6c-2.514 2.512-4.227 5.715-4.924 9.203l-14.28 71.41c-1.258 6.289 4.293 11.84 10.59 10.59l71.42-14.29c3.482-.6992 6.682-2.406 9.195-4.922l125.3-125.3l-72.01-72.01L371.4 420.6zM629.5 255.7l-21.1-21.11c-14.06-14.06-36.85-14.06-50.91 0l-38.13 38.14l72.01 72.01l38.13-38.13C643.5 292.5 643.5 269.7 629.5 255.7z" fill="currentColor"></path></svg>
                <h2 class="text-center mt-4 mb-6 text-primary-color font-bold text-lg">
                    Start Receiving Orders Details
                </h2>
                <div class="text-gray-600 text-center">
                    Our team submits the order details that you can access through your dashbaord for further action &amp; publishing, each time we find a relevant order to push. You get notified in your email as well.
                </div>
            </div>


            <div class="bg-white shadow flex flex-col items-center p-8 relative">
                <div class="text-center absolute -top-5 bg-primary-color w-40 h-10 flex items-center justify-center text-white">
                    Step 3
                </div>
                <svg xmlns="http://www.w3.org/2000/svg" class="w-20 h-20 text-primary-color mt-10" viewBox="0 0 640 512"><!--! Font Awesome Pro 6.1.1 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2022 Fonticons, Inc. --><path d="M172.5 131.1C228.1 75.51 320.5 75.51 376.1 131.1C426.1 181.1 433.5 260.8 392.4 318.3L391.3 319.9C381 334.2 361 337.6 346.7 327.3C332.3 317 328.9 297 339.2 282.7L340.3 281.1C363.2 249 359.6 205.1 331.7 177.2C300.3 145.8 249.2 145.8 217.7 177.2L105.5 289.5C73.99 320.1 73.99 372 105.5 403.5C133.3 431.4 177.3 435 209.3 412.1L210.9 410.1C225.3 400.7 245.3 404 255.5 418.4C265.8 432.8 262.5 452.8 248.1 463.1L246.5 464.2C188.1 505.3 110.2 498.7 60.21 448.8C3.741 392.3 3.741 300.7 60.21 244.3L172.5 131.1zM467.5 380C411 436.5 319.5 436.5 263 380C213 330 206.5 251.2 247.6 193.7L248.7 192.1C258.1 177.8 278.1 174.4 293.3 184.7C307.7 194.1 311.1 214.1 300.8 229.3L299.7 230.9C276.8 262.1 280.4 306.9 308.3 334.8C339.7 366.2 390.8 366.2 422.3 334.8L534.5 222.5C566 191 566 139.1 534.5 108.5C506.7 80.63 462.7 76.99 430.7 99.9L429.1 101C414.7 111.3 394.7 107.1 384.5 93.58C374.2 79.2 377.5 59.21 391.9 48.94L393.5 47.82C451 6.731 529.8 13.25 579.8 63.24C636.3 119.7 636.3 211.3 579.8 267.7L467.5 380z" fill="currentColor"></path></svg>
                <h2 class="text-center mt-4 mb-6 text-primary-color font-bold text-lg">
                    Share The Live URL On Your Dashboard
                </h2>
                <div class="text-gray-600 text-center">
                    On successful publishing, you need to close the order by submitting the Live URL on the dashboard. We’ll evaluate and review for quality assurance &amp; subsequent payment approval.
                </div>
            </div>

            <div class="bg-white shadow flex flex-col items-center p-8 relative">
                <div class="text-center absolute -top-5 bg-primary-color w-40 h-10 flex items-center justify-center text-white">
                    Step 4
                </div>
                <svg xmlns="http://www.w3.org/2000/svg" class="w-20 h-20 text-primary-color mt-10" viewBox="0 0 576 512"><path d="M568.2 336.3c-13.12-17.81-38.14-21.66-55.93-8.469l-119.7 88.17h-120.6c-8.748 0-15.1-7.25-15.1-15.99c0-8.75 7.25-16 15.1-16h78.25c15.1 0 30.75-10.88 33.37-26.62c3.25-20-12.12-37.38-31.62-37.38H191.1c-26.1 0-53.12 9.25-74.12 26.25l-46.5 37.74L15.1 383.1C7.251 383.1 0 391.3 0 400v95.98C0 504.8 7.251 512 15.1 512h346.1c22.03 0 43.92-7.188 61.7-20.27l135.1-99.52C577.5 379.1 581.3 354.1 568.2 336.3zM279.3 175C271.7 173.9 261.7 170.3 252.9 167.1L248 165.4C235.5 160.1 221.8 167.5 217.4 179.1s2.121 26.2 14.59 30.64l4.655 1.656c8.486 3.061 17.88 6.095 27.39 8.312V232c0 13.25 10.73 24 23.98 24s24-10.75 24-24V221.6c25.27-5.723 42.88-21.85 46.1-45.72c8.688-50.05-38.89-63.66-64.42-70.95L288.4 103.1C262.1 95.64 263.6 92.42 264.3 88.31c1.156-6.766 15.3-10.06 32.21-7.391c4.938 .7813 11.37 2.547 19.65 5.422c12.53 4.281 26.21-2.312 30.52-14.84s-2.309-26.19-14.84-30.53c-7.602-2.627-13.92-4.358-19.82-5.721V24c0-13.25-10.75-24-24-24s-23.98 10.75-23.98 24v10.52C238.8 40.23 221.1 56.25 216.1 80.13C208.4 129.6 256.7 143.8 274.9 149.2l6.498 1.875c31.66 9.062 31.15 11.89 30.34 16.64C310.6 174.5 296.5 177.8 279.3 175z" fill="currentColor"></path></svg>
                <h2 class="text-center mt-4 mb-6 text-primary-color font-bold text-lg">
                    Request Payment Withdrawl

                </h2>
                <div class="text-gray-600 text-center">
                    You can request for payment withdrawl using your preferred payment method, you will see the order amount reflect on your Wallet. The payment will be processed on weekly basis.
                </div>
            </div>
        </div>

        <div class="flex items-center justify-center mt-8 mb-8">
            <a href="/register" class="px-5 py-2 bg-primary-color text-white">Submit your website</a>
        </div>

        <div class="text-center mt-16 font-black text-3xl">
            <span class="text-primary-color">Feedbacks </span>from our Publishers on Blog Management
        </div>
        <div class="bg-primary-color w-20 mx-auto mt-2 h-1"></div>


        <div class="mb-36">
            <div class="feedback slick-initialized slick-slider slick-dotted">
                <div class="slick-list draggable"><div class="slick-track" style="opacity: 1; width: 6400px; transform: translate3d(-3200px, 0px, 0px);"><div class="bg-white p-6 mr-12 shadow mt-12 slick-slide slick-cloned" data-slick-index="-2" id="" aria-hidden="true" tabindex="-1" style="width: 592px;">
                            <div class="flex items-center justify-between">
                                <div class="flex items-center">
                                    <div class="w-24 h-24 rounded-full bg-primary-color"> </div>
                                    <div class="ml-6">
                                        <h2>Sagar</h2>
                                        <h2>Social Media Magazine</h2>
                                    </div>
                                </div>
                                <div class="flex space-x-2">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                </div>
                            </div>
                            <div class="text-gray-700 text-sm mt-6">
                                I was hesitant of joining a platform that works through
                                Dashboards. I was more familiar with doing things over
                                email. However, the Support team took me over every small
                                detail and showed me why it is more convenient and easier.
                                Now I can track all the orders and earnings I have made.

                            </div>
                        </div><div class="bg-white p-6 mr-12 shadow mt-12 slick-slide slick-cloned" data-slick-index="-1" id="" aria-hidden="true" tabindex="-1" style="width: 592px;">
                            <div class="flex items-center justify-between">
                                <div class="flex items-center">
                                    <div class="w-24 h-24 rounded-full bg-primary-color"> </div>
                                    <div class="ml-6">
                                        <h2>Sagar</h2>
                                        <h2>Social Media Magazine</h2>
                                    </div>
                                </div>
                                <div class="flex space-x-2">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                </div>
                            </div>
                            <div class="text-gray-700 text-sm mt-6">
                                I was hesitant of joining a platform that works through
                                Dashboards. I was more familiar with doing things over
                                email. However, the Support team took me over every small
                                detail and showed me why it is more convenient and easier.
                                Now I can track all the orders and earnings I have made.

                            </div>
                        </div><div class="bg-white p-6 mr-12 shadow mt-12 slick-slide" data-slick-index="0" aria-hidden="true" tabindex="-1" role="tabpanel" id="slick-slide00" aria-describedby="slick-slide-control00" style="width: 592px;">
                            <div class="flex items-center justify-between">
                                <div class="flex items-center">
                                    <div class="w-24 h-24 rounded-full bg-primary-color"> </div>
                                    <div class="ml-6">
                                        <h2>Sagar</h2>
                                        <h2>Social Media Magazine</h2>
                                    </div>
                                </div>
                                <div class="flex space-x-2">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                </div>
                            </div>
                            <div class="text-gray-700 text-sm mt-6">
                                I was hesitant of joining a platform that works through
                                Dashboards. I was more familiar with doing things over
                                email. However, the Support team took me over every small
                                detail and showed me why it is more convenient and easier.
                                Now I can track all the orders and earnings I have made.

                            </div>
                        </div><div class="bg-white p-6 mr-12 shadow mt-12 slick-slide" data-slick-index="1" aria-hidden="true" tabindex="-1" role="tabpanel" id="slick-slide01" aria-describedby="slick-slide-control01" style="width: 592px;">
                            <div class="flex items-center justify-between">
                                <div class="flex items-center">
                                    <div class="w-24 h-24 rounded-full bg-primary-color"> </div>
                                    <div class="ml-6">
                                        <h2>Sagar</h2>
                                        <h2>Social Media Magazine</h2>
                                    </div>
                                </div>
                                <div class="flex space-x-2">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                </div>
                            </div>
                            <div class="text-gray-700 text-sm mt-6">
                                I was hesitant of joining a platform that works through
                                Dashboards. I was more familiar with doing things over
                                email. However, the Support team took me over every small
                                detail and showed me why it is more convenient and easier.
                                Now I can track all the orders and earnings I have made.

                            </div>
                        </div><div class="bg-white p-6 mr-12 shadow mt-12 slick-slide" data-slick-index="2" aria-hidden="true" tabindex="-1" role="tabpanel" id="slick-slide02" aria-describedby="slick-slide-control02" style="width: 592px;">
                            <div class="flex items-center justify-between">
                                <div class="flex items-center">
                                    <div class="w-24 h-24 rounded-full bg-primary-color"> </div>
                                    <div class="ml-6">
                                        <h2>Sagar</h2>
                                        <h2>Social Media Magazine</h2>
                                    </div>
                                </div>
                                <div class="flex space-x-2">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                </div>
                            </div>
                            <div class="text-gray-700 text-sm mt-6">
                                I was hesitant of joining a platform that works through
                                Dashboards. I was more familiar with doing things over
                                email. However, the Support team took me over every small
                                detail and showed me why it is more convenient and easier.
                                Now I can track all the orders and earnings I have made.

                            </div>
                        </div><div class="bg-white p-6 mr-12 shadow mt-12 slick-slide slick-current slick-active" data-slick-index="3" aria-hidden="false" tabindex="0" role="tabpanel" id="slick-slide03" aria-describedby="slick-slide-control03" style="width: 592px;">
                            <div class="flex items-center justify-between">
                                <div class="flex items-center">
                                    <div class="w-24 h-24 rounded-full bg-primary-color"> </div>
                                    <div class="ml-6">
                                        <h2>Sagar</h2>
                                        <h2>Social Media Magazine</h2>
                                    </div>
                                </div>
                                <div class="flex space-x-2">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                </div>
                            </div>
                            <div class="text-gray-700 text-sm mt-6">
                                I was hesitant of joining a platform that works through
                                Dashboards. I was more familiar with doing things over
                                email. However, the Support team took me over every small
                                detail and showed me why it is more convenient and easier.
                                Now I can track all the orders and earnings I have made.

                            </div>
                        </div><div class="bg-white p-6 mr-12 shadow mt-12 slick-slide slick-cloned slick-active" data-slick-index="4" id="" aria-hidden="false" tabindex="-1" style="width: 592px;">
                            <div class="flex items-center justify-between">
                                <div class="flex items-center">
                                    <div class="w-24 h-24 rounded-full bg-primary-color"> </div>
                                    <div class="ml-6">
                                        <h2>Sagar</h2>
                                        <h2>Social Media Magazine</h2>
                                    </div>
                                </div>
                                <div class="flex space-x-2">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                </div>
                            </div>
                            <div class="text-gray-700 text-sm mt-6">
                                I was hesitant of joining a platform that works through
                                Dashboards. I was more familiar with doing things over
                                email. However, the Support team took me over every small
                                detail and showed me why it is more convenient and easier.
                                Now I can track all the orders and earnings I have made.

                            </div>
                        </div><div class="bg-white p-6 mr-12 shadow mt-12 slick-slide slick-cloned" data-slick-index="5" id="" aria-hidden="true" tabindex="-1" style="width: 592px;">
                            <div class="flex items-center justify-between">
                                <div class="flex items-center">
                                    <div class="w-24 h-24 rounded-full bg-primary-color"> </div>
                                    <div class="ml-6">
                                        <h2>Sagar</h2>
                                        <h2>Social Media Magazine</h2>
                                    </div>
                                </div>
                                <div class="flex space-x-2">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                </div>
                            </div>
                            <div class="text-gray-700 text-sm mt-6">
                                I was hesitant of joining a platform that works through
                                Dashboards. I was more familiar with doing things over
                                email. However, the Support team took me over every small
                                detail and showed me why it is more convenient and easier.
                                Now I can track all the orders and earnings I have made.

                            </div>
                        </div><div class="bg-white p-6 mr-12 shadow mt-12 slick-slide slick-cloned" data-slick-index="6" id="" aria-hidden="true" tabindex="-1" style="width: 592px;">
                            <div class="flex items-center justify-between">
                                <div class="flex items-center">
                                    <div class="w-24 h-24 rounded-full bg-primary-color"> </div>
                                    <div class="ml-6">
                                        <h2>Sagar</h2>
                                        <h2>Social Media Magazine</h2>
                                    </div>
                                </div>
                                <div class="flex space-x-2">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                </div>
                            </div>
                            <div class="text-gray-700 text-sm mt-6">
                                I was hesitant of joining a platform that works through
                                Dashboards. I was more familiar with doing things over
                                email. However, the Support team took me over every small
                                detail and showed me why it is more convenient and easier.
                                Now I can track all the orders and earnings I have made.

                            </div>
                        </div><div class="bg-white p-6 mr-12 shadow mt-12 slick-slide slick-cloned" data-slick-index="7" id="" aria-hidden="true" tabindex="-1" style="width: 592px;">
                            <div class="flex items-center justify-between">
                                <div class="flex items-center">
                                    <div class="w-24 h-24 rounded-full bg-primary-color"> </div>
                                    <div class="ml-6">
                                        <h2>Sagar</h2>
                                        <h2>Social Media Magazine</h2>
                                    </div>
                                </div>
                                <div class="flex space-x-2">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" class="w-6 h-6 text-yellow-400"><path d="M381.2 150.3L524.9 171.5C536.8 173.2 546.8 181.6 550.6 193.1C554.4 204.7 551.3 217.3 542.7 225.9L438.5 328.1L463.1 474.7C465.1 486.7 460.2 498.9 450.2 506C440.3 513.1 427.2 514 416.5 508.3L288.1 439.8L159.8 508.3C149 514 135.9 513.1 126 506C116.1 498.9 111.1 486.7 113.2 474.7L137.8 328.1L33.58 225.9C24.97 217.3 21.91 204.7 25.69 193.1C29.46 181.6 39.43 173.2 51.42 171.5L195 150.3L259.4 17.97C264.7 6.954 275.9-.0391 288.1-.0391C300.4-.0391 311.6 6.954 316.9 17.97L381.2 150.3z" fill="currentColor"></path></svg>
                                </div>
                            </div>
                            <div class="text-gray-700 text-sm mt-6">
                                I was hesitant of joining a platform that works through
                                Dashboards. I was more familiar with doing things over
                                email. However, the Support team took me over every small
                                detail and showed me why it is more convenient and easier.
                                Now I can track all the orders and earnings I have made.

                            </div>
                        </div></div></div>



                <ul class="slick-dots" style="" role="tablist"><li class="" role="presentation"><button type="button" role="tab" id="slick-slide-control00" aria-controls="slick-slide00" aria-label="1 of 2" tabindex="-1">1</button></li><li role="presentation" class=""><button type="button" role="tab" id="slick-slide-control01" aria-controls="slick-slide01" aria-label="2 of 2" tabindex="-1">2</button></li><li role="presentation" class=""><button type="button" role="tab" id="slick-slide-control02" aria-controls="slick-slide02" aria-label="3 of 2" tabindex="-1">3</button></li><li role="presentation" class="slick-active"><button type="button" role="tab" id="slick-slide-control03" aria-controls="slick-slide03" aria-label="4 of 2" tabindex="0" aria-selected="true">4</button></li></ul></div>
        </div>



        <div id="contact" class="flex items-start mb-12">
            <div class="w-2/5">
                <div class="text-left mt-16 font-black text-3xl">
                    <span class="text-primary-color">Get In Touch </span>With Us
                </div>

                <div class="text-gray-600 mt-6 leading-10">
                    Fill in the Contact Form &amp; our team will reach out to you within 24-48 hours to help with your smooth onboarding, or to address any concerns that you may have.
                </div>

            </div>
            <div class="w-3/5 mt-16">
                <div class="bg-white p-8 ml-16 shadow-2xl shadow-blue-300">
                    <form action="/contact" method="POST">
                       <?php echo csrf_field(); ?>
                        <div class="grid grid-cols-2 gap-8">
                            <div>
                                <input type="text" name="name" class="px-4 py-4 bg-gray-100 border border-gray-200 w-full focus:ring-0" placeholder="Name">
                            </div>
                            <div>
                                <select class="px-4 py-4 bg-gray-100 border border-gray-200 w-full focus:ring-0" name="subject">
                                    <option value="">Choose Subject</option>
                                    <option value="account">Account</option>
                                    <option value="site">Site</option>
                                    <option value="wallet">Wallet</option>
                                </select>
                            </div>
                            <div>
                                <input type="text" name="email" class="px-4 py-4 bg-gray-100 border border-gray-200 w-full focus:ring-0" placeholder="Email ID">
                            </div>
                            <div>
                                <input type="text" name="phone" class="px-4 py-4 bg-gray-100 border border-gray-200 w-full focus:ring-0" placeholder="Phone">
                            </div>
                            <div class="col-span-2">
                                <textarea rows="6" name="message" class="px-4 py-4 bg-gray-100 border border-gray-200 w-full focus:ring-0" placeholder="Your Message here"></textarea>
                            </div>
                            <div class="col-span-2">
                                <button class="bg-primary-color text-white w-full py-3">Send Message</button>
                            </div>
                        </div>


                    </form>
                </div>
            </div>

        </div>


        <div class="text-center mt-36 font-black text-3xl">
            <span class="text-primary-color">Join 5000+</span> Strong Bloggers <span class="text-primary-color">Club To Enjoy
        </span></div>
        <div class="bg-primary-color w-20 mx-auto mt-2 h-1"></div>

        <div class="companies mt-16 slick-initialized slick-slider slick-dotted">
            <div class="slick-list draggable"><div class="slick-track" style="opacity: 1; width: 6420px; transform: translate3d(-1926px, 0px, 0px);"><div class="mr-8 slick-slide slick-cloned" data-slick-index="-6" id="" aria-hidden="true" tabindex="-1" style="width: 182px;">
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500 mb-8"><img src="/images/logos/1.png"></div>
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500"><img src="/images/logos/2.png"></div>
                    </div><div class="mr-8 slick-slide slick-cloned" data-slick-index="-5" id="" aria-hidden="true" tabindex="-1" style="width: 182px;">
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500 mb-8"><img src="/images/logos/3.png"></div>
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500"><img src="/images/logos/4.png"></div>
                    </div><div class="mr-8 slick-slide slick-cloned" data-slick-index="-4" id="" aria-hidden="true" tabindex="-1" style="width: 182px;">
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500 mb-8"><img src="/images/logos/5.png"></div>
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500"><img src="/images/logos/6.png"></div>
                    </div><div class="mr-8 slick-slide slick-cloned" data-slick-index="-3" id="" aria-hidden="true" tabindex="-1" style="width: 182px;">
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500 mb-8"><img src="/images/logos/4.png"></div>
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500"><img src="/images/logos/5.png"></div>
                    </div><div class="mr-8 slick-slide slick-cloned" data-slick-index="-2" id="" aria-hidden="true" tabindex="-1" style="width: 182px;">
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500 mb-8"><img src="/images/logos/6.png"></div>
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500"><img src="/images/logos/1.png"></div>
                    </div><div class="mr-8 slick-slide slick-cloned" data-slick-index="-1" id="" aria-hidden="true" tabindex="-1" style="width: 182px;">
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500 mb-8"><img src="/images/logos/2.png"></div>
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500"><img src="/images/logos/3.png"></div>
                    </div><div class="mr-8 slick-slide" data-slick-index="0" aria-hidden="true" tabindex="-1" role="tabpanel" id="slick-slide10" aria-describedby="slick-slide-control10" style="width: 182px;">
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500 mb-8"><img src="/images/logos/1.png"></div>
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500"><img src="/images/logos/2.png"></div>
                    </div><div class="mr-8 slick-slide" data-slick-index="1" aria-hidden="true" tabindex="-1" role="tabpanel" id="slick-slide11" aria-describedby="slick-slide-control11" style="width: 182px;">
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500 mb-8"><img src="/images/logos/3.png"></div>
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500"><img src="/images/logos/4.png"></div>
                    </div><div class="mr-8 slick-slide" data-slick-index="2" aria-hidden="true" tabindex="-1" role="tabpanel" id="slick-slide12" aria-describedby="slick-slide-control12" style="width: 182px;">
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500 mb-8"><img src="/images/logos/5.png"></div>
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500"><img src="/images/logos/6.png"></div>
                    </div><div class="mr-8 slick-slide slick-current slick-active" data-slick-index="3" aria-hidden="false" tabindex="0" role="tabpanel" id="slick-slide13" aria-describedby="slick-slide-control13" style="width: 182px;">
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500 mb-8"><img src="/images/logos/4.png"></div>
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500"><img src="/images/logos/5.png"></div>
                    </div><div class="mr-8 slick-slide slick-active" data-slick-index="4" aria-hidden="false" tabindex="0" role="tabpanel" id="slick-slide14" aria-describedby="slick-slide-control14" style="width: 182px;">
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500 mb-8"><img src="/images/logos/6.png"></div>
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500"><img src="/images/logos/1.png"></div>
                    </div><div class="mr-8 slick-slide slick-active" data-slick-index="5" aria-hidden="false" tabindex="0" role="tabpanel" id="slick-slide15" aria-describedby="slick-slide-control15" style="width: 182px;">
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500 mb-8"><img src="/images/logos/2.png"></div>
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500"><img src="/images/logos/3.png"></div>
                    </div><div class="mr-8 slick-slide slick-active" data-slick-index="6" aria-hidden="false" tabindex="0" role="tabpanel" id="slick-slide16" aria-describedby="slick-slide-control16" style="width: 182px;">
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500 mb-8"><img src="/images/logos/1.png"></div>
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500"><img src="/images/logos/2.png"></div>
                    </div><div class="mr-8 slick-slide slick-active" data-slick-index="7" aria-hidden="false" tabindex="0" role="tabpanel" id="slick-slide17" aria-describedby="slick-slide-control17" style="width: 182px;">
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500 mb-8"><img src="/images/logos/3.png"></div>
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500"><img src="/images/logos/4.png"></div>
                    </div><div class="mr-8 slick-slide slick-active" data-slick-index="8" aria-hidden="false" tabindex="0" role="tabpanel" id="slick-slide18" aria-describedby="slick-slide-control18" style="width: 182px;">
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500 mb-8"><img src="/images/logos/5.png"></div>
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500"><img src="/images/logos/6.png"></div>
                    </div><div class="mr-8 slick-slide" data-slick-index="9" aria-hidden="true" tabindex="-1" role="tabpanel" id="slick-slide19" aria-describedby="slick-slide-control19" style="width: 182px;">
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500 mb-8"><img src="/images/logos/4.png"></div>
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500"><img src="/images/logos/5.png"></div>
                    </div><div class="mr-8 slick-slide" data-slick-index="10" aria-hidden="true" tabindex="-1" role="tabpanel" id="slick-slide110" aria-describedby="slick-slide-control110" style="width: 182px;">
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500 mb-8"><img src="/images/logos/6.png"></div>
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500"><img src="/images/logos/1.png"></div>
                    </div><div class="mr-8 slick-slide" data-slick-index="11" aria-hidden="true" tabindex="-1" role="tabpanel" id="slick-slide111" aria-describedby="slick-slide-control111" style="width: 182px;">
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500 mb-8"><img src="/images/logos/2.png"></div>
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500"><img src="/images/logos/3.png"></div>
                    </div><div class="mr-8 slick-slide slick-cloned" data-slick-index="12" id="" aria-hidden="true" tabindex="-1" style="width: 182px;">
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500 mb-8"><img src="/images/logos/1.png"></div>
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500"><img src="/images/logos/2.png"></div>
                    </div><div class="mr-8 slick-slide slick-cloned" data-slick-index="13" id="" aria-hidden="true" tabindex="-1" style="width: 182px;">
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500 mb-8"><img src="/images/logos/3.png"></div>
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500"><img src="/images/logos/4.png"></div>
                    </div><div class="mr-8 slick-slide slick-cloned" data-slick-index="14" id="" aria-hidden="true" tabindex="-1" style="width: 182px;">
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500 mb-8"><img src="/images/logos/5.png"></div>
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500"><img src="/images/logos/6.png"></div>
                    </div><div class="mr-8 slick-slide slick-cloned" data-slick-index="15" id="" aria-hidden="true" tabindex="-1" style="width: 182px;">
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500 mb-8"><img src="/images/logos/4.png"></div>
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500"><img src="/images/logos/5.png"></div>
                    </div><div class="mr-8 slick-slide slick-cloned" data-slick-index="16" id="" aria-hidden="true" tabindex="-1" style="width: 182px;">
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500 mb-8"><img src="/images/logos/6.png"></div>
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500"><img src="/images/logos/1.png"></div>
                    </div><div class="mr-8 slick-slide slick-cloned" data-slick-index="17" id="" aria-hidden="true" tabindex="-1" style="width: 182px;">
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500 mb-8"><img src="/images/logos/2.png"></div>
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500"><img src="/images/logos/3.png"></div>
                    </div><div class="mr-8 slick-slide slick-cloned" data-slick-index="18" id="" aria-hidden="true" tabindex="-1" style="width: 182px;">
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500 mb-8"><img src="/images/logos/1.png"></div>
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500"><img src="/images/logos/2.png"></div>
                    </div><div class="mr-8 slick-slide slick-cloned" data-slick-index="19" id="" aria-hidden="true" tabindex="-1" style="width: 182px;">
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500 mb-8"><img src="/images/logos/3.png"></div>
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500"><img src="/images/logos/4.png"></div>
                    </div><div class="mr-8 slick-slide slick-cloned" data-slick-index="20" id="" aria-hidden="true" tabindex="-1" style="width: 182px;">
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500 mb-8"><img src="/images/logos/5.png"></div>
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500"><img src="/images/logos/6.png"></div>
                    </div><div class="mr-8 slick-slide slick-cloned" data-slick-index="21" id="" aria-hidden="true" tabindex="-1" style="width: 182px;">
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500 mb-8"><img src="/images/logos/4.png"></div>
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500"><img src="/images/logos/5.png"></div>
                    </div><div class="mr-8 slick-slide slick-cloned" data-slick-index="22" id="" aria-hidden="true" tabindex="-1" style="width: 182px;">
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500 mb-8"><img src="/images/logos/6.png"></div>
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500"><img src="/images/logos/1.png"></div>
                    </div><div class="mr-8 slick-slide slick-cloned" data-slick-index="23" id="" aria-hidden="true" tabindex="-1" style="width: 182px;">
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500 mb-8"><img src="/images/logos/2.png"></div>
                        <div class="bg-white shadow p-8 grayscale hover:grayscale-0 transition-all duration-500"><img src="/images/logos/3.png"></div>
                    </div></div></div>











            <ul class="slick-dots" style="" role="tablist"><li class="" role="presentation"><button type="button" role="tab" id="slick-slide-control10" aria-controls="slick-slide10" aria-label="1 of 2" tabindex="-1">1</button></li><li role="presentation" class=""><button type="button" role="tab" id="slick-slide-control11" aria-controls="slick-slide11" aria-label="2 of 2" tabindex="-1">2</button></li><li role="presentation" class=""><button type="button" role="tab" id="slick-slide-control12" aria-controls="slick-slide12" aria-label="3 of 2" tabindex="-1">3</button></li><li role="presentation" class="slick-active"><button type="button" role="tab" id="slick-slide-control13" aria-controls="slick-slide13" aria-label="4 of 2" tabindex="0" aria-selected="true">4</button></li><li role="presentation" class=""><button type="button" role="tab" id="slick-slide-control14" aria-controls="slick-slide14" aria-label="5 of 2" tabindex="-1">5</button></li><li role="presentation" class=""><button type="button" role="tab" id="slick-slide-control15" aria-controls="slick-slide15" aria-label="6 of 2" tabindex="-1">6</button></li><li role="presentation" class=""><button type="button" role="tab" id="slick-slide-control16" aria-controls="slick-slide16" aria-label="7 of 2" tabindex="-1">7</button></li><li role="presentation" class=""><button type="button" role="tab" id="slick-slide-control17" aria-controls="slick-slide17" aria-label="8 of 2" tabindex="-1">8</button></li><li role="presentation" class=""><button type="button" role="tab" id="slick-slide-control18" aria-controls="slick-slide18" aria-label="9 of 2" tabindex="-1">9</button></li><li role="presentation" class=""><button type="button" role="tab" id="slick-slide-control19" aria-controls="slick-slide19" aria-label="10 of 2" tabindex="-1">10</button></li><li role="presentation" class=""><button type="button" role="tab" id="slick-slide-control110" aria-controls="slick-slide110" aria-label="11 of 2" tabindex="-1">11</button></li><li role="presentation" class=""><button type="button" role="tab" id="slick-slide-control111" aria-controls="slick-slide111" aria-label="12 of 2" tabindex="-1">12</button></li></ul></div>

        <div class="mt-20"></div>














































    </div>



<?php $__env->stopSection(); ?>



<?php echo $__env->make("frontend.layouts.master", array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/truetransit/public_html/linkmanagement.net/resources/views/frontend/home/index.blade.php ENDPATH**/ ?>