<?php use App\Models\Career; ?>


<?php $__env->startSection("container"); ?>
<?php
    $careers= Career::where('active',1)->get();
?>

<div class="">
    <div class="bg-white p-6 mt-4">

        <div class="flex items-end justify-center">
            <div class="text-center mt-6 font-black text-3xl">
                <span class="text-primary-color">Jobs</span> List
            </div>
            <div class="ml-2 bg-black mb-2 h-1 w-24"></div>
        </div>


        <div class="mb-8 mt-8">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                <?php $__currentLoopData = $careers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $career): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="bg-gray-100 p-6 shadow">
                        <h2 class="text-gray-700 text-lg font-medium tracking-tighter"><?php echo e($career->title); ?></h2>
                        <div class="h-0.5 bg-gray-200/50 w-full mt-2"></div>
                        <div class="grid grid-cols-2 mt-6">
                            <div>
                                <p class="text-sm font-medium primary_color">Required Experience</p>
                                <div class="text-gray-700 text-xs font-medium mt-1"><?php echo e($career->experience); ?></div>
                            </div>
                            <div >
                                <p class="text-sm font-medium primary_color">Qualification:	</p>
                                <div class="text-gray-700 text-xs font-medium mt-1"><?php echo e($career->qualification); ?></div>
                            </div>
                        </div>
                        <div class="mt-6">
                            <p class="text-sm font-medium primary_color">Required Skills</p>
                            <div class="text-gray-700 text-xs font-medium mt-1"><?php echo e($career->skills); ?></div>
                        </div>
                        <div class="mt-6 flex items-center justify-center">
                            <a href="<?php echo e(route("submit_profile",$career->id)); ?>" class="bg_primary_color shadow rounded-full text-xs text-white tracking-tighter px-6 py-2">Apply Now</a>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("frontend.layouts.master", array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/truetransit/public_html/linkmanagement.net/resources/views/frontend/careers/index.blade.php ENDPATH**/ ?>