<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>Link Management</title>

    <link rel="stylesheet" type="text/css" href="/lib/slick/slick.css"/>
    <link rel="stylesheet" type="text/css" href="/lib/slick/slick-theme.css"/>
    <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.0/dist/jquery.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js"></script>
    <?php echo app('Illuminate\Foundation\Vite')('resources/css/app.css'); ?>
</head>

<body class="font-sans antialiased bg-gray-100">
<div class="max-w-screen-xl mx-auto mt-6">
    <div class="flex items-center justify-between">
        <a href="/">
            <img src="/images/logo1.jpeg" class="w-36">
        </a>
        <div class="flex space-x-12 items-center">
            <a href="<?php echo e(route("homepage")); ?>" class="text-gray-600 hover:text-primary-color <?php if(request()->routeIs("homepage") ): ?> text-primary-color font-semibold <?php endif; ?>">Home</a>
            <a href="<?php echo e(route("about")); ?>" class="text-gray-600 hover:text-primary-color <?php if(request()->routeIs("about") ): ?> text-primary-color font-semibold <?php endif; ?>">About Us</a>
            <a href="<?php echo e(route("careers")); ?>" class="text-gray-600 hover:text-primary-color <?php if(request()->routeIs("careers") ): ?> text-primary-color font-semibold <?php endif; ?>">Careers</a>
            <a href="<?php echo e(route("faqs")); ?>" class="text-gray-600 hover:text-primary-color <?php if(request()->routeIs("faqs") ): ?> text-primary-color font-semibold <?php endif; ?>">Faqs</a>
            <a href="<?php echo e(route("videos")); ?>" class="text-gray-600 hover:text-primary-color <?php if(request()->routeIs("videos") ): ?> text-primary-color font-semibold <?php endif; ?>">Videos</a>
            <a href="<?php echo e(route("contact")); ?>" class="text-gray-600 hover:text-primary-color <?php if(request()->routeIs("contact") ): ?> text-primary-color font-semibold <?php endif; ?>">Contact</a>
            <a href="/blogger/login" class="text-gray-600 hover:text-primary-color <?php if(request()->routeIs("login") ): ?> text-primary-color font-semibold <?php endif; ?>">Login</a>
            <a href="<?php echo e(route("register")); ?>" class="bg-orange-100 border border-orange-200 text-primary-color uppercase font-bold px-4 py-2">Signup</a>
        </div>
    </div>
</div>

<div class="max-w-screen-xl mx-auto mt-20 mb-20">
<?php echo $__env->yieldContent("container"); ?>
</div>

<div class="bg-footer-color p-8">
    <div class="max-w-screen-xl mx-auto">
        <div class="grid grid-cols-3 gap-x-16">
            <div>
                <div class="flex items-center mt-6">
                    <span class="text-white text-lg font-bold">About Us</span>
                    <div class="ml-2 bg-primary-color h-1 w-24"></div>
                </div>

                <div class="text-gray-400 text-lg mt-4">
                    Link Management is a Publisher Aggregator Platform which connects publishers and bloggers with Advertisers (Brands, Agencies and Resellers). The Platform is intended to help Publishers and Bloggers monetize their blogs/websites and open up a stable revenue stream for themselves.

                </div>

            </div>

            <div>
                <div class="flex items-center mt-6">
                    <span class="text-white text-lg font-bold">Useful Links</span>
                    <div class="ml-2 bg-primary-color h-1 w-24"></div>
                </div>

                <div class="flex flex-col mt-4">
                    <a href="http://127.0.0.1:3000" class="hover:translate-x-2 transition-all duration-300 origin-top-left text-gray-400 mb-3">Home</a>
                    <a href="http://127.0.0.1:3000/about" class="hover:translate-x-2 transition-all duration-300 origin-top-left text-gray-400 mb-3">About Us</a>
                    <a href="http://127.0.0.1:3000/careers" class="hover:translate-x-2 transition-all duration-300 origin-top-left text-gray-400 mb-3">Careers</a>
                    <a href="http://127.0.0.1:3000/faqs" class="hover:translate-x-2 transition-all duration-300 origin-top-left text-gray-400 mb-3">Faqs</a>
                    <a href="http://127.0.0.1:3000/videos" class="hover:translate-x-2 transition-all duration-300 origin-top-left text-gray-400 mb-3">Videos</a>
                    <a href="http://127.0.0.1:3000/contact" class="hover:translate-x-2 transition-all duration-300 origin-top-left text-gray-400 mb-3">Contact</a>
                    <a href="http://127.0.0.1:3000/privacy-policy" class="hover:translate-x-2 transition-all duration-300 origin-top-left text-gray-400 mb-3">Privacy Policy</a>
                    <a href="http://127.0.0.1:3000/login" class="hover:translate-x-2 transition-all duration-300 origin-top-left text-gray-400 mb-3">Login</a>

                </div>

            </div>

            <div>
                <div class="flex items-center mt-6">
                    <span class="text-white text-lg font-bold">Follow Us</span>
                    <div class="ml-2 bg-primary-color h-1 w-24"></div>
                </div>

                <div class="flex flex-col mt-4">
                    <a href="#" class="hover:translate-x-2 transition-all duration-300 origin-top-left text-gray-400 mb-5 flex items-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" viewBox="0 0 512 512"><path d="M459.37 151.716c.325 4.548.325 9.097.325 13.645 0 138.72-105.583 298.558-298.558 298.558-59.452 0-114.68-17.219-161.137-47.106 8.447.974 16.568 1.299 25.34 1.299 49.055 0 94.213-16.568 130.274-44.832-46.132-.975-84.792-31.188-98.112-72.772 6.498.974 12.995 1.624 19.818 1.624 9.421 0 18.843-1.3 27.614-3.573-48.081-9.747-84.143-51.98-84.143-102.985v-1.299c13.969 7.797 30.214 12.67 47.431 13.319-28.264-18.843-46.781-51.005-46.781-87.391 0-19.492 5.197-37.36 14.294-52.954 51.655 63.675 129.3 105.258 216.365 109.807-1.624-7.797-2.599-15.918-2.599-24.04 0-57.828 46.782-104.934 104.934-104.934 30.213 0 57.502 12.67 76.67 33.137 23.715-4.548 46.456-13.32 66.599-25.34-7.798 24.366-24.366 44.833-46.132 57.827 21.117-2.273 41.584-8.122 60.426-16.243-14.292 20.791-32.161 39.308-52.628 54.253z" fill="currentColor"></path></svg>
                        <span class="ml-2">Twitter</span>
                    </a>
                    <a href="#" class="hover:translate-x-2 transition-all duration-300 origin-top-left text-gray-400 mb-5 flex items-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" viewBox="0 0 512 512"><path d="M504 256C504 119 393 8 256 8S8 119 8 256c0 123.78 90.69 226.38 209.25 245V327.69h-63V256h63v-54.64c0-62.15 37-96.48 93.67-96.48 27.14 0 55.52 4.84 55.52 4.84v61h-31.28c-30.8 0-40.41 19.12-40.41 38.73V256h68.78l-11 71.69h-57.78V501C413.31 482.38 504 379.78 504 256z" fill="currentColor"></path></svg>
                        <span class="ml-2">Facebook</span>
                    </a>
                    <a href="#" class="hover:translate-x-2 transition-all duration-300 origin-top-left text-gray-400 mb-5 flex items-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" viewBox="0 0 448 512"><!--! Font Awesome Pro 6.1.1 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2022 Fonticons, Inc. --><path d="M100.28 448H7.4V148.9h92.88zM53.79 108.1C24.09 108.1 0 83.5 0 53.8a53.79 53.79 0 0 1 107.58 0c0 29.7-24.1 54.3-53.79 54.3zM447.9 448h-92.68V302.4c0-34.7-.7-79.2-48.29-79.2-48.29 0-55.69 37.7-55.69 76.7V448h-92.78V148.9h89.08v40.8h1.3c12.4-23.5 42.69-48.3 87.88-48.3 94 0 111.28 61.9 111.28 142.3V448z" fill="currentColor"></path></svg>
                        <span class="ml-2">LinkedIn</span>
                    </a>
                    <a href="#" class="hover:translate-x-2 transition-all duration-300 origin-top-left text-gray-400 mb-5 flex items-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" viewBox="0 0 576 512"><!--! Font Awesome Pro 6.1.1 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2022 Fonticons, Inc. --><path d="M549.655 124.083c-6.281-23.65-24.787-42.276-48.284-48.597C458.781 64 288 64 288 64S117.22 64 74.629 75.486c-23.497 6.322-42.003 24.947-48.284 48.597-11.412 42.867-11.412 132.305-11.412 132.305s0 89.438 11.412 132.305c6.281 23.65 24.787 41.5 48.284 47.821C117.22 448 288 448 288 448s170.78 0 213.371-11.486c23.497-6.321 42.003-24.171 48.284-47.821 11.412-42.867 11.412-132.305 11.412-132.305s0-89.438-11.412-132.305zm-317.51 213.508V175.185l142.739 81.205-142.739 81.201z" fill="currentColor"></path></svg>
                        <span class="ml-2">YouTube</span>
                    </a>
                    <a href="#" class="hover:translate-x-2 transition-all duration-300 origin-top-left text-gray-400 mb-5 flex items-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" viewBox="0 0 448 512"><!--! Font Awesome Pro 6.1.1 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2022 Fonticons, Inc. --><path d="M224.1 141c-63.6 0-114.9 51.3-114.9 114.9s51.3 114.9 114.9 114.9S339 319.5 339 255.9 287.7 141 224.1 141zm0 189.6c-41.1 0-74.7-33.5-74.7-74.7s33.5-74.7 74.7-74.7 74.7 33.5 74.7 74.7-33.6 74.7-74.7 74.7zm146.4-194.3c0 14.9-12 26.8-26.8 26.8-14.9 0-26.8-12-26.8-26.8s12-26.8 26.8-26.8 26.8 12 26.8 26.8zm76.1 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9s58 34.4 93.9 36.2c37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.8 0-184.8zM398.8 388c-7.8 19.6-22.9 34.7-42.6 42.6-29.5 11.7-99.5 9-132.1 9s-102.7 2.6-132.1-9c-19.6-7.8-34.7-22.9-42.6-42.6-11.7-29.5-9-99.5-9-132.1s-2.6-102.7 9-132.1c7.8-19.6 22.9-34.7 42.6-42.6 29.5-11.7 99.5-9 132.1-9s102.7-2.6 132.1 9c19.6 7.8 34.7 22.9 42.6 42.6 11.7 29.5 9 99.5 9 132.1s2.7 102.7-9 132.1z" fill="currentColor"></path></svg>
                        <span class="ml-2">Instagram</span>
                    </a>
                </div>

            </div>

        </div>
    </div>
</div>
<div class="bg-zinc-900 p-4">
    <div class="text-xs text-gray-400 text-center text-lg">Copyright © 2024 Esoftech </div>
</div>

    <script>
        $(function () {
            $('.feedback').slick({
                slidesToShow : 2,
                arrows: false,
                dots: true,
                autoplay : true
            });

            $('.companies').slick({
                slidesToShow: 6,
                arrows: false,
                dots: true,
                autoplay : true
            })

        });
    </script>




</body>
</html>

<?php /**PATH /home/truetransit/public_html/linkmanagement.net/resources/views/frontend/layouts/master.blade.php ENDPATH**/ ?>