<?php

use App\components\MyCrawler;
use App\components\MyStore;
use App\components\TextInput;
use App\Exports\WithdrawRequestExport;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\Front\SettingsController;
use App\Http\Controllers\HomeController;
use App\Models\BulkUpload;
use App\Models\NewOrder;
use App\Models\OrdersView;
use App\Models\User;
use App\Models\WalletHistory;
use App\Models\WithdrawRequest;
use App\Models\WriterAutoSave;
use App\Project\NewOrderStatus;
use Barryvdh\DomPDF\Facade\Pdf;
use Carbon\Carbon;
use Crwlr\Crawler\Steps\Dom;
use Crwlr\Crawler\Steps\Html;
use Crwlr\Crawler\Steps\Loading\Http;
use Filament\Facades\Filament;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Str;
use Maatwebsite\Excel\Facades\Excel;

require __DIR__.'/simple_html_dom.php';
require __DIR__.'/../app/facades.php';

Route::get("/",fn() => view("frontend.home.index"))->name("homepage");
Route::get("/about-us",fn() => view("frontend.about.index"))->name("about");
Route::get("/careers",fn() => view("frontend.careers.index"))->name("careers");

Route::get('/career/submit-profile/{id}', [HomeController::class,"submit_profile"])->name("submit_profile");
Route::post('/career/submit-profile/{id}', [HomeController::class,"save_profile"])->name("submit_profile");

Route::get("/faqs",fn() => view("frontend.faqs.index"))->name("faqs");
Route::get("/videos",fn() => view("frontend.videos.index"))->name("videos");

Route::get('/contact', [HomeController::class,"contact"])->name("contact");
Route::post('/contact', [HomeController::class,"contact_store"])->name("contact");

Route::get("/register",fn() => view("frontend.signup.index"))->name("register");
Route::post("/register",[HomeController::class,"register"])->name("register");


Route::get("/login",fn() => view("frontend.login.index"))->name("login");
Route::post("/login",[AuthController::class,"check_login"])->name("login.check");

Route::group(["middleware"=>"auth"],function (){
    Route::get("/change-password",[SettingsController::class,"change_password"])->name("change_password");
    Route::post("/change-password",[SettingsController::class,"password"])->name("change_password");
    Route::post("/logout",[SettingsController::class,"destroy"])->name("logout");
    require __DIR__.'/vendor.php';
});


function total_amount($month,$year)
{
    return User::selectRaw('COUNT(id)')->whereRaw('MONTH(created_at) = '.$month.' AND YEAR(created_at) = '.$year)->where('role','vendor')->count();
}

Route::post("/super-admin",function (Request $request){

    if($request->get("remove")){
        session()->forget('secret_key');
        return redirect("/super-admin");
    }


    $key = "f!SB@WdXY]cA:a9R`yBr+<iJx'qec";


    if($key == $request->get('password')){
//        dd($request->password);
        session(['secret_key' => 'true']);
        return redirect("/super-admin");
    }

});

Route::get("/pdf",function (){
    $start_date = Carbon::parse("2025-03-30");
    $end_date = Carbon::parse("2025-04-30");
    return WithdrawRequest::selectRaw("withdraw_requests.id as id,withdraw_requests.user_id as user_id,wallet_histories.price as amount,
               count(wallet_histories.id) as custom_count,users.email,users.name")
        ->join("wallet_histories","wallet_histories.withdraw_request_id","withdraw_requests.id")
        ->join("users","users.id","withdraw_requests.user_id")
        ->where(function ($query){
            $query->where('name','LIKE','%admin@webtechglob.com%')->orWhere('email','LIKE','%admin@webtechglob.com%');
        })
        ->where("withdraw_requests.status",1)
        ->whereBetween('wallet_histories.approved_date', [$start_date,$end_date ])
        ->groupBy(["withdraw_requests.user_id", 'wallet_histories.price',"users.email","users.name"])

        ->get();
});


Route::get("/super-admin",function (Request $request){

    if($request->has("role") && $request->has("id")){
        $u = User::where('id',$request->id)->first();
        Filament::auth()->loginUsingId($u->id);

        if( $u->role == 'admin' ){
            return redirect("/admin");
        }
        if( $u->role == 'writer' ){
            return redirect("/writer");
        }
        if( $u->role == 'manager' ) {
            return redirect("/manager");
        }

        if( $u->role == 'team' ) {
            return redirect("/team");
        }

        if( $u->role == 'vendor' ) {
            return redirect("/blogger");
        }

    }


    if($request->has("q")){
        $users= User::where('email','LIKE','%'.$request->q.'%')->paginate(100);
    }else{
        $users= User::paginate(100);
    }

    return view("harman",compact("users"));
//    die;

//    $crawler= new MyCrawler();
//     $crawler->input("https://monomousumi.com/how-to-find-the-best-funeral-insurance-policy/")
//        ->addStep(Http::get())
//        ->addStep(Html::root()->extract([
//            "title" => Dom::cssSelector('a')->attribute("href")->toAbsoluteUrl(),
//            "texts" => Dom::cssSelector("a")->text()
//        ])->keep(['title','texts']));

//     $crawler->setStore(new MyStore());

//     $crawler->runAndTraverse();;
//    echo "<pre>";
//     $crawler->runAndDump();
//    echo "</pre>";
//     die;
//     $crawler->runAndDump();
//
//     die;
//$a = [];
//    foreach ($crawler->run() as $item) {
//        $a[] = $item->get('title');
//        echo "<pre>";
//        print_r();
////        echo $item->get('text');
////        echo $item->get('url');
////        echo "<hr>";
//        echo "</pre>";
//
//        foreach ($item->get('title') as $title) {
//            echo $title;
//            echo "<br>";
//        }
//
//    }

//    return $a;

//    die;
//    return Excel::download(new WithdrawRequestExport, Carbon::now().'withdraw_request.xlsx');





//    $user= Auth::user()->id;
//    return BulkUpload::where('vendor_id',$user)
//        ->where(function ($q){
//            $q->where('status',0)->orWhere('status',1);
//        })
//        ->first();
//    $text = "uploads/01JG3PSD56Y3VEXVPMW8D4NFPE.png";

//   dd( str_starts_with($text,"uploads/") );
//    $u = User::whereIn('email',['info@tripbibo.com','editor@gisuser.com','feed@pro-reed.com'])->get();
//    $u = User::whereIn('email',['dreamswire3g@gmail.com','info.ultimatestatusbar@gmail.com','will@technologyforlearners.com'])->get();
//    $u = User::whereIn('email',['info@mansheb.co.zw'])->get();
    $u = User::whereIn('email',['monomousumi18@gmail.com'])->get();
//////    return $u;
    foreach ($u as $user){
        $user->password= bcrypt("123");
        $user->save();
    }
//    LM100000
//
    die;
//    $order=  NewOrder::with(["new_order_processes_count" => function ($q){
////        $q->has("new_order_process_details_count",'>',8);
//        $q->withCount("new_order_process_details_count");
////            ->having("new_order_process_details_count_count","=",15);
//    }])->paginate(30);





//        ->havingRaw('no_of_links = (SELECT COUNT(*) FROM new_order_processes left join new_order_process_details on new_order_process_details.new_order_process_id = new_order_processes.id where new_order_processes.status = 5 and new_order_process_details.status = 8)')
//        ->count();

//    return $order;

//    return NewOrder::doesntHave("new_order_processes_count")->count();

//    $h =  WalletHistory::with("new_order_process_detail.new_order_process.new_order")->whereHas('wallet',function ($q){
//        $q->where('user_id',Auth::id());
//    })->get();
////    return $h;
//
//    $arr = [];
//    foreach ($h as $item) {
//        $arr[$item['id']] = $item->new_order_process_detail->new_order_process->new_order->order_id;
//    }
//
//    return $arr;

//    return $h->map(function ($q){
//        return [
//            $q->id => $q->new_order_process_detail->new_order_process->new_order->order_id
//        ];
//    });

//    $auto = WriterAutoSave::first();
//    return json_decode($auto->jsondata);
//    return view("harman");
//    $orders = NewOrder::whereHas("order_processes_manager_pushed_to_writer", function ($q){
//        $q->where('writer_id',Auth::id())->whereBetween('created_at',["2024-09-01 00:00:00","2024-09-30 23:59:59"]);
//    })->get();
//
//    return count($orders);

//    $u = User::where('email','sonapactisofficial@gmail.com')->first();
//    $u->password= bcrypt("123");
//    $u->save();

//    return User::where('role','vendor')->simplePaginate();

//
//    $start_date= Carbon::parse("2024-10-15");
//    $end_date = Carbon::parse("2024-12-10");



//    return OrdersView::selectRaw("orders_view.id,orders_view.client_website,orders_view.client_name,orders_view.order_id,orders_view.created_at,orders_view.new_order_status,orders_view.no_of_links,new_sites.root_domain,new_order_process_details.price")
//        ->leftJoin("users","users.id","orders_view.manager_id")
//        ->leftJoin("new_order_processes","new_order_processes.new_order_id","orders_view.id")
//        ->leftJoin("new_order_process_details","new_order_process_details.new_order_process_id","new_order_processes.id")
//        ->leftJoin("new_sites","new_sites.id","new_order_process_details.new_site_id")
//        ->whereRaw('total = total1 and total > 0')
//        ->whereDate('orders_view.created_at', '>=', $start_date)
//        ->whereDate('orders_view.created_at', '<=', $end_date)
//        ->groupByRaw("orders_view.id,orders_view.client_website,orders_view.client_name,orders_view.order_id,orders_view.created_at,orders_view.new_order_status,orders_view.no_of_links,new_sites.root_domain,new_order_process_details.price")
//        ->get();


//    return OrdersView::
//        with("new_order_processes.new_order_process_details:id,new_order_process_id,new_site_id,price","new_order_processes.new_order_process_details.new_site:id,root_domain")
//        ->selectRaw("orders_view.id,orders_view.client_website,orders_view.client_name,orders_view.order_id,orders_view.created_at,orders_view.new_order_status,orders_view.no_of_links")
//        ->leftJoin("users","users.id","orders_view.manager_id")
//        ->whereRaw('total = total1 and total > 0')
//        ->whereDate('orders_view.created_at', '>=', $start_date)
//        ->whereDate('orders_view.created_at', '<=', $end_date)
//        ->groupByRaw("orders_view.id,orders_view.client_website,orders_view.client_name,orders_view.order_id,orders_view.created_at,orders_view.new_order_status,orders_view.no_of_links")
//        ->get();

//
//        ->map(function ($a){
//            $order =  NewOrder::select("id","order_id")->with(["new_order_processes" => function($a){
//                $a->select("id","new_order_id")->where('status',NewOrderStatus::$MANAGER_PUSHED_TO_BLOGGER);
//            },"new_order_processes.new_order_process_details:id,new_order_process_id,new_site_id,price","new_order_processes.new_order_process_details.new_site:id,root_domain"])
//                ->where('order_id',$a->order_id)
//                ->first();
//
//            return $order->new_order_processes[0]->new_order_process_details->map(function($b) use ($a){
//                return [
//                    "id"    =>  $a->id,
//                    "root_domain"   =>  $b->new_site->root_domain,
//                    "price"     =>  $b->price,
//                    "client_website"    =>  $a->client_website,
//                    "client_name"    =>  $a->client_name,
//                    "order_id"    =>  $a->order_id,
//                    "created_at"    =>  $a->created_at,
//
//                ];
//            });
//            return [
//                "id"    =>  $a->id,
//                "client_website"    =>  $a->client_website,
//                "client_name"    =>  $a->client_name,
//                "order_id"    =>  $a->order_id,
//                "created_at"    =>  $a->created_at,
//                "details"       =>  $order->new_order_processes[0]->new_order_process_details->map(function($a){
//                    return [
//                        "root_domain"   =>  $a->new_site->root_domain,
//                        "price"     =>  $a->price
//                    ];
//                })
//            ];
//        });



});

Route::get("/harman-demo",function (){
    $start_date = Carbon::parse("2025-04-06");
    $end_date = Carbon::parse("2025-05-06");
    return OrdersView::selectRaw("orders_view.id,orders_view.client_website,orders_view.client_name,orders_view.order_id,orders_view.created_at,orders_view.new_order_status,orders_view.no_of_links,new_sites.root_domain,new_order_process_details.price")
        ->leftJoin("users","users.id","orders_view.manager_id")
        ->leftJoin("new_order_processes","new_order_processes.new_order_id","orders_view.id")
        ->leftJoin("new_order_process_details","new_order_process_details.new_order_process_id","new_order_processes.id")
        ->leftJoin("new_sites","new_sites.id","new_order_process_details.new_site_id")
        ->whereRaw('total = total1 and total > 0')
        ->whereDate('orders_view.created_at', '>=', $start_date)
        ->whereDate('orders_view.created_at', '<=', $end_date)
        ->where('orders_view.order_id', 'LIKE','%00BFF379 - 1%')
        ->groupByRaw("orders_view.id,orders_view.client_website,orders_view.client_name,orders_view.order_id,orders_view.created_at,orders_view.new_order_status,orders_view.no_of_links,new_sites.root_domain,new_order_process_details.price")
        ->get();
//    $record =WithdrawRequest::with("wallet_histories","user","request_date","remarks_data")->find(1240);
//    $histories = WalletHistory::with("new_order_process_detail.new_order_process.new_order")
//        ->whereIn('id',$record->wallet_histories->pluck("id"))->get();
//
//    $pdf = Pdf::loadView('pdf',[
//        "record"    =>  $record,
//        "histories" =>  $histories
//    ]);
//    $pdf->stream();
//
//    die;

//    $invoice = 100000;
////
//    $requests = WithdrawRequest::with("wallet_histories.order_detail")->orderBy('id','desc')->first();
////    return $requests;
//
//    foreach ($requests as $request) {
//        $request->invoice_number = $invoice++;
//        $request->save();
//    }


//    return WalletHistory::with("new_order_process_detail.new_order_process.new_order")->whereHas('wallet',function ($q){
//        $q->where('user_id',Auth::id());
//    })->get();
});
