<?php

use App\Http\Controllers\Vendor\BankController;
use App\Http\Controllers\Vendor\DashboardController;
use App\Http\Controllers\Vendor\MessageController;
use App\Http\Controllers\Vendor\MyOrderController;
use App\Http\Controllers\Vendor\NewSiteController;
use App\Http\Controllers\Vendor\OrderNotificationController;
use App\Http\Controllers\Vendor\PaymentController;
use App\Http\Controllers\Vendor\SiteController;
use App\Http\Controllers\Vendor\WalletController;
use App\Http\Middleware\VendorMiddleware;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Route;

Route::group(["middleware"=>VendorMiddleware::class,"prefix"=>"vendor"],function (){
    Route::get("/dashboard",[DashboardController::class,"index"])->name("vendor.dashboard");
    Route::get("/payment-details",[DashboardController::class,"payment_details"])->name("vendor.payment_details");
    Route::get("/new-design",[DashboardController::class,"new_design"])->name("vendor.new_design");



    //Profile
    Route::get("/view-profile",[DashboardController::class,"view_profile"])->name("vendor.view_profile");
    Route::get("/profile",[DashboardController::class,"profile"])->name("vendor.profile");
    Route::post("/profile",[DashboardController::class,"update_profile"])->name("vendor.update_profile");


    Route::get("/sites",[SiteController::class,"sites"])->name("vendor.sites");
    Route::get("/sites/upload-excel",[SiteController::class,"upload_excel"])->name("vendor.upload_excel");
    Route::post("/sites/upload-excel",[SiteController::class,"upload_save_excel"])->name("vendor.upload_excel");
    Route::get("/sites/uploaded-sites/{id}",[SiteController::class,"uploaded_sites"])->name("vendor.uploaded_sites");
    Route::get("/sites/{id}",[SiteController::class,"view"])->name("vendor.site_view");

    Route::get("/tasks-in-process",[SiteController::class,"tasks_in_process"])->name("vendor.tasks_in_process");
    Route::get("/completed-tasks",[SiteController::class,"tasks_in_process"])->name("vendor.completed_tasks");
    Route::get("/order-detail/{id}",[SiteController::class,"order_detail"])->name("vendor.order_detail");
    Route::post("/change-status",[SiteController::class,"change_status"])->name("vendor.change_status");


    Route::get("wallet",[WalletController::class,"index"])->name("vendor.wallet_index");
    Route::get("request-withdrawal",[WalletController::class,"withdraw_request"])->name("vendor.withdraw_request");
    Route::post("request-withdrawal",[WalletController::class,"request_withdrawal"])->name("vendor.request_withdrawal");

    Route::get("/setup-payment-method",[PaymentController::class,"setup_payment_method"])->name("vendor.setup_payment_method");

    Route::post("/setup-paypal",[PaymentController::class,"setup_paypal_store"])->name("vendor.setup_paypal");

    Route::get("/site-create",[SiteController::class,"site_create"])->name("vendor.site_create");
    Route::post("/site-create",[SiteController::class,"site_store"])->name("vendor.site_create");

    Route::resource("new-site",NewSiteController::class);

    Route::post("/bank-details",[BankController::class,"update_bank_details"])->name("vendor.bank_details");

    Route::get("/site-verification/{id}",[SiteController::class,"site_verification"])->name("vendor.site_verification");


    Route::get("/my-orders",[MyOrderController::class,"my_orders"])->name("vendor.my_orders");

    Route::get("/messages",[MessageController::class,"index"])->name("vendor.messages");
    Route::get("/messages/threads/{id}",[MessageController::class,"messages"])->name("vendor.messages.detail");
    Route::get("/messages/create",[MessageController::class,"create"])->name("vendor.messages.create");

    Route::get("/completed-orders",[OrderNotificationController::class,"completed_orders"])->name("vendor.completed_orders");
    Route::get("/completed-orders/{id}",[OrderNotificationController::class,"view_completed_orders"])->name("vendor.view_completed_orders");

    Route::get("/pending-order-notification-from-manager",[OrderNotificationController::class,"pending_order_notification_from_manager"])->name("vendor.pending_order_notification_from_manager");
    Route::get("/rejected-order-notification-from-manager",[OrderNotificationController::class,"rejected_order_notification_from_manager"])->name("vendor.rejected_order_notification_from_manager");
    Route::post("/pending-order-notification-from-manager/{id}",[OrderNotificationController::class,"post_pending_order"])->name("vendor.post_pending_order");

    Route::get("/demo",function (){
        $u = User::where('email','mfriedman@skopemagazine.com')->first();
        return $u;
//        //SELECT sum( IF(type = 'debit', -price, price ) ) as balance  FROM `wallets`
//        //inner join wallet_histories on wallets.id = wallet_histories.wallet_id
//        //where  wallets.user_id = 2339
//        $wallet =  DB::table("wallets")
//                    ->selectRaw("sum( IF(type = 'debit', -price, price ) ) as balance")
//                    ->join("wallet_histories","wallets.id","wallet_histories.wallet_id")
//                    ->where('wallets.user_id',Auth::user()->id)
//                    ->first();
//        return $wallet->balance ?? 0;
//        return 'Exit';

//        $url= "www.google.com";
//        $split =    parse_url($url);
//        if( isset($split['host']) ){
//            return str_replace('www.','',$split['host']);
//        }
//        if( isset($split['path']) ){
//            return str_replace('www.','',$split['path']);
//        }
    });

});
