@extends("vendor.layouts.app")

@section("container")
    <div class="max-w-screen-2xl px-8 mx-auto ">
        <div class="bg-white p-4 mt-4 shadow">
            <table class="table-fixed w-full">
                <thead class="bg-blue-500">
                <tr>
                    <th class="px-2 py-4 text-xs border border-gray-200 text-white">View</th>
                    <th class="px-2 py-4 text-xs border border-gray-200 text-white">Order Id</th>
                    <th class="px-2 py-4 text-xs border border-gray-200 text-white">Order Date</th>
                    <th class="px-2 py-4 text-xs border border-gray-200 text-white">Team Email</th>
                    <th class="px-2 py-4 text-xs border border-gray-200 text-white">Site URL</th>
                </tr>
                </thead>
                <tbody>
                @foreach($orders as $order)
                    <tr>
                        <td class="text-xs px-2 py-2 border border-gray-200 text-center">
                            <a href="{{ route("vendor.order_detail",$order->id) }}" class="bg-blue-500 text-sm px-3 py-1 text-white">view details</a>
                        </td>
                        <td class="text-xs px-2 py-2 border border-gray-200 text-center">{{ optional($order->order)->orderid }}</td>
                        <td class="text-xs px-2 py-2 border border-gray-200 text-center">{{ $order->created_at->toDayDateTimeString() }}</td>
                        <td class="text-xs px-2 py-2 border border-gray-200 text-center">{{ optional($order->site)->user->email }}</td>
                        <td class="text-xs px-2 py-2 border border-gray-200 text-center">{{ optional($order->site)->domain_type ."".optional($order->site)->domain_name }}</td>

                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
